/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.widget.button;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.client.config.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.config.gui.screen.list.ListScreen;
import mod.adrenix.nostalgic.client.config.gui.widget.button.RemoveType;
import mod.adrenix.nostalgic.client.config.gui.widget.list.ConfigRowList;
import mod.adrenix.nostalgic.util.common.ItemCommonUtil;
import mod.adrenix.nostalgic.util.common.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class RemoveButton
extends Button {
    private static final int START_X = 0;
    private static final int START_Y = 0;
    private static final Component DISABLE_TITLE = Component.m_237115_((String)"gui.nostalgic_tweaks.button.disable");
    private static final Component ENABLE_TITLE = Component.m_237115_((String)"gui.nostalgic_tweaks.button.enable");
    private static final Component REMOVE_TITLE = Component.m_237115_((String)"gui.nostalgic_tweaks.button.remove");
    private static final Component UNDO_TITLE = Component.m_237115_((String)"gui.nostalgic_tweaks.button.undo");
    private final Supplier<Boolean> isRemoved;
    private final RemoveType removeType;
    private final String resourceKey;

    private static int getRemoveWidth() {
        Font font = Minecraft.m_91087_().f_91062_;
        int disableWidth = font.m_92895_(DISABLE_TITLE.getString());
        int enableWidth = font.m_92895_(ENABLE_TITLE.getString());
        int removeWidth = font.m_92895_(REMOVE_TITLE.getString());
        int undoWidth = font.m_92895_(UNDO_TITLE.getString());
        return MathUtil.getLargest(disableWidth, enableWidth, removeWidth, undoWidth) + 8;
    }

    private static Component getRemoveTitle(RemoveType removeType, Supplier<Boolean> isRemoved) {
        return switch (removeType) {
            default -> throw new IncompatibleClassChangeError();
            case RemoveType.SAVED -> {
                if (isRemoved.get().booleanValue()) {
                    yield UNDO_TITLE;
                }
                yield REMOVE_TITLE;
            }
            case RemoveType.DEFAULT -> isRemoved.get() != false ? ENABLE_TITLE : DISABLE_TITLE;
        };
    }

    private static void onPress(Supplier<Boolean> isRemoved, Runnable onRemove, Runnable onUndo) {
        if (isRemoved.get().booleanValue()) {
            onUndo.run();
        } else {
            onRemove.run();
        }
    }

    public RemoveButton(RemoveType removeType, String resourceKey, Supplier<Boolean> isRemoved, Runnable onRemove, Runnable onUndo) {
        super(0, 0, RemoveButton.getRemoveWidth(), 20, RemoveButton.getRemoveTitle(removeType, isRemoved), button -> RemoveButton.onPress(isRemoved, onRemove, onUndo));
        this.resourceKey = resourceKey;
        this.removeType = removeType;
        this.isRemoved = isRemoved;
    }

    private void updateX() {
        if (this.f_93620_ == 0) {
            this.f_93620_ = ConfigRowList.getInstance().m_5759_() + 1;
        }
        if (ConfigRowList.getInstance().isTooLong(this.f_93620_ + RemoveButton.getRemoveWidth())) {
            int endX;
            int startX = endX = this.f_93620_ + this.f_93618_ - 1;
            while (ConfigRowList.getInstance().isTooLong(endX)) {
                --endX;
            }
            this.f_93620_ -= startX - endX + 4;
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        Screen screen;
        this.m_93666_(RemoveButton.getRemoveTitle(this.removeType, this.isRemoved));
        this.updateX();
        if (this.removeType == RemoveType.DEFAULT && (screen = Minecraft.m_91087_().f_91080_) instanceof ListScreen) {
            ListScreen listScreen = (ListScreen)screen;
            boolean bl = this.f_93623_ = !listScreen.isItemSaved(ItemCommonUtil.getItem(this.resourceKey));
        }
        if (Overlay.isOpened()) {
            this.f_93623_ = false;
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

