/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.widget.button;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import mod.adrenix.nostalgic.client.config.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.config.gui.screen.list.ListScreen;
import mod.adrenix.nostalgic.client.config.gui.widget.button.KeyBindButton;
import mod.adrenix.nostalgic.client.config.gui.widget.input.ColorInput;
import mod.adrenix.nostalgic.client.config.reflect.TweakClientCache;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public class ResetButton
extends Button {
    private static final int START_X = 0;
    private static final int START_Y = 0;
    private static final Component RESET_TITLE = Component.m_237115_((String)"gui.nostalgic_tweaks.button.reset");
    private static final Component UNDO_TITLE = Component.m_237115_((String)"gui.nostalgic_tweaks.button.undo");
    private final Supplier<Boolean> isEntryChanged;
    private final AbstractWidget controller;
    @CheckForNull
    private final TweakClientCache<?> tweak;

    private static int getResetWidth() {
        Font font = Minecraft.m_91087_().f_91062_;
        int resetWidth = font.m_92895_(RESET_TITLE.getString());
        int undoWidth = font.m_92895_(UNDO_TITLE.getString());
        return Math.max(resetWidth, undoWidth) + 8;
    }

    private static Component getResetTitle(Supplier<Boolean> isChanged) {
        return isChanged.get() != false ? UNDO_TITLE : RESET_TITLE;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void resetTweak(@Nullable TweakClientCache<?> cache, AbstractWidget controller) {
        Object obj;
        if (cache == null) {
            if (!(controller instanceof KeyBindButton)) return;
            KeyBindButton key = (KeyBindButton)controller;
            key.reset();
            return;
        }
        cache.reset();
        if (controller instanceof EditBox) {
            EditBox input = (EditBox)controller;
            obj = cache.getValue();
            if (obj instanceof String) {
                String value = (String)obj;
                input.m_94144_(value);
                return;
            }
        }
        if (!(controller instanceof ColorInput)) return;
        ColorInput color = (ColorInput)controller;
        obj = cache.getValue();
        if (!(obj instanceof String)) return;
        String value = (String)obj;
        ((EditBox)color.getWidget()).m_94144_(value);
    }

    public ResetButton(@Nullable TweakClientCache<?> tweak, AbstractWidget controller) {
        super(0, 0, ResetButton.getResetWidth(), 20, RESET_TITLE, button -> ResetButton.resetTweak(tweak, controller));
        this.tweak = tweak;
        this.controller = controller;
        this.isEntryChanged = () -> false;
        this.updateX();
    }

    public ResetButton(AbstractWidget controller, Supplier<Boolean> isChanged, Consumer<AbstractWidget> onReset) {
        super(0, 0, ResetButton.getResetWidth(), 20, ResetButton.getResetTitle(isChanged), button -> onReset.accept(controller));
        this.tweak = null;
        this.controller = controller;
        this.isEntryChanged = isChanged;
        this.updateX();
    }

    public AbstractWidget getController() {
        return this.controller;
    }

    private void updateX() {
        this.f_93620_ = this.controller.f_93620_ + this.controller.m_5711_() + 2;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        boolean isDisabled;
        this.m_93666_(ResetButton.getResetTitle(this.isEntryChanged));
        this.updateX();
        if (this.tweak != null) {
            this.f_93623_ = this.tweak.isResettable();
        } else {
            AbstractWidget abstractWidget = this.controller;
            if (abstractWidget instanceof KeyBindButton) {
                KeyBindButton key = (KeyBindButton)abstractWidget;
                this.f_93623_ = key.isResettable();
            }
        }
        boolean isAutoGenerated = this.tweak != null && this.tweak.getList() != null;
        boolean isNotListScreen = ClassUtil.isNotInstanceOf(Minecraft.m_91087_().f_91080_, ListScreen.class);
        boolean bl = isDisabled = isAutoGenerated && isNotListScreen;
        if (Overlay.isOpened() || isDisabled) {
            this.f_93623_ = false;
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

