/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.widget.button;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mod.adrenix.nostalgic.client.config.gui.screen.list.ListScreen;
import mod.adrenix.nostalgic.client.config.gui.widget.button.OverlapButton;
import mod.adrenix.nostalgic.client.config.gui.widget.button.StateWidget;
import mod.adrenix.nostalgic.util.client.ItemClientUtil;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import mod.adrenix.nostalgic.util.common.TextUtil;
import mod.adrenix.nostalgic.util.common.TextureLocation;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class StateButton
extends OverlapButton {
    private final StateWidget widget;
    private boolean state;

    private static Component getText(StateWidget widget) {
        return switch (widget) {
            case StateWidget.TAG -> Component.m_237113_((String)"#");
            case StateWidget.SWING -> Component.m_237113_((String)"?").m_130940_(ChatFormatting.BOLD);
            case StateWidget.CLEAR -> Component.m_237113_((String)"\u274c").m_130940_(ChatFormatting.DARK_RED).m_130940_(ChatFormatting.BOLD);
            case StateWidget.LIGHTNING -> Component.m_237113_((String)"\u26a1").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.BOLD);
            default -> Component.m_237119_();
        };
    }

    public StateButton(StateWidget widget, int startX, int startY, boolean defaultState, Button.OnPress onPress) {
        super(startX, startY, 20, 20, StateButton.getText(widget), onPress);
        this.widget = widget;
        this.state = defaultState;
    }

    public StateButton(StateWidget widget, int startX, int startY, Button.OnPress onPress) {
        this(widget, startX, startY, true, onPress);
    }

    public boolean getState() {
        return this.state;
    }

    private List<Component> getTooltip() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        MutableComponent hide = Component.m_237115_((String)"gui.nostalgic_tweaks.config.state.hide").m_130940_(ChatFormatting.GRAY);
        MutableComponent shift = Component.m_237115_((String)"gui.nostalgic_tweaks.config.state.shift").m_130940_(ChatFormatting.GRAY);
        MutableComponent title = switch (this.widget) {
            default -> throw new IncompatibleClassChangeError();
            case StateWidget.TAG -> Component.m_237115_((String)"gui.nostalgic_tweaks.config.state.tag").m_130940_(ChatFormatting.GREEN);
            case StateWidget.NUKE -> Component.m_237115_((String)"gui.nostalgic_tweaks.config.state.nuke").m_130940_(ChatFormatting.RED);
            case StateWidget.SWING -> Component.m_237115_((String)"gui.nostalgic_tweaks.config.state.swing").m_130940_(ChatFormatting.BLUE);
            case StateWidget.CLEAR -> Component.m_237115_((String)"gui.nostalgic_tweaks.config.state.clear").m_130940_(ChatFormatting.RED);
            case StateWidget.FUZZY -> Component.m_237115_((String)"gui.nostalgic_tweaks.config.state.fuzzy").m_130940_(ChatFormatting.GOLD);
            case StateWidget.BUBBLE -> Component.m_237115_((String)"gui.nostalgic_tweaks.config.state.bubble").m_130940_(ChatFormatting.AQUA);
            case StateWidget.FILTER -> Component.m_237115_((String)"gui.nostalgic_tweaks.config.state.filter").m_130940_(ChatFormatting.GOLD);
            case StateWidget.LIGHTNING -> Component.m_237115_((String)"gui.nostalgic_tweaks.config.state.tag.lightning").m_130940_(ChatFormatting.YELLOW);
        };
        List<Component> wrap = switch (this.widget) {
            default -> throw new IncompatibleClassChangeError();
            case StateWidget.TAG -> TextUtil.Wrap.tooltip((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.state.tag.@Tooltip"), 35);
            case StateWidget.NUKE -> TextUtil.Wrap.tooltip((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.state.nuke.@Tooltip"), 35);
            case StateWidget.SWING -> TextUtil.Wrap.tooltip((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.state.swing.@Tooltip"), 30);
            case StateWidget.CLEAR -> TextUtil.Wrap.tooltip((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.state.clear.@Tooltip"), 40);
            case StateWidget.FUZZY -> TextUtil.Wrap.tooltip((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.state.fuzzy.@Tooltip"), 35);
            case StateWidget.BUBBLE -> TextUtil.Wrap.tooltip((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.state.bubble.@Tooltip"), 35);
            case StateWidget.FILTER -> TextUtil.Wrap.tooltip((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.state.filter.@Tooltip"), 40);
            case StateWidget.LIGHTNING -> TextUtil.Wrap.tooltip((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.state.tag.lightning.@Tooltip"), 35);
        };
        tooltip.add((Component)title);
        if (Screen.m_96638_()) {
            tooltip.addAll(wrap);
        } else {
            tooltip.add((Component)shift);
            tooltip.add((Component)hide);
        }
        return tooltip;
    }

    private void showTooltip(PoseStack poseStack, int mouseX, int mouseY) {
        this.screen.m_96597_(poseStack, this.getTooltip(), mouseX, mouseY);
    }

    @Override
    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6303_(poseStack, mouseX, mouseY, partialTick);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureLocation.WIDGETS);
        int uOffset = this.state ? 0 : 20;
        int blockX = this.f_93620_ + 2;
        int blockY = this.f_93621_ + 2;
        switch (this.widget) {
            case NUKE: {
                ItemClientUtil.renderGuiItem(new ItemStack((ItemLike)Items.f_41996_), blockX, blockY, 0.85f, -0.5f);
                break;
            }
            case BUBBLE: {
                this.screen.m_93228_(poseStack, this.f_93620_, this.f_93621_, uOffset, 123, this.f_93618_, this.f_93619_);
                break;
            }
            case FUZZY: 
            case FILTER: {
                this.screen.m_93228_(poseStack, this.f_93620_, this.f_93621_, uOffset, 143, this.f_93618_, this.f_93619_);
            }
        }
    }

    public void m_7428_(PoseStack poseStack, int mouseX, int mouseY) {
        if (this.shouldRenderToolTip(mouseX, mouseY) && !Screen.m_96637_()) {
            this.screen.renderLast.add(() -> this.showTooltip(poseStack, mouseX, mouseY));
        }
    }

    public void m_5691_() {
        if (ClassUtil.isNotInstanceOf((Object)this.screen, ListScreen.class)) {
            this.state = !this.state;
        }
        super.m_5691_();
    }
}

