/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.widget.button;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.config.gui.screen.config.ConfigScreen;
import mod.adrenix.nostalgic.client.config.gui.screen.config.ConfigWidgets;
import mod.adrenix.nostalgic.client.config.reflect.TweakClientCache;
import mod.adrenix.nostalgic.common.config.annotation.TweakData;
import mod.adrenix.nostalgic.common.config.reflect.TweakStatus;
import mod.adrenix.nostalgic.common.config.tweak.GuiTweak;
import mod.adrenix.nostalgic.server.config.reflect.TweakServerCache;
import mod.adrenix.nostalgic.util.client.NetUtil;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import mod.adrenix.nostalgic.util.common.MathUtil;
import mod.adrenix.nostalgic.util.common.TextUtil;
import mod.adrenix.nostalgic.util.common.TextureLocation;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class StatusButton
extends Button {
    private static boolean flipState = false;
    private static long currentTime = 0L;
    private final AbstractWidget anchor;
    private final TweakClientCache<?> tweak;
    @Nullable
    private final TweakServerCache<?> server;

    public static boolean isFlashOff() {
        return flipState;
    }

    public static void update() {
        if (currentTime == 0L) {
            currentTime = Util.m_137550_();
        }
        if (Util.m_137550_() - currentTime > 1000L) {
            currentTime = 0L;
            flipState = !flipState;
        }
    }

    public StatusButton(TweakClientCache<?> tweak, AbstractWidget anchor) {
        super(0, 0, 0, 0, (Component)Component.m_237119_(), ignored -> {});
        this.tweak = tweak;
        this.anchor = anchor;
        this.server = this.tweak.getServerTweak();
    }

    private boolean isTweakLocked() {
        if (this.tweak.isClient()) {
            return false;
        }
        if (Minecraft.m_91087_().f_91074_ != null) {
            return !NetUtil.isPlayerOp((Player)Minecraft.m_91087_().f_91074_);
        }
        return false;
    }

    private void renderTooltip(ConfigScreen screen, String langKey, PoseStack poseStack, int mouseX, int mouseY) {
        List<Component> tooltip = TextUtil.Wrap.tooltip((Component)Component.m_237115_((String)langKey), 40);
        screen.renderLast.add(() -> screen.m_96597_(poseStack, tooltip, mouseX, mouseY));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        boolean isRenderable;
        boolean isStatusProblem;
        Minecraft minecraft = Minecraft.m_91087_();
        TweakStatus tweakStatus = this.tweak.getStatus();
        TweakStatus serverStatus = this.server == null ? tweakStatus : this.server.getStatus();
        TweakData.Dynamic dynamic = this.tweak.getMetadata(TweakData.Dynamic.class);
        if (tweakStatus == TweakStatus.FAIL && serverStatus != TweakStatus.FAIL) {
            tweakStatus = serverStatus;
        }
        boolean isTweakDynamic = dynamic != null && minecraft.f_91073_ != null && tweakStatus != TweakStatus.FAIL && NetUtil.isMultiplayer();
        boolean isTweakLocked = this.isTweakLocked();
        boolean isNetVerified = NostalgicTweaks.isNetworkVerified() || this.tweak.isClient() || Minecraft.m_91087_().f_91073_ == null;
        boolean bl = isStatusProblem = !isNetVerified || isTweakLocked;
        if (tweakStatus == TweakStatus.LOADED && !isStatusProblem && !isTweakDynamic) {
            return;
        }
        if (!isTweakDynamic && !(isRenderable = ((Boolean)TweakClientCache.get(GuiTweak.DISPLAY_FEATURE_STATUS).getValue()).booleanValue()) && tweakStatus != TweakStatus.WARN) {
            return;
        }
        if (NetUtil.isMultiplayer() && tweakStatus == TweakStatus.WAIT) {
            tweakStatus = TweakStatus.FAIL;
        }
        if (ClassUtil.isNotInstanceOf(minecraft.f_91080_, ConfigScreen.class)) {
            return;
        }
        ConfigScreen screen = (ConfigScreen)minecraft.f_91080_;
        TweakStatus status = flipState ? TweakStatus.LOADED : tweakStatus;
        int uWidth = 4;
        int vHeight = 20;
        int xStart = this.anchor.f_93620_ - 2 - uWidth;
        int yStart = this.anchor.f_93621_;
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureLocation.WIDGETS);
        StatusButton.update();
        if (isStatusProblem && !flipState) {
            screen.m_93228_(poseStack, xStart, yStart, 21, 0, uWidth, vHeight);
        } else if (isTweakDynamic && !flipState) {
            screen.m_93228_(poseStack, xStart, yStart, 21, 21, uWidth, vHeight);
        } else {
            switch (status) {
                case LOADED: {
                    screen.m_93228_(poseStack, xStart, yStart, 14, 0, uWidth, vHeight);
                    break;
                }
                case WAIT: {
                    screen.m_93228_(poseStack, xStart, yStart, 14, 21, uWidth, vHeight);
                    break;
                }
                case WARN: {
                    screen.m_93228_(poseStack, xStart, yStart, 21, 0, uWidth, vHeight);
                    break;
                }
                case FAIL: {
                    screen.m_93228_(poseStack, xStart, yStart, 27, 0, uWidth, vHeight);
                }
            }
        }
        boolean isOverSymbol = MathUtil.isWithinBox(mouseX, mouseY, xStart, yStart, uWidth, vHeight);
        boolean isWithinList = ConfigWidgets.isInsideRowList(mouseY);
        if (isOverSymbol && isWithinList) {
            if (!isNetVerified) {
                this.renderTooltip(screen, "gui.nostalgic_tweaks.config.status.net", poseStack, mouseX, mouseY);
            } else if (isTweakLocked) {
                this.renderTooltip(screen, "gui.nostalgic_tweaks.config.status.perm", poseStack, mouseX, mouseY);
            } else if (isTweakDynamic) {
                String state = NostalgicTweaks.isNetworkVerified() && NetUtil.isPlayerOp() ? "gui.nostalgic_tweaks.config.status.dynamic.op" : (NostalgicTweaks.isNetworkVerified() ? "gui.nostalgic_tweaks.config.status.dynamic.off" : "gui.nostalgic_tweaks.config.status.dynamic.on");
                this.renderTooltip(screen, state, poseStack, mouseX, mouseY);
            } else {
                switch (tweakStatus) {
                    case WAIT: {
                        this.renderTooltip(screen, "gui.nostalgic_tweaks.config.status.wait", poseStack, mouseX, mouseY);
                        break;
                    }
                    case WARN: {
                        this.renderTooltip(screen, "gui.nostalgic_tweaks.config.status.warn", poseStack, mouseX, mouseY);
                        break;
                    }
                    case FAIL: {
                        this.renderTooltip(screen, "gui.nostalgic_tweaks.config.status.fail", poseStack, mouseX, mouseY);
                    }
                }
            }
        }
    }
}

