/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.widget.group;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.client.config.gui.widget.list.ConfigRowList;
import mod.adrenix.nostalgic.client.config.gui.widget.list.row.ConfigRowBuild;
import mod.adrenix.nostalgic.util.common.TextureLocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class RadioGroup<E extends Enum<E>>
extends AbstractWidget {
    private ArrayList<ConfigRowList.Row> cache;
    private final ConfigRowList list = ConfigRowList.getInstance();
    private final Class<E> radios;
    private final E defaultValue;
    private final OnPress<E> onPress;
    private final Supplier<E> currentValue;
    private final Function<E, Component> label;

    public RadioGroup(Class<E> radios, E defaultValue, Supplier<E> currentValue, OnPress<E> onPress, Function<E, Component> label) {
        super(8, 0, 0, 20, (Component)Component.m_237119_());
        this.radios = radios;
        this.defaultValue = defaultValue;
        this.currentValue = currentValue;
        this.onPress = onPress;
        this.label = label;
    }

    private void generateRadioRow(ArrayList<ConfigRowList.Row> list, E option) {
        Radio<E> radio = new Radio<E>(option, this.defaultValue, this.currentValue, this.onPress, this.label);
        ConfigRowBuild.ManualRow row = new ConfigRowBuild.ManualRow(List.of(radio));
        list.add(row.generate());
    }

    public ArrayList<ConfigRowList.Row> getRows() {
        if (this.cache != null) {
            return this.cache;
        }
        ArrayList<ConfigRowList.Row> rows = new ArrayList<ConfigRowList.Row>();
        this.cache = rows;
        EnumSet.allOf(this.radios).forEach(option -> this.generateRadioRow(rows, option));
        return rows;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        ArrayList<ConfigRowList.Row> rows = this.getRows();
        ArrayList<Integer> found = new ArrayList<Integer>();
        for (ConfigRowList.Row listChild : this.list.m_6702_()) {
            for (ConfigRowList.Row enumChild : rows) {
                if (!((Object)((Object)listChild)).equals((Object)enumChild)) continue;
                found.add(1);
            }
        }
        if (found.size() != rows.size()) {
            this.getRows().forEach(row -> this.list.m_6702_().add(row));
        }
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    public static interface OnPress<E extends Enum<E>> {
        public void press(E var1);
    }

    private static class Radio<E extends Enum<E>>
    extends AbstractWidget {
        private final E value;
        private final E defaultValue;
        private final Supplier<E> currentValue;
        private final Function<E, Component> label;
        private final OnPress<E> onPress;

        public Radio(E value, E defaultValue, Supplier<E> currentValue, OnPress<E> onPress, Function<E, Component> label) {
            super(8, 0, 20, 20, (Component)Component.m_237119_());
            this.value = value;
            this.defaultValue = defaultValue;
            this.currentValue = currentValue;
            this.onPress = onPress;
            this.label = label;
        }

        public boolean isSelected() {
            return ((Enum)this.value).equals(this.currentValue.get());
        }

        public boolean isDefault() {
            return !this.isSelected() && ((Enum)this.value).equals(this.defaultValue);
        }

        public void m_5716_(double mouseX, double mouseY) {
            this.onPress.press(this.value);
            super.m_5716_(mouseX, mouseY);
        }

        public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)TextureLocation.WIDGETS);
            Minecraft minecraft = Minecraft.m_91087_();
            Screen screen = minecraft.f_91080_;
            if (screen == null) {
                return;
            }
            int uOffset = 0;
            int vOffset = 103;
            int uWidth = 20;
            int vHeight = 20;
            if (this.m_5953_(mouseX, mouseY)) {
                uOffset = 20;
                vOffset = this.isSelected() ? 63 : vOffset;
            } else if (this.isSelected()) {
                vOffset = 63;
            }
            screen.m_93228_(poseStack, this.f_93620_, this.f_93621_, uOffset, vOffset, uWidth, vHeight);
            MutableComponent defaultText = Component.m_237113_((String)(this.isDefault() ? String.format(" (%s)", Component.m_237115_((String)"gui.nostalgic_tweaks.config.default").getString()) : ""));
            MutableComponent optionText = Component.m_237113_((String)(this.label.apply(this.value).getString() + defaultText.getString()));
            RadioGroup.m_93243_((PoseStack)poseStack, (Font)Minecraft.m_91087_().f_91062_, (Component)optionText, (int)(this.f_93620_ + 24), (int)(this.f_93621_ + (this.f_93619_ - 8) / 2), (int)0xFFFFFF);
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }
    }
}

