/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.widget.input;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import mod.adrenix.nostalgic.client.config.gui.overlay.ColorPickerOverlay;
import mod.adrenix.nostalgic.client.config.gui.screen.config.ConfigScreen;
import mod.adrenix.nostalgic.client.config.gui.widget.list.ConfigRowList;
import mod.adrenix.nostalgic.client.config.reflect.ClientReflect;
import mod.adrenix.nostalgic.client.config.reflect.TweakClientCache;
import mod.adrenix.nostalgic.util.client.RenderUtil;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import mod.adrenix.nostalgic.util.common.ColorUtil;
import mod.adrenix.nostalgic.util.common.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;

public class ColorInput
extends AbstractWidget {
    private final EditBox input;
    private final TweakClientCache<String> tweak;

    public ColorInput(TweakClientCache<String> tweak) {
        super(ConfigRowList.getControlStartX(), 0, 120, 20, (Component)Component.m_237119_());
        this.f_93624_ = false;
        this.tweak = tweak;
        this.input = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 99, 18, (Component)Component.m_237119_());
        this.input.m_94199_(9);
        this.input.m_94182_(true);
        this.input.m_94194_(true);
        this.input.m_94202_(0xFFFFFF);
        this.input.m_94144_(this.clean(this.tweak.getValue()));
        this.input.m_94153_(this::filter);
        this.input.m_94151_(this::update);
    }

    public AbstractWidget getWidget() {
        return this.input;
    }

    public String clean(String input) {
        input = input.replaceAll("[^a-fA-F\\d]", "");
        return ("#" + input).trim().toUpperCase();
    }

    public boolean filter(String input) {
        if (((String)input).equals("#")) {
            return true;
        }
        if (!((String)(input = ((String)input).trim().toUpperCase())).startsWith("#")) {
            input = "#" + (String)input;
        }
        return ((String)input).matches("^#[a-fA-F\\d]+$");
    }

    public void update(String input) {
        String cached;
        if (!((String)input).startsWith("#")) {
            input = "#" + (String)input;
        }
        if ((cached = (String)ClientReflect.getCurrent(this.tweak.getGroup(), this.tweak.getKey())).equals(input)) {
            this.tweak.setValue(cached.trim().toUpperCase());
        } else {
            this.tweak.setValue(((String)input).trim().toUpperCase());
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (MathUtil.isWithinBox(mouseX, mouseY, this.f_93620_, this.f_93621_, 20.0, 20.0)) {
            new ColorPickerOverlay(this.tweak);
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        int color = ColorUtil.toHexInt(this.tweak.getValue());
        int border = this.input.m_93696_() ? -1 : -6250336;
        float leftX = this.f_93620_;
        float rightX = leftX + 20.0f;
        float topY = this.f_93621_;
        float bottomY = topY + 20.0f;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_69465_();
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.m_69472_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        RenderUtil.fill(buffer, matrix, leftX, rightX, topY, topY + 1.0f, border);
        RenderUtil.fill(buffer, matrix, leftX, rightX, bottomY - 1.0f, bottomY, border);
        RenderUtil.fill(buffer, matrix, leftX, leftX + 1.0f, topY, bottomY, border);
        RenderUtil.fill(buffer, matrix, leftX + 1.0f, rightX - 1.0f, topY + 1.0f, bottomY - 1.0f, color);
        tesselator.m_85914_();
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
        if (ClassUtil.isNotInstanceOf(Minecraft.m_91087_().f_91080_, ConfigScreen.class)) {
            return;
        }
        ConfigScreen screen = (ConfigScreen)Minecraft.m_91087_().f_91080_;
        if (MathUtil.isWithinBox(mouseX, mouseY, this.f_93620_, this.f_93621_, 20.0, 20.0)) {
            screen.renderLast.add(() -> screen.m_96602_(poseStack, (Component)Component.m_237115_((String)"gui.nostalgic_tweaks.overlay.input.@Tooltip"), mouseX, mouseY));
        }
        this.input.f_93620_ = this.f_93620_ + 21;
        this.input.f_93621_ = this.f_93621_ + 1;
        if (!this.input.m_94155_().equals(this.tweak.getValue())) {
            this.input.m_94144_(this.tweak.getValue());
        }
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }
}

