/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.widget.list;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.client.config.gui.widget.button.ContainerButton;
import mod.adrenix.nostalgic.client.config.gui.widget.group.TextGroup;
import mod.adrenix.nostalgic.client.config.gui.widget.list.ConfigRowList;
import mod.adrenix.nostalgic.mixin.widen.AbstractSelectionListAccessor;
import mod.adrenix.nostalgic.mixin.widen.AbstractWidgetAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRowList<R extends ContainerObjectSelectionList.Entry<R>>
extends ContainerObjectSelectionList<R> {
    private boolean isTransparentList = true;
    private final int originalItemHeight;
    private AbstractWidget tabLastSelectedWidget = null;

    public AbstractRowList(int width, int height, int startY, int endY, int rowHeight) {
        super(Minecraft.m_91087_(), width, height, startY, endY, rowHeight);
        this.f_93394_ = false;
        this.originalItemHeight = this.f_93387_;
    }

    public int getRowHeight() {
        return this.f_93387_;
    }

    public void resetRowHeight() {
        this.f_93387_ = this.originalItemHeight;
    }

    public void setRowHeight(int height) {
        this.f_93387_ = height;
    }

    public void setAsSemiTransparent() {
        this.isTransparentList = false;
    }

    public void setScrollOn(R entry) {
        this.centerScrollOn(entry);
    }

    public void resetScrollbar() {
        this.m_93410_(0.0);
    }

    public AbstractWidget getLastSelection() {
        return this.tabLastSelectedWidget;
    }

    public void setLastSelection(AbstractWidget widget) {
        this.tabLastSelectedWidget = widget;
    }

    public void resetLastSelection() {
        this.tabLastSelectedWidget = null;
    }

    public boolean unsetFocus() {
        if (this.tabLastSelectedWidget != null) {
            ((AbstractWidgetAccessor)this.tabLastSelectedWidget).NT$setFocus(false);
            this.tabLastSelectedWidget = null;
            return true;
        }
        return false;
    }

    public boolean getFocusKeyPress(int keyCode, int scanCode, int modifiers) {
        Supplier<Boolean> press = null;
        for (ContainerObjectSelectionList.Entry row : this.m_6702_()) {
            for (GuiEventListener listener : row.m_6702_()) {
                AbstractWidget widget;
                if (!(listener instanceof AbstractWidget) || !(widget = (AbstractWidget)listener).m_93696_()) continue;
                press = () -> widget.m_7933_(keyCode, scanCode, modifiers);
                break;
            }
            if (press == null) continue;
            break;
        }
        AtomicBoolean isPressed = new AtomicBoolean(false);
        if (press != null) {
            isPressed.set((Boolean)press.get());
        }
        return isPressed.get();
    }

    public boolean setFocus(@Nullable BiFunction<R, AbstractWidget, Boolean> filterWidget) {
        AbstractWidget widget;
        ContainerObjectSelectionList.Entry scrollSelection = null;
        ContainerObjectSelectionList.Entry tabFirstRow = null;
        ContainerObjectSelectionList.Entry tabLastRow = null;
        ContainerObjectSelectionList.Entry tabPreviousRow = null;
        ContainerObjectSelectionList.Entry tabNextRow = null;
        AbstractWidget tabFirstWidget = null;
        AbstractWidget tabLastWidget = null;
        AbstractWidget tabPreviousWidget = null;
        AbstractWidget tabNextWidget = null;
        for (ContainerObjectSelectionList.Entry row : this.m_6702_()) {
            for (GuiEventListener listener : row.m_6702_()) {
                if (!(listener instanceof AbstractWidget)) continue;
                widget = (AbstractWidget)listener;
                if (filterWidget != null && filterWidget.apply(row, widget).booleanValue()) continue;
                tabFirstRow = row;
                tabFirstWidget = widget;
                break;
            }
            if (tabFirstWidget == null) continue;
            break;
        }
        for (int i = this.m_6702_().size() - 1; i >= 0; --i) {
            ContainerObjectSelectionList.Entry row;
            row = (ContainerObjectSelectionList.Entry)this.m_6702_().get(i);
            for (int j = row.m_6702_().size() - 1; j >= 0; --j) {
                GuiEventListener listener;
                listener = (GuiEventListener)row.m_6702_().get(j);
                if (!(listener instanceof AbstractWidget)) continue;
                widget = (AbstractWidget)listener;
                if (filterWidget != null && filterWidget.apply(row, widget).booleanValue()) continue;
                tabLastRow = row;
                tabLastWidget = widget;
                break;
            }
            if (tabLastWidget != null) break;
        }
        if (this.tabLastSelectedWidget != null) {
            boolean getNextWidget = false;
            for (ContainerObjectSelectionList.Entry row : this.m_6702_()) {
                for (GuiEventListener listener : row.m_6702_()) {
                    if (!(listener instanceof AbstractWidget)) continue;
                    AbstractWidget widget2 = (AbstractWidget)listener;
                    if (getNextWidget) {
                        if (filterWidget != null && filterWidget.apply(row, widget2).booleanValue()) continue;
                        tabNextRow = row;
                        tabNextWidget = widget2;
                        break;
                    }
                    if (!widget2.equals(this.tabLastSelectedWidget)) {
                        boolean isFiltered;
                        boolean bl = isFiltered = filterWidget != null && filterWidget.apply(row, widget2) != false;
                        if (!isFiltered) {
                            tabPreviousRow = row;
                            tabPreviousWidget = widget2;
                        }
                    }
                    if (!widget2.equals(this.tabLastSelectedWidget)) continue;
                    getNextWidget = true;
                }
                if (tabNextWidget == null) continue;
                break;
            }
        }
        if (this.tabLastSelectedWidget == null) {
            if (Screen.m_96638_() && tabLastWidget != null) {
                scrollSelection = tabLastRow;
                ((AbstractWidgetAccessor)tabLastWidget).NT$setFocus(true);
                this.tabLastSelectedWidget = tabLastWidget;
            } else if (tabFirstWidget != null) {
                scrollSelection = tabFirstRow;
                ((AbstractWidgetAccessor)tabFirstWidget).NT$setFocus(true);
                this.tabLastSelectedWidget = tabFirstWidget;
            }
        } else {
            ((AbstractWidgetAccessor)this.tabLastSelectedWidget).NT$setFocus(false);
            if (Screen.m_96638_() && tabPreviousWidget != null) {
                scrollSelection = tabPreviousRow;
                ((AbstractWidgetAccessor)tabPreviousWidget).NT$setFocus(true);
                this.tabLastSelectedWidget = tabPreviousWidget;
            } else if (Screen.m_96638_() && tabLastWidget != null) {
                scrollSelection = tabLastRow;
                ((AbstractWidgetAccessor)tabLastWidget).NT$setFocus(true);
                this.tabLastSelectedWidget = tabLastWidget;
            } else if (tabNextWidget != null) {
                scrollSelection = tabNextRow;
                ((AbstractWidgetAccessor)tabNextWidget).NT$setFocus(true);
                this.tabLastSelectedWidget = tabNextWidget;
            } else if (tabFirstWidget != null) {
                scrollSelection = tabFirstRow;
                ((AbstractWidgetAccessor)tabFirstWidget).NT$setFocus(true);
                this.tabLastSelectedWidget = tabFirstWidget;
            }
        }
        if (scrollSelection != null) {
            this.setScrollOn(scrollSelection);
        }
        return true;
    }

    protected void centerScrollOn(R entry) {
        super.m_93494_(entry);
    }

    public int m_5759_() {
        return this.f_93388_;
    }

    public int getWidthMinusScrollbar() {
        return this.m_5756_();
    }

    public boolean isTooLong(int endX) {
        return endX >= this.m_5756_();
    }

    protected int m_5756_() {
        return this.f_93388_ - 4;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (ContainerObjectSelectionList.Entry row : this.m_6702_()) {
            for (GuiEventListener listener : row.m_6702_()) {
                EditBox box;
                if (!(listener instanceof EditBox) || (box = (EditBox)listener).m_6375_(mouseX, mouseY, button)) continue;
                box.m_94178_(false);
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private int getRowBottom(int index) {
        return this.m_7610_(index) + this.f_93387_;
    }

    private void renderList(PoseStack poseStack, int topY, int mouseX, int mouseY, float partialTick) {
        int itemCount = this.m_5773_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        for (int i = 0; i < itemCount; ++i) {
            int left;
            AbstractSelectionList.Entry entry = this.m_93500_(i);
            int top = this.m_7610_(i);
            int bottom = this.getRowBottom(i);
            if (bottom < this.f_93390_ || top > this.f_93391_) {
                boolean isTextWidget = false;
                if (entry instanceof ConfigRowList.Row) {
                    for (AbstractWidget widget : ((ConfigRowList.Row)entry).children) {
                        if (!(widget instanceof TextGroup.TextRow) || !((TextGroup.TextRow)widget).isFirst()) continue;
                        isTextWidget = true;
                    }
                }
                if (!isTextWidget) continue;
            }
            int startY = topY + i * this.f_93387_ + this.f_93395_;
            int height = this.f_93387_ - 4;
            int width = this.m_5759_();
            if (((AbstractSelectionListAccessor)((Object)this)).NT$getRenderSelection() && this.m_7987_(i)) {
                left = this.f_93393_ + this.f_93388_ / 2 - width / 2;
                int startX = this.f_93393_ + this.f_93388_ / 2 + width / 2;
                float brightness = this.m_5694_() ? 1.0f : 0.5f;
                RenderSystem.m_69472_();
                RenderSystem.m_157427_(GameRenderer::m_172808_);
                RenderSystem.m_157429_((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
                builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
                builder.m_5483_((double)left, (double)(startY + height + 2), 0.0).m_5752_();
                builder.m_5483_((double)startX, (double)(startY + height + 2), 0.0).m_5752_();
                builder.m_5483_((double)startX, (double)(startY - 2), 0.0).m_5752_();
                builder.m_5483_((double)left, (double)(startY - 2), 0.0).m_5752_();
                tesselator.m_85914_();
                RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
                builder.m_5483_((double)(left + 1), (double)(startY + height + 1), 0.0).m_5752_();
                builder.m_5483_((double)(startX - 1), (double)(startY + height + 1), 0.0).m_5752_();
                builder.m_5483_((double)(startX - 1), (double)(startY - 1), 0.0).m_5752_();
                builder.m_5483_((double)(left + 1), (double)(startY - 1), 0.0).m_5752_();
                tesselator.m_85914_();
                RenderSystem.m_69493_();
            }
            left = this.m_5747_();
            entry.m_6311_(poseStack, i, top, left, width, height, mouseX, mouseY, Objects.equals(this.m_168795_(), entry), partialTick);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        int maxScroll;
        if (this.isTransparentList && this.f_93386_.f_91073_ == null && this.f_93386_.f_91080_ != null) {
            this.f_93386_.f_91080_.m_96626_(0);
        }
        for (ContainerObjectSelectionList.Entry row : this.m_6702_()) {
            for (GuiEventListener listener : row.m_6702_()) {
                if (!(listener instanceof ContainerButton)) continue;
                ContainerButton container = (ContainerButton)listener;
                container.init();
            }
        }
        int scrollbarPosition = this.m_5756_();
        int scrollbarPositionOffset = scrollbarPosition + 6;
        int startY = this.f_93390_ + 4 - (int)this.m_93517_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        if (this.isTransparentList && this.f_93386_.f_91073_ == null) {
            this.m_93179_(poseStack, this.f_93393_, this.f_93390_, this.f_93392_, this.f_93391_, 0x68000000, 0x68000000);
        }
        this.renderList(poseStack, startY, mouseX, mouseY, partialTick);
        if (this.isTransparentList) {
            RenderSystem.m_157427_(GameRenderer::m_172820_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)f_93096_);
            RenderSystem.m_69482_();
            RenderSystem.m_69456_((int)519);
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            builder.m_5483_((double)this.f_93393_, (double)this.f_93390_, -100.0).m_7421_(0.0f, (float)this.f_93390_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            builder.m_5483_((double)(this.f_93393_ + this.f_93388_), (double)this.f_93390_, -100.0).m_7421_((float)this.f_93388_ / 32.0f, (float)this.f_93390_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            builder.m_5483_((double)(this.f_93393_ + this.f_93388_), 0.0, -100.0).m_7421_((float)this.f_93388_ / 32.0f, 0.0f).m_6122_(64, 64, 64, 255).m_5752_();
            builder.m_5483_((double)this.f_93393_, 0.0, -100.0).m_7421_(0.0f, 0.0f).m_6122_(64, 64, 64, 255).m_5752_();
            builder.m_5483_((double)this.f_93393_, (double)this.f_93389_, -100.0).m_7421_(0.0f, (float)this.f_93389_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            builder.m_5483_((double)(this.f_93393_ + this.f_93388_), (double)this.f_93389_, -100.0).m_7421_((float)this.f_93388_ / 32.0f, (float)this.f_93389_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            builder.m_5483_((double)(this.f_93393_ + this.f_93388_), (double)this.f_93391_, -100.0).m_7421_((float)this.f_93388_ / 32.0f, (float)this.f_93391_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            builder.m_5483_((double)this.f_93393_, (double)this.f_93391_, -100.0).m_7421_(0.0f, (float)this.f_93391_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            tesselator.m_85914_();
            RenderSystem.m_69456_((int)515);
            RenderSystem.m_69465_();
            RenderSystem.m_69478_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.m_69472_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            builder.m_5483_((double)this.f_93393_, (double)(this.f_93390_ + 4), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
            builder.m_5483_((double)this.f_93392_, (double)(this.f_93390_ + 4), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
            builder.m_5483_((double)this.f_93392_, (double)this.f_93390_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            builder.m_5483_((double)this.f_93393_, (double)this.f_93390_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            builder.m_5483_((double)this.f_93393_, (double)this.f_93391_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            builder.m_5483_((double)this.f_93392_, (double)this.f_93391_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            builder.m_5483_((double)this.f_93392_, (double)(this.f_93391_ - 4), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
            builder.m_5483_((double)this.f_93393_, (double)(this.f_93391_ - 4), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
            tesselator.m_85914_();
        }
        if ((maxScroll = this.m_93518_()) > 0) {
            RenderSystem.m_69472_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            int heightOffset = (int)((float)((this.f_93391_ - this.f_93390_) * (this.f_93391_ - this.f_93390_)) / (float)this.m_5775_());
            heightOffset = Mth.m_14045_((int)heightOffset, (int)32, (int)(this.f_93391_ - this.f_93390_ - 8));
            int scrollOffset = (int)this.m_93517_() * (this.f_93391_ - this.f_93390_ - heightOffset) / maxScroll + this.f_93390_;
            if (scrollOffset < this.f_93390_) {
                scrollOffset = this.f_93390_;
            }
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            builder.m_5483_((double)scrollbarPosition, (double)this.f_93391_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            builder.m_5483_((double)scrollbarPositionOffset, (double)this.f_93391_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            builder.m_5483_((double)scrollbarPositionOffset, (double)this.f_93390_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            builder.m_5483_((double)scrollbarPosition, (double)this.f_93390_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            builder.m_5483_((double)scrollbarPosition, (double)(scrollOffset + heightOffset), 0.0).m_6122_(128, 128, 128, 255).m_5752_();
            builder.m_5483_((double)scrollbarPositionOffset, (double)(scrollOffset + heightOffset), 0.0).m_6122_(128, 128, 128, 255).m_5752_();
            builder.m_5483_((double)scrollbarPositionOffset, (double)scrollOffset, 0.0).m_6122_(128, 128, 128, 255).m_5752_();
            builder.m_5483_((double)scrollbarPosition, (double)scrollOffset, 0.0).m_6122_(128, 128, 128, 255).m_5752_();
            builder.m_5483_((double)scrollbarPosition, (double)(scrollOffset + heightOffset - 1), 0.0).m_6122_(192, 192, 192, 255).m_5752_();
            builder.m_5483_((double)(scrollbarPositionOffset - 1), (double)(scrollOffset + heightOffset - 1), 0.0).m_6122_(192, 192, 192, 255).m_5752_();
            builder.m_5483_((double)(scrollbarPositionOffset - 1), (double)scrollOffset, 0.0).m_6122_(192, 192, 192, 255).m_5752_();
            builder.m_5483_((double)scrollbarPosition, (double)scrollOffset, 0.0).m_6122_(192, 192, 192, 255).m_5752_();
            tesselator.m_85914_();
        }
        this.m_7415_(poseStack, mouseX, mouseY);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }
}

