/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.widget.list.row;

import java.util.ArrayList;
import java.util.Map;
import mod.adrenix.nostalgic.client.config.gui.screen.list.ListMapScreen;
import mod.adrenix.nostalgic.client.config.gui.widget.button.DeleteButton;
import mod.adrenix.nostalgic.client.config.gui.widget.button.ResetButton;
import mod.adrenix.nostalgic.client.config.gui.widget.list.ConfigRowList;
import mod.adrenix.nostalgic.client.config.gui.widget.slider.GenericSlider;
import mod.adrenix.nostalgic.client.config.gui.widget.text.TextTitle;
import mod.adrenix.nostalgic.common.config.list.ListMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;

public abstract class ConfigRowEntry {

    public static class IntegerEntryRow
    extends AbstractEntryRow<Integer> {
        public IntegerEntryRow(ListMap<Integer> listMap, Map.Entry<String, Integer> entry, int reset) {
            super(listMap, entry, reset);
        }

        @Override
        public ConfigRowList.Row generate() {
            GenericSlider slider = new GenericSlider(this.entry::setValue, this.entry::getValue, this.listMap.getTweak(), ConfigRowList.getInstance().m_5759_() - 206, 0, 120, 20);
            return this.create((AbstractWidget)slider);
        }
    }

    public static class InvalidEntryRow
    extends AbstractEntryRow<Object> {
        public InvalidEntryRow(ListMap<Object> listMap, Map.Entry<String, Object> entry, Object reset) {
            super(listMap, entry, reset);
        }

        @Override
        public ConfigRowList.Row generate() {
            return super.generate();
        }
    }

    private static abstract class AbstractEntryRow<V> {
        protected final ListMap<V> listMap;
        protected final ListMapScreen<V> screen;
        protected final Map.Entry<String, V> entry;
        protected final V reset;
        protected final V undo;

        protected AbstractEntryRow(ListMap<V> listMap, Map.Entry<String, V> entry, V reset) {
            this.listMap = listMap;
            this.entry = entry;
            this.reset = reset;
            this.screen = (ListMapScreen)Minecraft.m_91087_().f_91080_;
            if (this.screen == null) {
                throw new RuntimeException("Could not create an abstract entry row since 'screen' is 'null'");
            }
            this.undo = this.screen.getCachedValue(this.entry);
        }

        private void onReset(AbstractWidget controller) {
            this.entry.setValue(this.isChanged() ? this.undo : this.reset);
            if (controller instanceof GenericSlider) {
                GenericSlider slider = (GenericSlider)controller;
                slider.update();
            }
        }

        private boolean isChanged() {
            if (this.entry.getValue() instanceof Integer && this.undo instanceof Integer) {
                return ((Integer)this.entry.getValue()).compareTo((Integer)this.undo) != 0;
            }
            return !this.entry.equals(this.undo);
        }

        private boolean isDeleted() {
            return this.screen.isDeleted(this.entry);
        }

        private void onDelete() {
            this.screen.delete(this.entry);
        }

        private void onUndo() {
            this.screen.undo(this.entry);
        }

        protected ConfigRowList.Row create(AbstractWidget controller) {
            ArrayList<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
            ResetButton reset = new ResetButton(controller, this::isChanged, this::onReset);
            DeleteButton delete = new DeleteButton(reset, this::isDeleted, this::onDelete, this::onUndo);
            widgets.add(new TextTitle<V>(this.screen, this.entry, this.entry.getKey()));
            widgets.add(controller);
            widgets.add((AbstractWidget)reset);
            widgets.add((AbstractWidget)delete);
            ConfigRowList.Row row = new ConfigRowList.Row(widgets, controller, null);
            row.setHighlight(true);
            row.setResourceKey(this.entry.getKey());
            return row;
        }

        public ConfigRowList.Row generate() {
            return new ConfigRowList.Row(new ArrayList<AbstractWidget>(), null);
        }
    }
}

