/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.widget.list.row;

import java.util.ArrayList;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.client.config.annotation.container.TweakEmbed;
import mod.adrenix.nostalgic.client.config.gui.widget.button.ContainerButton;
import mod.adrenix.nostalgic.client.config.gui.widget.list.ConfigRowList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;

public abstract class ConfigRowGroup {

    public static class ContainerRow {
        private ArrayList<ConfigRowList.Row> cache;
        private ContainerButton controller;
        private final Enum<?> id;
        private final Component title;
        private final Supplier<ArrayList<ConfigRowList.Row>> childrenSupply;
        private final ContainerType containerType;
        private final ConfigRowList list;
        private boolean expanded = false;

        public ContainerRow(Component title, Supplier<ArrayList<ConfigRowList.Row>> childrenSupply, Enum<?> id, ContainerType containerType) {
            this.id = id;
            this.title = title;
            this.childrenSupply = childrenSupply;
            this.containerType = containerType;
            this.list = ConfigRowList.getInstance();
        }

        public ContainerRow(Component title, Supplier<ArrayList<ConfigRowList.Row>> childrenSupply, Enum<?> id) {
            this(title, childrenSupply, id, ContainerType.CATEGORY);
        }

        public static int getIndent(ContainerType containerType) {
            return switch (containerType) {
                default -> throw new IncompatibleClassChangeError();
                case ContainerType.CATEGORY -> 8;
                case ContainerType.SUBCATEGORY -> 28;
                case ContainerType.EMBEDDED -> 48;
            };
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        private void setGroupMetadata() {
            for (ConfigRowList.Row categories : this.list.m_6702_()) {
                for (AbstractWidget widget : categories.children) {
                    ContainerButton group;
                    if (!(widget instanceof ContainerButton) || !((Object)((Object)this.controller)).equals((Object)(group = (ContainerButton)widget))) continue;
                    ContainerButton subcategory = null;
                    boolean isSubOnly = true;
                    for (ConfigRowList.Row subcategories : this.cache) {
                        for (AbstractWidget subWidget : subcategories.children) {
                            if (subWidget instanceof ContainerButton) {
                                ContainerButton subGroup;
                                subcategory = subGroup = (ContainerButton)subWidget;
                                continue;
                            }
                            isSubOnly = false;
                            break;
                        }
                        if (isSubOnly) continue;
                        break;
                    }
                    if (isSubOnly && subcategory != null) {
                        subcategory.setLastSubcategory(true);
                    }
                    if ((!isSubOnly || group.isParentTreeNeeded()) && subcategory != null) {
                        subcategory.setParentTreeNeeded(true);
                    }
                    if (!(group.getId() instanceof TweakEmbed) || categories.getGroup() == null || categories.getGroup().isLastSubcategory()) continue;
                    group.setGrandparentTreeNeeded(true);
                }
            }
        }

        private int getHeaderIndex() {
            int header = -1;
            block0: for (int i = 0; i < this.list.m_6702_().size() && header == -1; ++i) {
                for (AbstractWidget widget : ((ConfigRowList.Row)((Object)this.list.m_6702_().get((int)i))).children) {
                    if (!(widget instanceof ContainerButton) || !widget.equals((Object)this.controller)) continue;
                    header = i;
                    continue block0;
                }
            }
            return header == -1 ? 0 : ++header;
        }

        public void expand() {
            int indent;
            ConfigRowList.currentIndent = indent = ContainerRow.getIndent(this.containerType) + 20;
            this.expanded = true;
            this.cache = this.childrenSupply.get();
            this.setGroupMetadata();
            int header = this.getHeaderIndex();
            for (ConfigRowList.Row row : this.cache) {
                this.list.m_6702_().add(header, row);
                row.setIndent(indent);
                row.setGroup(this.controller);
                ++header;
            }
            if (this.cache.size() > 0) {
                this.cache.get(0).setFirst(true);
                this.cache.get(this.cache.size() - 1).setLast(true);
            }
            ConfigRowList.currentIndent = 8;
        }

        public void collapse() {
            if (this.cache == null) {
                return;
            }
            this.expanded = false;
            block0: for (ConfigRowList.Row cache : this.cache) {
                for (ConfigRowList.Row child : this.list.m_6702_()) {
                    if (!((Object)((Object)child)).equals((Object)cache)) continue;
                    for (AbstractWidget widget : child.children) {
                        if (!(widget instanceof ContainerButton)) continue;
                        ContainerButton group = (ContainerButton)widget;
                        group.collapse();
                    }
                    this.list.removeRow(child);
                    continue block0;
                }
            }
            if (this.list.m_93517_() > 0.0) {
                this.list.m_93410_(this.list.m_93517_());
            }
        }

        public ConfigRowList.Row generate() {
            ArrayList<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
            this.controller = new ContainerButton(this, this.id, this.title, this.containerType);
            widgets.add((AbstractWidget)this.controller);
            return new ConfigRowList.Row(widgets, (AbstractWidget)this.controller, null);
        }
    }

    public static enum ContainerType {
        CATEGORY,
        SUBCATEGORY,
        EMBEDDED;

    }
}

