/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.widget.list.row;

import java.util.ArrayList;
import mod.adrenix.nostalgic.client.config.gui.screen.list.ListScreen;
import mod.adrenix.nostalgic.client.config.gui.screen.list.ListSetScreen;
import mod.adrenix.nostalgic.client.config.gui.widget.button.RemoveButton;
import mod.adrenix.nostalgic.client.config.gui.widget.button.RemoveType;
import mod.adrenix.nostalgic.client.config.gui.widget.list.ConfigRowList;
import mod.adrenix.nostalgic.client.config.gui.widget.text.TextTitle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;

public abstract class ConfigRowKey {

    public static class DefaultRow {
        private final String resourceKey;
        private final ListScreen screen;

        public DefaultRow(String resourceKey) {
            this.resourceKey = resourceKey;
            this.screen = (ListScreen)Minecraft.m_91087_().f_91080_;
        }

        private boolean isRemoved() {
            return this.screen.isDefaultItemDisabled(this.resourceKey);
        }

        private void onEnable() {
            this.screen.enableDefaultItem(this.resourceKey);
        }

        private void onDisable() {
            this.screen.disableDefaultItem(this.resourceKey);
        }

        public ConfigRowList.Row generate() {
            ArrayList<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
            RemoveButton remove = new RemoveButton(RemoveType.DEFAULT, this.resourceKey, this::isRemoved, this::onDisable, this::onEnable);
            TextTitle title = new TextTitle(RemoveType.DEFAULT, this.resourceKey, this::isRemoved);
            widgets.add(title);
            widgets.add((AbstractWidget)remove);
            ConfigRowList.Row row = new ConfigRowList.Row(widgets, null, null);
            row.setHighlight(true);
            row.setResourceKey(this.resourceKey);
            return row;
        }
    }

    public static class SavedRow {
        private final String resourceKey;
        private final ListSetScreen screen;

        public SavedRow(String resourceKey) {
            this.resourceKey = resourceKey;
            this.screen = (ListSetScreen)Minecraft.m_91087_().f_91080_;
        }

        private boolean isRemoved() {
            return this.screen.isKeyDeleted(this.resourceKey);
        }

        private void onRemove() {
            this.screen.delete(this.resourceKey);
        }

        private void onUndo() {
            this.screen.undo(this.resourceKey);
        }

        public ConfigRowList.Row generate() {
            ArrayList<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
            RemoveButton remove = new RemoveButton(RemoveType.SAVED, this.resourceKey, this::isRemoved, this::onRemove, this::onUndo);
            TextTitle title = new TextTitle(RemoveType.SAVED, this.resourceKey, this::isRemoved);
            widgets.add(title);
            widgets.add((AbstractWidget)remove);
            ConfigRowList.Row row = new ConfigRowList.Row(widgets, null, null);
            row.setHighlight(true);
            row.setResourceKey(this.resourceKey);
            return row;
        }
    }
}

