/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.widget.list.row;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import mod.adrenix.nostalgic.client.config.annotation.TweakGui;
import mod.adrenix.nostalgic.client.config.gui.widget.TweakTag;
import mod.adrenix.nostalgic.client.config.gui.widget.button.BooleanButton;
import mod.adrenix.nostalgic.client.config.gui.widget.button.CycleButton;
import mod.adrenix.nostalgic.client.config.gui.widget.button.ListMapButton;
import mod.adrenix.nostalgic.client.config.gui.widget.button.ListSetButton;
import mod.adrenix.nostalgic.client.config.gui.widget.button.ResetButton;
import mod.adrenix.nostalgic.client.config.gui.widget.button.StatusButton;
import mod.adrenix.nostalgic.client.config.gui.widget.button.TooltipButton;
import mod.adrenix.nostalgic.client.config.gui.widget.input.ColorInput;
import mod.adrenix.nostalgic.client.config.gui.widget.input.StringInput;
import mod.adrenix.nostalgic.client.config.gui.widget.list.ConfigRowList;
import mod.adrenix.nostalgic.client.config.gui.widget.slider.ConfigSlider;
import mod.adrenix.nostalgic.client.config.reflect.TweakClientCache;
import mod.adrenix.nostalgic.common.config.reflect.TweakGroup;
import net.minecraft.client.gui.components.AbstractWidget;

public abstract class ConfigRowTweak {

    public static class EnumRow<E extends Enum<E>>
    extends AbstractRow<E> {
        public EnumRow(TweakGroup group, String key, Object value) {
            super(group, key, (Enum)value);
        }

        @Override
        public ConfigRowList.Row generate() {
            return this.create((AbstractWidget)new CycleButton(this.tweak, ((Enum)this.tweak.getValue()).getDeclaringClass(), button -> ((CycleButton)button).toggle()));
        }
    }

    public static class ColorRow
    extends AbstractRow<String> {
        public ColorRow(TweakGroup group, String key, String value) {
            super(group, key, value);
        }

        @Override
        public ConfigRowList.Row generate() {
            return this.create(new ColorInput(this.tweak));
        }
    }

    public static class StringRow
    extends AbstractRow<String> {
        public StringRow(TweakGroup group, String key, String value) {
            super(group, key, value);
        }

        @Override
        public ConfigRowList.Row generate() {
            return this.create(new StringInput(this.tweak).getWidget());
        }
    }

    public static class IntSliderRow
    extends AbstractRow<Integer> {
        public IntSliderRow(TweakGroup group, String key, int value) {
            super(group, key, value);
        }

        @Override
        public ConfigRowList.Row generate() {
            return this.create((AbstractWidget)new ConfigSlider(this.tweak));
        }
    }

    public static class BooleanRow
    extends AbstractRow<Boolean> {
        public BooleanRow(TweakGroup group, String key, boolean value) {
            super(group, key, value);
        }

        @Override
        public ConfigRowList.Row generate() {
            return this.create((AbstractWidget)new BooleanButton(this.tweak, button -> this.tweak.setValue((Boolean)this.tweak.getValue() == false)));
        }
    }

    public static class ListSetRow
    extends AbstractRow<Set<String>> {
        public ListSetRow(TweakGroup group, String key, Set<String> set) {
            super(group, key, set);
        }

        @Override
        public ConfigRowList.Row generate() {
            return this.create((AbstractWidget)new ListSetButton(this.tweak));
        }
    }

    public static class ListMapRow<V>
    extends AbstractRow<Map<String, V>> {
        public ListMapRow(TweakGroup group, String key, Map<String, V> map) {
            super(group, key, map);
        }

        @Override
        public ConfigRowList.Row generate() {
            return this.create((AbstractWidget)new ListMapButton(this.tweak));
        }
    }

    public static class InvalidRow
    extends AbstractRow<Object> {
        public InvalidRow(TweakGroup group, String key, Object value) {
            super(group, key, value);
        }

        @Override
        public ConfigRowList.Row generate() {
            return new ConfigRowList.Row(new ArrayList<AbstractWidget>(), this.tweak);
        }
    }

    private static abstract class AbstractRow<T> {
        protected final TweakClientCache<T> tweak;
        protected final TweakGroup group;
        protected final String key;
        protected final T value;

        protected AbstractRow(TweakGroup group, String key, T value) {
            this.tweak = TweakClientCache.get(group, key);
            this.group = group;
            this.key = key;
            this.value = value;
        }

        protected ConfigRowList.Row create(AbstractWidget controller) {
            ArrayList<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
            TweakGui.NoTooltip noTooltip = this.tweak.getMetadata(TweakGui.NoTooltip.class);
            widgets.add(controller);
            widgets.add((AbstractWidget)new ResetButton(this.tweak, controller));
            widgets.add((AbstractWidget)new StatusButton(this.tweak, controller));
            widgets.add(new TweakTag(this.tweak, controller, noTooltip == null));
            if (noTooltip == null) {
                widgets.add((AbstractWidget)new TooltipButton(this.tweak, controller));
            }
            if (controller instanceof ColorInput) {
                ColorInput color = (ColorInput)controller;
                widgets.add(color.getWidget());
            }
            return new ConfigRowList.Row(widgets, controller, this.tweak);
        }

        public ConfigRowList.Row generate() {
            return new ConfigRowList.Row(new ArrayList<AbstractWidget>(), this.tweak);
        }
    }
}

