/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.widget.slider;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import mod.adrenix.nostalgic.client.config.annotation.TweakGui;
import mod.adrenix.nostalgic.client.config.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.config.reflect.TweakClientCache;
import mod.adrenix.nostalgic.common.config.annotation.TweakData;
import mod.adrenix.nostalgic.common.config.tweak.Tweak;
import mod.adrenix.nostalgic.util.common.MathUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class GenericSlider
extends AbstractSliderButton {
    private TweakGui.SliderType sliderType = TweakGui.SliderType.SWING;
    private int min = 0;
    private int max = 16;
    private final Consumer<Integer> setCurrent;
    private final Supplier<Integer> current;
    @CheckForNull
    private final TweakGui.Slider sliderData;

    public GenericSlider(TweakClientCache<Integer> tweak, int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.m_237119_(), (double)tweak.getValue().intValue());
        this.sliderData = tweak.getMetadata(TweakGui.Slider.class);
        this.setCurrent = tweak::setValue;
        this.current = tweak::getValue;
        this.m_5695_();
        this.setValue(this.current.get());
    }

    public GenericSlider(Consumer<Integer> setCurrent, Supplier<Integer> current, Tweak tweak, int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.m_237119_(), (double)current.get().intValue());
        TweakData.BoundedSlider bounds;
        this.setCurrent = setCurrent;
        this.current = current;
        this.sliderData = TweakClientCache.get(tweak).getMetadata(TweakGui.Slider.class);
        if (this.sliderData != null) {
            this.sliderType = this.sliderData.type();
        }
        if ((bounds = TweakClientCache.get(tweak).getMetadata(TweakData.BoundedSlider.class)) != null) {
            this.setMinimum((int)bounds.min());
            this.setMaximum((int)bounds.max());
        }
        this.m_5695_();
        this.setValue(current.get());
    }

    protected void setMinimum(int min) {
        this.min = min;
        this.setValue(this.current.get());
    }

    protected void setMaximum(int max) {
        this.max = max;
        this.setValue(this.current.get());
    }

    public void setValue(int value) {
        this.f_93577_ = (double)(Mth.m_14045_((int)value, (int)this.min, (int)this.max) - this.min) / (double)Math.abs(this.max - this.min);
    }

    public void update() {
        this.setValue(this.current.get());
        this.m_5695_();
    }

    protected void m_5697_() {
        this.setCurrent.accept((int)((double)this.min + (double)Math.abs(this.max - this.min) * this.f_93577_));
    }

    public void setType(TweakGui.SliderType sliderType) {
        this.sliderType = sliderType;
    }

    private ChatFormatting getColorFromInt() {
        ChatFormatting color = ChatFormatting.GREEN;
        int integer = this.current.get();
        if (this.sliderType == TweakGui.SliderType.SWING) {
            if (integer == -1) {
                color = ChatFormatting.RED;
            } else if (integer == 0) {
                color = ChatFormatting.YELLOW;
            } else if (integer <= 6) {
                color = ChatFormatting.GOLD;
            }
        } else if (this.sliderType == TweakGui.SliderType.INTENSITY) {
            if (integer == 0) {
                color = ChatFormatting.RED;
            } else if (integer <= 50) {
                color = ChatFormatting.GOLD;
            } else if (integer > 100) {
                color = ChatFormatting.AQUA;
            }
        } else if (this.sliderType == TweakGui.SliderType.CLOUD) {
            color = integer == 128 ? ChatFormatting.YELLOW : (integer == 192 ? ChatFormatting.GOLD : ChatFormatting.LIGHT_PURPLE);
        } else if (this.sliderType == TweakGui.SliderType.GENERIC) {
            color = ChatFormatting.RESET;
        }
        return color;
    }

    public void m_5695_() {
        if (this.sliderType == TweakGui.SliderType.HEARTS) {
            this.m_93666_((Component)Component.m_237119_());
            return;
        }
        ChatFormatting color = this.getColorFromInt();
        String title = "";
        String suffix = "";
        if (this.sliderType == TweakGui.SliderType.SWING) {
            title = Component.m_237115_((String)"gui.nostalgic_tweaks.config.speed").getString();
        } else if (this.sliderType == TweakGui.SliderType.INTENSITY) {
            suffix = "%";
            title = Component.m_237115_((String)"gui.nostalgic_tweaks.config.intensity").getString();
        } else if (this.sliderType == TweakGui.SliderType.CLOUD) {
            switch (this.current.get()) {
                case 108: {
                    String string = Component.m_237115_((String)"gui.nostalgic_tweaks.config.alpha").getString();
                    break;
                }
                case 128: {
                    String string = Component.m_237115_((String)"gui.nostalgic_tweaks.config.beta").getString();
                    break;
                }
                case 192: {
                    String string = Component.m_237115_((String)"gui.nostalgic_tweaks.config.modern").getString();
                    break;
                }
                default: {
                    String string = title = Component.m_237115_((String)"gui.nostalgic_tweaks.config.custom").getString();
                }
            }
        }
        if (this.sliderData != null && !this.sliderData.langKey().isEmpty()) {
            title = Component.m_237115_((String)this.sliderData.langKey()).getString();
        }
        if (this.sliderData != null && !this.sliderData.suffix().isEmpty()) {
            suffix = this.sliderData.suffix();
        }
        Object text = title + ": " + color + this.current.get().toString() + suffix;
        if (!this.f_93623_) {
            text = ChatFormatting.m_126649_((String)text);
            text = ChatFormatting.GRAY + ChatFormatting.STRIKETHROUGH.toString() + (String)text;
        }
        if (Overlay.isOpened()) {
            text = ChatFormatting.m_126649_((String)text);
            text = ChatFormatting.GRAY + (String)text;
        }
        this.m_93666_((Component)Component.m_237113_((String)text));
    }

    protected void m_7906_(PoseStack poseStack, Minecraft minecraft, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93617_);
        int dy = !this.f_93623_ ? 0 : (this.m_198029_() ? 2 : 1) * 20;
        this.m_93228_(poseStack, this.f_93620_ + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)), this.f_93621_, 0, 46 + dy, 4, 20);
        this.m_93228_(poseStack, this.f_93620_ + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)) + 4, this.f_93621_, 196, 46 + dy, 4, 20);
        if (this.sliderType == TweakGui.SliderType.HEARTS) {
            int i;
            if (!this.f_93623_) {
                RenderSystem.m_157429_((float)0.3f, (float)0.3f, (float)0.3f, (float)1.0f);
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)f_93098_);
            int x = this.f_93620_ + this.f_93618_ / 2 - 45;
            int y = this.f_93621_ + 6;
            int dx = x;
            for (i = 0; i < 10; ++i) {
                this.m_93228_(poseStack, dx, y, 16, 0, 9, 9);
                dx += 9;
            }
            dx = x;
            for (i = 0; i < this.current.get(); ++i) {
                if (MathUtil.isOdd(i)) {
                    this.m_93228_(poseStack, dx, y, 52, 0, 9, 9);
                    dx += 9;
                    continue;
                }
                this.m_93228_(poseStack, dx, y, 61, 0, 9, 9);
            }
        }
    }
}

