/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.widget.text;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import mod.adrenix.nostalgic.client.config.gui.screen.config.ConfigWidgets;
import mod.adrenix.nostalgic.client.config.gui.screen.list.ListMapScreen;
import mod.adrenix.nostalgic.client.config.gui.screen.list.ListScreen;
import mod.adrenix.nostalgic.client.config.gui.screen.list.ListSetScreen;
import mod.adrenix.nostalgic.client.config.gui.widget.button.RemoveType;
import mod.adrenix.nostalgic.client.config.gui.widget.list.ConfigRowList;
import mod.adrenix.nostalgic.common.config.list.ListId;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import mod.adrenix.nostalgic.util.common.ItemCommonUtil;
import mod.adrenix.nostalgic.util.common.MathUtil;
import mod.adrenix.nostalgic.util.common.TextUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class TextTitle<V>
extends AbstractWidget {
    private static final int START_X = 0;
    private static final int START_Y = 0;
    private static final int HEIGHT = 12;
    private static final int WIDTH = ConfigRowList.getInstance().m_5759_();
    private final String resourceKey;
    @CheckForNull
    private final RemoveType removeType;
    @CheckForNull
    private final Map.Entry<String, V> entry;
    @CheckForNull
    private final Supplier<Boolean> isRemoved;
    @CheckForNull
    private final V currentValue;

    public TextTitle(ListMapScreen<V> listMapScreen, Map.Entry<String, V> entry, String resourceKey) {
        super(0, 0, WIDTH, 12, (Component)Component.m_237119_());
        this.entry = entry;
        this.resourceKey = resourceKey;
        this.currentValue = listMapScreen.getCachedValue(entry);
        this.removeType = RemoveType.SAVED;
        this.isRemoved = null;
    }

    public TextTitle(RemoveType removeType, String resourceKey, Supplier<Boolean> isRemoved) {
        super(0, 0, WIDTH, 12, (Component)Component.m_237119_());
        this.entry = null;
        this.currentValue = null;
        this.resourceKey = resourceKey;
        this.removeType = removeType;
        this.isRemoved = isRemoved;
    }

    private String getDefaultTitle(ListMapScreen<?> mapScreen) {
        ListId listId = mapScreen.getListId();
        Object value = mapScreen.getListMap().getDefaultMap().get(this.resourceKey);
        String prefix = Component.m_237115_((String)"gui.nostalgic_tweaks.config.slider.value").getString();
        String color = ChatFormatting.YELLOW.toString();
        String gray = ChatFormatting.GRAY.toString();
        if (listId == ListId.CUSTOM_FOOD_STACKING) {
            prefix = Component.m_237115_((String)"gui.nostalgic_tweaks.config.slider.stack").getString();
        }
        if (listId == ListId.CUSTOM_FOOD_HEALTH) {
            prefix = Component.m_237115_((String)"gui.nostalgic_tweaks.config.slider.hearts").getString();
            color = ChatFormatting.GREEN.toString();
            value = Float.valueOf((float)((Integer)value).intValue() / 2.0f);
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            color = bool != false ? ChatFormatting.GREEN.toString() : ChatFormatting.RED.toString();
        }
        return String.format(" %s(%s: %s%s%s)", gray, prefix, color, TextUtil.toTitleCase(value.toString()), gray);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return false;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        boolean isNotDefault;
        boolean isOverridden;
        ListSetScreen setScreen;
        ListMapScreen mapScreen;
        boolean isItalics;
        boolean isInvalid = !ItemCommonUtil.isValidKey(this.resourceKey);
        int startX = ConfigRowList.getStartX() - 1;
        Font font = Minecraft.m_91087_().f_91062_;
        ListScreen listScreen = (ListScreen)Minecraft.m_91087_().f_91080_;
        if (ClassUtil.isNotInstanceOf((Object)listScreen, ListScreen.class)) {
            return;
        }
        ItemStack itemStack = isInvalid ? new ItemStack((ItemLike)Items.f_42127_) : ItemCommonUtil.getItemStack(this.resourceKey);
        String itemName = ItemCommonUtil.getLocalizedItem(this.resourceKey);
        MutableComponent entryTitle = Component.m_237113_((String)itemName);
        MutableComponent literalKey = Component.m_237110_((String)"gui.nostalgic_tweaks.list.item_key", (Object[])new Object[]{this.resourceKey});
        List<Component> tooltip = TextUtil.Wrap.tooltip((Component)literalKey, 50);
        if (this.removeType == RemoveType.DEFAULT && listScreen instanceof ListMapScreen) {
            ListMapScreen mapScreen2 = (ListMapScreen)listScreen;
            entryTitle = Component.m_237113_((String)(entryTitle.getString() + this.getDefaultTitle(mapScreen2)));
        }
        boolean isEntryChanged = this.entry != null && !this.entry.getValue().equals(this.currentValue);
        boolean isKeyChanged = this.isRemoved != null && this.isRemoved.get() != false;
        boolean bl = isItalics = this.removeType == RemoveType.SAVED && (isEntryChanged || isKeyChanged);
        if (isItalics) {
            entryTitle = Component.m_237113_((String)(ChatFormatting.ITALIC + entryTitle.m_6881_().getString()));
        }
        boolean isEntryDeleted = listScreen instanceof ListMapScreen && (mapScreen = (ListMapScreen)listScreen).getDeletedEntries().contains(this.entry);
        boolean isKeyDeleted = listScreen instanceof ListSetScreen && (setScreen = (ListSetScreen)listScreen).getDeletedKeys().contains(this.resourceKey);
        boolean isDefaultDisabled = listScreen.isDefaultItemDisabled(this.resourceKey);
        boolean isTitleRed = this.removeType == RemoveType.SAVED ? isEntryDeleted || isKeyDeleted : isDefaultDisabled;
        boolean bl2 = isOverridden = this.removeType == RemoveType.DEFAULT && listScreen.isItemSaved(itemStack);
        if (isTitleRed || isOverridden) {
            entryTitle = Component.m_237113_((String)(ChatFormatting.RED + entryTitle.m_6881_().getString()));
        }
        if (isInvalid) {
            entryTitle = Component.m_237113_((String)(ChatFormatting.GOLD + entryTitle.m_6881_().getString()));
        } else if (listScreen.isItemAdded(itemStack) && this.removeType != RemoveType.DEFAULT) {
            entryTitle = Component.m_237113_((String)(ChatFormatting.GREEN + entryTitle.m_6881_().getString()));
        }
        int startY = this.f_93621_ + 1;
        if (itemStack.m_41720_() instanceof BlockItem) {
            ++startY;
        }
        if (this.removeType == RemoveType.DEFAULT && listScreen.isItemSaved(itemStack)) {
            String saved = Component.m_237115_((String)"gui.nostalgic_tweaks.list.saved_items").getString();
            entryTitle = Component.m_237113_((String)(entryTitle.getString() + ChatFormatting.RED + " (" + saved + ")"));
        }
        listScreen.getItemRenderer().m_115123_(itemStack, startX, startY);
        Screen.m_93243_((PoseStack)poseStack, (Font)font, (Component)entryTitle, (int)(startX + 21), (int)(this.f_93621_ + 6), (int)0xFFFFFF);
        boolean isHovering = MathUtil.isWithinBox(mouseX, mouseY, startX, this.f_93621_ + 4, font.m_92852_((FormattedText)entryTitle) + 21, 14.0);
        boolean isInBounds = ConfigWidgets.isInsideRowList(mouseY);
        boolean bl3 = isNotDefault = this.removeType != RemoveType.DEFAULT;
        if (isHovering && isInBounds && isNotDefault) {
            listScreen.renderLast.add(() -> listScreen.m_96597_(poseStack, tooltip, mouseX, mouseY));
        }
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }
}

