/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.reflect;

import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckForNull;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.config.annotation.TweakGui;
import mod.adrenix.nostalgic.client.config.annotation.TweakReload;
import mod.adrenix.nostalgic.client.config.gui.toast.ToastNotification;
import mod.adrenix.nostalgic.client.config.reflect.ClientReflect;
import mod.adrenix.nostalgic.common.config.annotation.TweakData;
import mod.adrenix.nostalgic.common.config.reflect.TweakCommonCache;
import mod.adrenix.nostalgic.common.config.reflect.TweakGroup;
import mod.adrenix.nostalgic.common.config.reflect.TweakStatus;
import mod.adrenix.nostalgic.common.config.tweak.Tweak;
import mod.adrenix.nostalgic.network.packet.PacketC2SChangeTweak;
import mod.adrenix.nostalgic.server.config.reflect.TweakServerCache;
import mod.adrenix.nostalgic.util.client.NetUtil;
import mod.adrenix.nostalgic.util.client.RunUtil;
import mod.adrenix.nostalgic.util.common.PacketUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;

public class TweakClientCache<T>
extends TweakCommonCache {
    private static final HashMap<String, TweakClientCache<?>> CACHE = new HashMap();
    private int weight = 0;
    private final boolean isAnnotatedNew;
    private final boolean isAnnotatedClient;
    private final boolean isAnnotatedServer;
    private final boolean isAnnotatedDynamic;
    private final boolean isAnnotatedNotAutomated;
    private final boolean isAnnotatedReloadChunks;
    private final boolean isAnnotatedReloadResources;
    @CheckForNull
    private final TweakGui.Placement placement;
    @CheckForNull
    private final TweakGui.Category category;
    @CheckForNull
    private final TweakGui.Subcategory subcategory;
    @CheckForNull
    private final TweakGui.Embed embed;
    private Tweak tweak = null;
    private T value;
    private int order;
    private TweakGui.Position position;

    public static HashMap<String, TweakClientCache<?>> all() {
        return CACHE;
    }

    public static <T> TweakClientCache<T> get(TweakGroup group, String key) throws AssertionError {
        TweakClientCache<?> instance = CACHE.get(TweakClientCache.generateKey(group, key));
        if (instance == null) {
            throw new AssertionError((Object)String.format("Tweak [group=%s, key=%s] was not found in client-cache", new Object[]{group, key}));
        }
        return instance;
    }

    public static <T> TweakClientCache<T> get(Tweak tweak) {
        if (tweak.getClientCache() == null) {
            tweak.setClientCache(TweakClientCache.get(tweak.getGroup(), tweak.getKey()));
        }
        return tweak.getClientCache();
    }

    public TweakServerCache<T> getServerTweak() {
        if (this.tweak != null) {
            return TweakServerCache.get(this.tweak);
        }
        return TweakServerCache.get(this.group, this.key);
    }

    public T getServerCache() {
        return this.getServerTweak().getServerCache();
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public int getWeight() {
        return this.weight;
    }

    public static int compareWeights(int firstWeight, int secondWeight) {
        int compare = Integer.compare(firstWeight, secondWeight);
        return compare != 0 ? compare : compare + 1;
    }

    public static int getConflicts() {
        AtomicInteger found = new AtomicInteger();
        TweakClientCache.all().forEach((key, tweak) -> {
            if (tweak.getStatus() == TweakStatus.FAIL) {
                found.getAndIncrement();
            }
        });
        return found.get();
    }

    private TweakClientCache(TweakGroup group, String key, T value) {
        super(group, key);
        this.value = value;
        this.isAnnotatedNew = this.isMetadataPresent(TweakGui.New.class);
        this.isAnnotatedClient = this.isMetadataMissing(TweakData.Server.class);
        this.isAnnotatedServer = this.isMetadataPresent(TweakData.Server.class);
        this.isAnnotatedDynamic = this.isMetadataPresent(TweakData.Dynamic.class);
        this.isAnnotatedNotAutomated = this.isMetadataPresent(TweakGui.NotAutomated.class);
        this.isAnnotatedReloadChunks = this.isMetadataPresent(TweakReload.Chunks.class);
        this.isAnnotatedReloadResources = this.isMetadataPresent(TweakReload.Resources.class);
        this.placement = this.getMetadata(TweakGui.Placement.class);
        this.category = this.getMetadata(TweakGui.Category.class);
        this.subcategory = this.getMetadata(TweakGui.Subcategory.class);
        this.embed = this.getMetadata(TweakGui.Embed.class);
        if (this.placement != null) {
            this.position = this.placement.pos();
            this.order = this.placement.order();
        }
    }

    private boolean isClientHandled() {
        if (!NostalgicTweaks.isNetworkVerified() || NetUtil.isSingleplayer() || Minecraft.m_91087_().f_91073_ == null) {
            return true;
        }
        return !this.isDynamic() && this.isClient();
    }

    public void setTweak(Tweak tweak) {
        this.tweak = tweak;
    }

    public T getDefault() {
        return ClientReflect.getDefault(this.group, this.key);
    }

    public T getValue() {
        return this.isClientHandled() ? this.value : this.getServerTweak().getValue();
    }

    public T getSavedValue() {
        return ClientReflect.getCurrent(this.group, this.key);
    }

    public void setValue(T value, boolean override) {
        if (this.isClientHandled() || override) {
            this.value = value;
            TweakServerCache<T> serverTweak = this.getServerTweak();
            if (override && serverTweak != null) {
                serverTweak.setValue(value);
            }
        } else {
            this.getServerTweak().setValue(value);
        }
    }

    public void setValue(T value) {
        this.setValue(value, false);
    }

    @Override
    public TweakStatus getStatus() {
        return this.isClientHandled() ? this.status : this.getServerTweak().getStatus();
    }

    @Override
    public void setStatus(TweakStatus status) {
        if (this.isClientHandled()) {
            this.status = status;
        } else {
            this.getServerTweak().setStatus(status);
        }
    }

    @CheckForNull
    public TweakGui.Position getPosition() {
        return this.position;
    }

    public int getOrder() {
        return this.order;
    }

    public void reset() {
        if (this.isClientHandled()) {
            this.value = this.getDefault();
        } else {
            this.getServerTweak().setValue(this.getDefault());
        }
    }

    public void undo() {
        Object value = ClientReflect.getCurrent(this.group, this.key);
        if (this.isClientHandled()) {
            this.value = value;
        } else {
            this.getServerTweak().setValue(this.getServerCache());
        }
    }

    public void save() {
        T value;
        boolean isMultiplayer;
        if (this.getList() != null || !this.isSavable()) {
            return;
        }
        if (this.isAnnotatedReloadChunks) {
            RunUtil.reloadChunks = true;
        }
        if (this.isAnnotatedReloadResources) {
            RunUtil.reloadResources = true;
        }
        boolean isClient = this.isClient();
        boolean isDynamic = this.isDynamic() && NetUtil.isPlayerOp();
        boolean isServerTweak = isDynamic || !isClient;
        boolean bl = isMultiplayer = NostalgicTweaks.isNetworkVerified() && NetUtil.isMultiplayer();
        if (NetUtil.isSingleplayer() && isServerTweak) {
            this.getServerTweak().setValue(this.value);
            this.getServerTweak().setServerCache(this.value);
        }
        if (isServerTweak && isMultiplayer) {
            PacketUtil.sendToServer(new PacketC2SChangeTweak(this.getServerTweak()));
            ToastNotification.sentChanges();
        }
        T t = value = isDynamic && isMultiplayer ? this.getServerTweak().getValue() : this.value;
        if (NetUtil.isLocalHost() || this.isClientHandled() || isDynamic) {
            ClientReflect.setConfig(this.group, this.key, value);
        }
    }

    public boolean isNew() {
        return this.isAnnotatedNew;
    }

    public boolean isClient() {
        return this.isAnnotatedClient;
    }

    public boolean isServer() {
        return this.isAnnotatedServer;
    }

    public boolean isDynamic() {
        return this.isAnnotatedDynamic;
    }

    public boolean isLocked() {
        if (this.isClient() && !this.isDynamic()) {
            return false;
        }
        return NostalgicTweaks.isNetworkVerified() && !NetUtil.isPlayerOp();
    }

    public boolean isResettable() {
        if (!this.isClientHandled() && !NetUtil.isPlayerOp()) {
            return false;
        }
        T current = this.getValue();
        T def = this.getDefault();
        if (current instanceof Integer && def instanceof Integer) {
            return ((Integer)current).compareTo((Integer)def) != 0;
        }
        return !current.equals(def);
    }

    public boolean isSavable() {
        T cache;
        T current = this.getValue();
        T t = cache = this.isClientHandled() ? ClientReflect.getCurrent(this.group, this.key) : this.getServerCache();
        if (current instanceof Integer && cache instanceof Integer) {
            return ((Integer)current).compareTo((Integer)cache) != 0;
        }
        return !current.equals(cache);
    }

    public boolean isNotAutomated() {
        return this.isAnnotatedNotAutomated;
    }

    @CheckForNull
    public TweakGui.Placement getPlacement() {
        return this.placement;
    }

    @CheckForNull
    public TweakGui.Category getCategory() {
        return this.category;
    }

    @CheckForNull
    public TweakGui.Subcategory getSubcategory() {
        return this.subcategory;
    }

    @CheckForNull
    public TweakGui.Embed getEmbed() {
        return this.embed;
    }

    public String getContainerTranslation() {
        if (this.category != null) {
            return Component.m_237115_((String)this.category.container().getLangKey()).getString();
        }
        if (this.subcategory != null) {
            return Component.m_237115_((String)this.subcategory.container().getLangKey()).getString();
        }
        if (this.embed != null) {
            return Component.m_237115_((String)this.embed.container().getLangKey()).getString();
        }
        return "";
    }

    static {
        Arrays.stream(TweakGroup.values()).forEach(group -> ClientReflect.getGroup(group).forEach((key, value) -> CACHE.put(TweakClientCache.generateKey(group, key), new TweakClientCache<Object>((TweakGroup)((Object)group), (String)key, value))));
    }
}

