/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.event;

import java.util.Optional;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.config.gui.screen.SettingsScreen;
import mod.adrenix.nostalgic.client.config.reflect.TweakClientCache;
import mod.adrenix.nostalgic.client.screen.NostalgicLoadingScreen;
import mod.adrenix.nostalgic.client.screen.NostalgicProgressScreen;
import mod.adrenix.nostalgic.client.screen.NostalgicTitleScreen;
import mod.adrenix.nostalgic.common.config.ModConfig;
import mod.adrenix.nostalgic.server.config.reflect.TweakServerCache;
import mod.adrenix.nostalgic.util.client.FogUtil;
import mod.adrenix.nostalgic.util.client.KeyUtil;
import mod.adrenix.nostalgic.util.client.WorldClientUtil;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public abstract class ClientEventHelper {
    public static void disconnect() {
        if (NostalgicTweaks.isClient()) {
            FogUtil.Void.reset();
            WorldClientUtil.resetLightingCache();
            WorldClientUtil.resetWorldInterpolationCache();
            NostalgicTweaks.setNetworkVerification(false);
            NostalgicTweaks.setConnection(null);
            TweakServerCache.all().forEach((id, tweak) -> {
                if (tweak.isDynamic()) {
                    tweak.setValue(TweakClientCache.all().get(id).getValue());
                }
            });
        }
    }

    public static void onChangeDimension() {
        WorldClientUtil.resetWorldInterpolationCache();
    }

    public static void gotoSettingsOnMatchedKey(Minecraft minecraft, Screen screen, int keyCode, int scanCode) {
        if (ClassUtil.isNotInstanceOf(screen, TitleScreen.class)) {
            return;
        }
        Optional<KeyMapping> mapping = KeyUtil.find("key.nostalgic_tweaks.open_config");
        if (mapping.isPresent() && mapping.get().m_90832_(keyCode, scanCode)) {
            minecraft.m_91152_((Screen)new SettingsScreen(screen, true));
        }
    }

    private static boolean isLoadingScreen(Screen screen) {
        return screen.getClass() == NostalgicProgressScreen.class || screen.getClass() == ProgressScreen.class || screen.getClass() == ReceivingLevelScreen.class;
    }

    public static void classicTitleScreen(Screen screen, SetScreen setScreen) {
        if (screen == null) {
            return;
        }
        if (screen.getClass() == TitleScreen.class) {
            if (ModConfig.Candy.overrideTitleScreen()) {
                setScreen.set((Screen)new NostalgicTitleScreen());
            } else {
                NostalgicTitleScreen.isGameReady = true;
            }
        } else if (!ModConfig.Candy.overrideTitleScreen() && screen.getClass() == NostalgicTitleScreen.class) {
            setScreen.set((Screen)new TitleScreen());
        }
    }

    public static void classicProgressScreen(Screen screen, SetScreen setScreen) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (screen == null || !ModConfig.Candy.oldLoadingScreens()) {
            return;
        }
        if (screen.getClass() == LevelLoadingScreen.class) {
            MutableComponent title = Component.m_237115_((String)"gui.nostalgic_tweaks.level.loading");
            MutableComponent subtitle = Component.m_237115_((String)"gui.nostalgic_tweaks.level.building");
            setScreen.set(new NostalgicLoadingScreen(minecraft.m_167983_(), (Component)title, (Component)subtitle));
        }
        if (ClientEventHelper.isLoadingScreen(screen)) {
            if (screen.getClass() == NostalgicProgressScreen.class && !((NostalgicProgressScreen)screen).isTicking()) {
                ((NostalgicProgressScreen)screen).load();
            } else if (screen.getClass() == ProgressScreen.class) {
                progressScreen = new NostalgicProgressScreen((ProgressScreen)screen);
                progressScreen.load();
            } else if (screen.getClass() == ReceivingLevelScreen.class) {
                progressScreen = new NostalgicProgressScreen(new ProgressScreen(true));
                progressScreen.setHeader((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.level.loading"));
                progressScreen.setStage((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.level.simulate"));
                progressScreen.setPauseTicking(1.0);
                progressScreen.setRenderProgressBar(false);
                progressScreen.load();
            }
        }
    }

    public static interface SetScreen {
        public void set(Screen var1);
    }
}

