/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.screen;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import mod.adrenix.nostalgic.util.common.TextureLocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Blocks;
import org.lwjgl.system.MemoryStack;

public class NostalgicLogoRenderer {
    private static final String[] MINECRAFT = new String[]{" *   * * *   * *** *** *** *** *** ***", " ** ** * **  * *   *   * * * * *    * ", " * * * * * * * **  *   **  *** **   * ", " *   * * *  ** *   *   * * * * *    * ", " *   * * *   * *** *** * * * * *    * "};
    private LogoEffectRandomizer[][] logoEffects;
    private final Minecraft minecraft = Minecraft.m_91087_();

    public NostalgicLogoRenderer(boolean isEasterEgged) {
        NostalgicLogoRenderer.MINECRAFT[2] = isEasterEgged ? " * * * * * * * *   **  **  *** **   * " : " * * * * * * * **  *   **  *** **   * ";
    }

    public void render(float partialTick) {
        int y;
        if (this.logoEffects == null) {
            this.logoEffects = new LogoEffectRandomizer[MINECRAFT[0].length()][MINECRAFT.length];
            for (int x = 0; x < this.logoEffects.length; ++x) {
                for (y = 0; y < this.logoEffects[x].length; ++y) {
                    this.logoEffects[x][y] = new LogoEffectRandomizer(x, y);
                }
            }
        }
        LogoEffectRandomizer[][] x = this.logoEffects;
        y = x.length;
        for (int i = 0; i < y; ++i) {
            LogoEffectRandomizer[] logoEffect;
            for (LogoEffectRandomizer logoEffectRandomizer : logoEffect = x[i]) {
                logoEffectRandomizer.update(partialTick);
            }
        }
        Window window = this.minecraft.m_91268_();
        int scaleHeight = (int)(120.0 * window.m_85449_());
        RenderSystem.m_157425_((Matrix4f)Matrix4f.m_27625_((double)70.0, (float)((float)window.m_85441_() / (float)scaleHeight), (float)0.05f, (float)100.0f));
        RenderSystem.m_69949_((int)0, (int)(window.m_85442_() - scaleHeight), (int)window.m_85441_(), (int)scaleHeight);
        PoseStack model = RenderSystem.m_157191_();
        model.m_85837_((double)-0.05f, 1.0, 1987.0);
        model.m_85841_(1.59f, 1.59f, 1.59f);
        BakedModel stone = this.minecraft.m_91291_().m_115103_().m_109394_(Blocks.f_50069_.m_5456_());
        RenderSystem.m_157182_();
        RenderSystem.m_69482_();
        RenderSystem.m_69464_();
        RenderSystem.m_69458_((boolean)true);
        for (int pass = 0; pass < 3; ++pass) {
            model.m_85836_();
            if (pass == 0) {
                RenderSystem.m_69421_((int)256, (boolean)Minecraft.f_91002_);
                model.m_85837_(0.0, (double)-0.4f, 0.0);
                model.m_85841_(0.98f, 1.0f, 1.0f);
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
            }
            if (pass == 1) {
                RenderSystem.m_69461_();
                RenderSystem.m_69421_((int)256, (boolean)Minecraft.f_91002_);
            }
            if (pass == 2) {
                RenderSystem.m_69478_();
                RenderSystem.m_69405_((int)768, (int)1);
            }
            model.m_85841_(1.0f, -1.0f, 1.0f);
            model.m_85845_(Vector3f.f_122223_.m_122240_(15.0f));
            model.m_85841_(0.89f, 1.0f, 0.4f);
            model.m_85837_((double)((float)(-MINECRAFT[0].length()) * 0.5f), (double)((float)(-MINECRAFT.length) * 0.5f), 0.0);
            if (pass == 0) {
                RenderSystem.m_157427_(GameRenderer::m_172646_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)TextureLocation.BLOCK_SHADOW);
            } else {
                RenderSystem.m_157427_(GameRenderer::m_172823_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            }
            for (int y2 = 0; y2 < MINECRAFT.length; ++y2) {
                for (int x2 = 0; x2 < MINECRAFT[y2].length(); ++x2) {
                    if (MINECRAFT[y2].charAt(x2) == ' ') continue;
                    model.m_85836_();
                    float z = this.logoEffects[x2][y2].position;
                    float scale = 1.0f;
                    float alpha = 1.0f;
                    if (pass == 0) {
                        scale = z * 0.04f + 1.0f;
                        alpha = 1.0f / scale;
                        z = 0.0f;
                    }
                    model.m_85837_((double)x2, (double)y2, (double)z);
                    model.m_85841_(scale, scale, scale);
                    this.renderBlock(model, stone, pass, alpha);
                    model.m_85849_();
                }
            }
            model.m_85849_();
        }
        RenderSystem.m_69461_();
        RenderSystem.m_157425_((Matrix4f)Matrix4f.m_162203_((float)0.0f, (float)window.m_85445_(), (float)0.0f, (float)window.m_85446_(), (float)1000.0f, (float)3000.0f));
        RenderSystem.m_69949_((int)0, (int)0, (int)window.m_85441_(), (int)window.m_85442_());
        model.m_166856_();
        model.m_85837_(0.0, 0.0, -2000.0);
        RenderSystem.m_157182_();
        RenderSystem.m_69481_();
    }

    private int getColorFromRGBA(float red, float green, float blue, float alpha) {
        return (int)(alpha * 255.0f) << 24 | (int)(red * 255.0f) << 16 | (int)(green * 255.0f) << 8 | (int)(blue * 255.0f);
    }

    private int getColorFromBrightness(float brightness, float alpha) {
        return this.getColorFromRGBA(brightness, brightness, brightness, alpha);
    }

    private void renderQuad(PoseStack.Pose modelPose, BufferBuilder builder, BakedQuad quad, float brightness, float alpha) {
        int combinedLight = this.getColorFromBrightness(brightness, alpha);
        int[] vertices = quad.m_111303_();
        Vec3i vec = quad.m_111306_().m_122436_();
        Vector3f vec3f = new Vector3f((float)vec.m_123341_(), (float)vec.m_123342_(), (float)vec.m_123343_());
        Matrix4f matrix = modelPose.m_85861_();
        vec3f.m_122249_(modelPose.m_85864_());
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            ByteBuffer byteBuffer = memoryStack.malloc(DefaultVertexFormat.f_85811_.m_86020_());
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            for (int i = 0; i < vertices.length / 8; ++i) {
                intBuffer.clear();
                intBuffer.put(vertices, i * 8, 8);
                float x = byteBuffer.getFloat(0);
                float y = byteBuffer.getFloat(4);
                float z = byteBuffer.getFloat(8);
                Vector4f vec4f = new Vector4f(x, y, z, 1.0f);
                vec4f.m_123607_(matrix);
                builder.m_5954_(vec4f.m_123601_(), vec4f.m_123615_(), vec4f.m_123616_(), 1.0f, 1.0f, 1.0f, alpha, byteBuffer.getFloat(16), byteBuffer.getFloat(20), OverlayTexture.f_118083_, combinedLight, vec3f.m_122239_(), vec3f.m_122260_(), vec3f.m_122269_());
            }
        }
    }

    private void renderBlock(PoseStack modelView, BakedModel stone, int pass, float alpha) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        for (Direction direction : Direction.values()) {
            float brightness = switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.DOWN -> 1.0f;
                case Direction.UP -> 0.5f;
                case Direction.NORTH -> 0.0f;
                case Direction.SOUTH -> 0.8f;
                case Direction.WEST, Direction.EAST -> 0.6f;
            };
            int color = this.getColorFromBrightness(brightness, alpha);
            for (BakedQuad quad : stone.m_213637_(null, direction, RandomSource.m_216327_())) {
                if (pass == 0) {
                    this.renderQuad(modelView.m_85850_(), builder, quad, brightness, alpha);
                    continue;
                }
                builder.m_85987_(modelView.m_85850_(), quad, brightness, brightness, brightness, color, OverlayTexture.f_118083_);
            }
        }
        tesselator.m_85914_();
    }

    private static class LogoEffectRandomizer {
        public float position;
        public float speed;

        public LogoEffectRandomizer(int x, int y) {
            this.position = (float)(10 + y) + RandomSource.m_216327_().m_188501_() * 32.0f + (float)x;
        }

        public void update(float partialTick) {
            if (this.position > 0.0f) {
                this.speed -= 0.4f;
            }
            this.position += this.speed * partialTick;
            this.speed *= 0.9f;
            if (this.position < 0.0f) {
                this.position = 0.0f;
                this.speed = 0.0f;
            }
        }
    }
}

