/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.realmsclient.RealmsMainScreen;
import mod.adrenix.nostalgic.common.config.ModConfig;
import mod.adrenix.nostalgic.common.config.tweak.TweakVersion;
import mod.adrenix.nostalgic.mixin.widen.ScreenAccessor;
import mod.adrenix.nostalgic.util.client.GuiUtil;
import mod.adrenix.nostalgic.util.client.NetUtil;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.ShareToLanScreen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.achievement.StatsScreen;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class NostalgicPauseScreen
extends PauseScreen {
    private final TweakVersion.PauseLayout layout;
    private final Component mods = Component.m_237115_((String)"gui.nostalgic_tweaks.config.candy.title.mods");
    private final Component lan = Component.m_237115_((String)"menu.shareToLan");
    private final Component stats = Component.m_237115_((String)"gui.stats");
    private final Component options = Component.m_237115_((String)"menu.options");
    private final Component disconnect = Component.m_237115_((String)"menu.disconnect");
    private final Component toUpperBack = Component.m_237115_((String)"menu.returnToGame");
    private final Component toLowerBack = Component.m_237115_((String)"gui.nostalgic_tweaks.pause.return");
    private final Component achievements = Component.m_237115_((String)"gui.nostalgic_tweaks.pause.achievements");
    private boolean isFirstRender = false;

    public NostalgicPauseScreen() {
        super(true);
        this.layout = ModConfig.Candy.getPauseLayout();
    }

    private static String getPauseTitle() {
        return switch (ModConfig.Candy.getPauseLayout()) {
            default -> throw new IncompatibleClassChangeError();
            case TweakVersion.PauseLayout.ALPHA_BETA, TweakVersion.PauseLayout.ACHIEVE_LOWER, TweakVersion.PauseLayout.ACHIEVE_UPPER, TweakVersion.PauseLayout.LAN -> "gui.nostalgic_tweaks.pause.game";
            case TweakVersion.PauseLayout.ADVANCEMENT, TweakVersion.PauseLayout.MODERN -> "menu.game";
        };
    }

    protected void m_7856_() {
        ((ScreenAccessor)((Object)this)).NT$setTitle((Component)Component.m_237115_((String)NostalgicPauseScreen.getPauseTitle()));
        this.setLayout();
    }

    public void m_86600_() {
        super.m_86600_();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (!this.isFirstRender) {
            if (ModConfig.Candy.removeExtraPauseButtons()) {
                this.m_169413_();
                this.m_7856_();
            }
            this.isFirstRender = true;
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    private void setLayout() {
        switch (this.layout) {
            case LAN: {
                this.setLanLayout();
                break;
            }
            case ALPHA_BETA: {
                this.setAlphaLayout();
                break;
            }
            case ADVANCEMENT: {
                this.setAdvancementLayout();
                break;
            }
            case ACHIEVE_LOWER: {
                this.setLowerAchieveLayout();
                break;
            }
            case ACHIEVE_UPPER: {
                this.setUpperAchieveLayout();
            }
        }
        for (Widget widget : ((ScreenAccessor)((Object)this)).NT$getRenderables()) {
            Button button;
            if (!(widget instanceof Button) || !(button = (Button)widget).m_6035_().getString().equals(this.lan.getString())) continue;
            ((Button)widget).f_93623_ = !NetUtil.isMultiplayer();
        }
    }

    private boolean isMultiplayer() {
        return NetUtil.isMultiplayer() && !NetUtil.isLocalHost();
    }

    private Component getSave(boolean isLower) {
        String lower = "gui.nostalgic_tweaks.pause.save";
        String upper = "menu.returnToMenu";
        return this.isMultiplayer() ? this.disconnect : Component.m_237115_((String)(isLower ? lower : upper));
    }

    private void returnToGame(Button unused) {
        if (this.f_96541_ == null) {
            return;
        }
        this.f_96541_.m_91152_(null);
        this.f_96541_.f_91067_.m_91601_();
    }

    private void saveOrQuit(Button button) {
        if (this.f_96541_ == null || this.f_96541_.f_91073_ == null) {
            return;
        }
        boolean isLocalServer = this.f_96541_.m_91090_();
        boolean isRealms = this.f_96541_.m_91294_();
        button.f_93623_ = false;
        this.f_96541_.f_91073_.m_7462_();
        if (isLocalServer) {
            this.f_96541_.m_91320_((Screen)new GenericDirtMessageScreen((Component)Component.m_237115_((String)"menu.savingLevel")));
        } else {
            this.f_96541_.m_91399_();
        }
        TitleScreen title = new TitleScreen();
        if (isLocalServer) {
            this.f_96541_.m_91152_((Screen)title);
        } else if (isRealms) {
            this.f_96541_.m_91152_((Screen)new RealmsMainScreen((Screen)title));
        } else {
            this.f_96541_.m_91152_((Screen)new JoinMultiplayerScreen((Screen)title));
        }
    }

    private void gotoOptions(Button unused) {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_((Screen)new OptionsScreen((Screen)this, this.f_96541_.f_91066_));
        }
    }

    private void gotoAchievements(Button unused) {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.f_96541_.m_91152_((Screen)new AdvancementsScreen(this.f_96541_.f_91074_.f_108617_.m_105145_()));
        }
    }

    private void gotoStats(Button unused) {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.f_96541_.m_91152_((Screen)new StatsScreen((Screen)this, this.f_96541_.f_91074_.m_108630_()));
        }
    }

    private void gotoLan(Button unused) {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_((Screen)new ShareToLanScreen((Screen)this));
        }
    }

    private void gotoMods(Button unused) {
        if (this.f_96541_ != null && GuiUtil.modScreen != null) {
            this.f_96541_.m_91152_(GuiUtil.modScreen.apply(this.f_96541_.f_91080_));
        }
    }

    private int getX() {
        return this.f_96543_ / 2 - 100;
    }

    private int getY() {
        return this.f_96544_ / 4;
    }

    private int getSmallX() {
        return this.getX() + this.getSmallWidth() + 4;
    }

    private int getHeight() {
        return 20;
    }

    private int getBigWidth() {
        return 200;
    }

    private int getSmallWidth() {
        return 98;
    }

    private int getFirstRow() {
        return this.getY() + 8;
    }

    private int getSecondRow() {
        return this.getFirstRow() + 24;
    }

    private int getThirdRow() {
        return this.getSecondRow() + 24;
    }

    private int getFourthRow() {
        return this.getThirdRow() + 24;
    }

    private int getFifthRow() {
        return this.getFourthRow() + 24;
    }

    private int getSixthRow() {
        return this.getFifthRow() + 24;
    }

    private void setAlphaLayout() {
        this.m_142416_((GuiEventListener)new Button(this.getX(), this.getY() + 24, this.getBigWidth(), this.getHeight(), this.toLowerBack, this::returnToGame));
        this.m_142416_((GuiEventListener)new Button(this.getX(), this.getY() + 48, this.getBigWidth(), this.getHeight(), this.getSave(true), this::saveOrQuit));
        if (ModConfig.Candy.includeModsOnPause() && GuiUtil.modScreen != null) {
            this.m_142416_((GuiEventListener)new Button(this.getX(), this.getY() + 96, this.getSmallWidth(), this.getHeight(), this.options, this::gotoOptions));
            this.m_142416_((GuiEventListener)new Button(this.getSmallX(), this.getY() + 96, this.getSmallWidth(), this.getHeight(), this.mods, this::gotoMods));
        } else {
            this.m_142416_((GuiEventListener)new Button(this.getX(), this.getY() + 96, this.getBigWidth(), this.getHeight(), this.options, this::gotoOptions));
        }
    }

    private void setLowerAchieveLayout() {
        this.m_142416_((GuiEventListener)new Button(this.getX(), this.getFirstRow(), this.getBigWidth(), this.getHeight(), this.toLowerBack, this::returnToGame));
        this.m_142416_((GuiEventListener)new Button(this.getX(), this.getSecondRow(), this.getSmallWidth(), this.getHeight(), this.achievements, this::gotoAchievements));
        this.m_142416_((GuiEventListener)new Button(this.getSmallX(), this.getSecondRow(), this.getSmallWidth(), this.getHeight(), this.stats, this::gotoStats));
        if (ModConfig.Candy.includeModsOnPause() && GuiUtil.modScreen != null) {
            this.m_142416_((GuiEventListener)new Button(this.getX(), this.getFourthRow(), this.getSmallWidth(), this.getHeight(), this.options, this::gotoOptions));
            this.m_142416_((GuiEventListener)new Button(this.getSmallX(), this.getFourthRow(), this.getSmallWidth(), this.getHeight(), this.mods, this::gotoMods));
        } else {
            this.m_142416_((GuiEventListener)new Button(this.getX(), this.getFourthRow(), this.getBigWidth(), this.getHeight(), this.options, this::gotoOptions));
        }
        this.m_142416_((GuiEventListener)new Button(this.getX(), this.getFifthRow(), this.getBigWidth(), this.getHeight(), this.getSave(true), this::saveOrQuit));
    }

    private void setUpperAchieveLayout() {
        this.m_142416_((GuiEventListener)new Button(this.getX(), this.getFirstRow(), this.getBigWidth(), this.getHeight(), this.toUpperBack, this::returnToGame));
        this.m_142416_((GuiEventListener)new Button(this.getX(), this.getSecondRow(), this.getSmallWidth(), this.getHeight(), this.achievements, this::gotoAchievements));
        this.m_142416_((GuiEventListener)new Button(this.getSmallX(), this.getSecondRow(), this.getSmallWidth(), this.getHeight(), this.stats, this::gotoStats));
        if (ModConfig.Candy.includeModsOnPause() && GuiUtil.modScreen != null) {
            this.m_142416_((GuiEventListener)new Button(this.getX(), this.getFourthRow(), this.getSmallWidth(), this.getHeight(), this.options, this::gotoOptions));
            this.m_142416_((GuiEventListener)new Button(this.getSmallX(), this.getFourthRow(), this.getSmallWidth(), this.getHeight(), this.mods, this::gotoMods));
        } else {
            this.m_142416_((GuiEventListener)new Button(this.getX(), this.getFourthRow(), this.getBigWidth(), this.getHeight(), this.options, this::gotoOptions));
        }
        this.m_142416_((GuiEventListener)new Button(this.getX(), this.getFifthRow(), this.getBigWidth(), this.getHeight(), this.getSave(false), this::saveOrQuit));
    }

    private void setLanLayout() {
        boolean isMods;
        this.m_142416_((GuiEventListener)new Button(this.getX(), this.getFirstRow(), this.getBigWidth(), this.getHeight(), this.toUpperBack, this::returnToGame));
        this.m_142416_((GuiEventListener)new Button(this.getX(), this.getSecondRow(), this.getSmallWidth(), this.getHeight(), this.achievements, this::gotoAchievements));
        this.m_142416_((GuiEventListener)new Button(this.getSmallX(), this.getSecondRow(), this.getSmallWidth(), this.getHeight(), this.stats, this::gotoStats));
        boolean bl = isMods = ModConfig.Candy.includeModsOnPause() && GuiUtil.modScreen != null;
        if (isMods) {
            this.m_142416_((GuiEventListener)new Button(this.getX(), this.getThirdRow(), this.getBigWidth(), this.getHeight(), this.mods, this::gotoMods));
        }
        this.m_142416_((GuiEventListener)new Button(this.getX(), isMods ? this.getFifthRow() : this.getFourthRow(), this.getSmallWidth(), this.getHeight(), this.options, this::gotoOptions));
        this.m_142416_((GuiEventListener)new Button(this.getSmallX(), isMods ? this.getFifthRow() : this.getFourthRow(), this.getSmallWidth(), this.getHeight(), this.lan, this::gotoLan));
        this.m_142416_((GuiEventListener)new Button(this.getX(), isMods ? this.getSixthRow() : this.getFifthRow(), this.getBigWidth(), this.getHeight(), this.getSave(false), this::saveOrQuit));
    }

    private void setAdvancementLayout() {
        boolean isMods;
        MutableComponent advance = Component.m_237115_((String)"gui.advancements");
        this.m_142416_((GuiEventListener)new Button(this.getX(), this.getFirstRow(), this.getBigWidth(), this.getHeight(), this.toUpperBack, this::returnToGame));
        this.m_142416_((GuiEventListener)new Button(this.getX(), this.getSecondRow(), this.getSmallWidth(), this.getHeight(), (Component)advance, this::gotoAchievements));
        this.m_142416_((GuiEventListener)new Button(this.getSmallX(), this.getSecondRow(), this.getSmallWidth(), this.getHeight(), this.stats, this::gotoStats));
        boolean bl = isMods = ModConfig.Candy.includeModsOnPause() && GuiUtil.modScreen != null;
        if (isMods) {
            this.m_142416_((GuiEventListener)new Button(this.getX(), this.getThirdRow(), this.getBigWidth(), this.getHeight(), this.mods, this::gotoMods));
        }
        this.m_142416_((GuiEventListener)new Button(this.getX(), isMods ? this.getFifthRow() : this.getFourthRow(), this.getSmallWidth(), this.getHeight(), this.options, this::gotoOptions));
        this.m_142416_((GuiEventListener)new Button(this.getSmallX(), isMods ? this.getFifthRow() : this.getFourthRow(), this.getSmallWidth(), this.getHeight(), this.lan, this::gotoLan));
        this.m_142416_((GuiEventListener)new Button(this.getX(), isMods ? this.getSixthRow() : this.getFifthRow(), this.getBigWidth(), this.getHeight(), this.getSave(false), this::saveOrQuit));
    }
}

