/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import mod.adrenix.nostalgic.client.screen.ProgressRenderer;
import mod.adrenix.nostalgic.mixin.widen.ProgressScreenAccessor;
import mod.adrenix.nostalgic.util.client.RunUtil;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProgressListener;
import net.minecraft.world.level.Level;

public class NostalgicProgressScreen
extends Screen
implements ProgressListener {
    @CheckForNull
    private Component header;
    @CheckForNull
    private Component stage;
    private int progress = 0;
    private double pauseTicking = 0.98;
    private boolean renderProgressBar = true;
    private boolean ticking = false;
    private boolean stop;
    private final ProgressScreenAccessor progressScreen;
    private static ResourceKey<Level> previousDimension;
    private static ResourceKey<Level> currentDimension;
    public static final double NO_PAUSES = 1.0;

    public NostalgicProgressScreen(ProgressScreen progressScreen) {
        super((Component)Component.m_237119_());
        this.progressScreen = (ProgressScreenAccessor)progressScreen;
    }

    public boolean isTicking() {
        return this.ticking;
    }

    public void setRenderProgressBar(boolean state) {
        this.renderProgressBar = state;
    }

    public void setPauseTicking(double pause) {
        this.pauseTicking = pause;
    }

    public void setHeader(@Nullable Component header) {
        this.header = header;
    }

    public void setStage(@Nullable Component stage) {
        this.stage = stage;
    }

    public static void setPreviousDimension(ResourceKey<Level> setter) {
        previousDimension = setter;
    }

    public static void setCurrentDimension(ResourceKey<Level> setter) {
        currentDimension = setter;
    }

    @CheckForNull
    public static ResourceKey<Level> getPreviousDimension() {
        return previousDimension;
    }

    @CheckForNull
    public static ResourceKey<Level> getCurrentDimension() {
        return currentDimension;
    }

    public boolean m_6913_() {
        return false;
    }

    public void m_7730_() {
        this.stop = true;
    }

    public void m_7861_() {
        this.m_7730_();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.f_96541_ == null) {
            return;
        }
        this.setHeaderAndStage();
        if (this.header == null && this.stage == null) {
            this.ticking = false;
            return;
        }
        this.m_96626_(0);
        if (this.renderProgressBar) {
            ProgressRenderer.renderProgressWithInt(this.progress);
        }
        this.renderDrawableText(poseStack);
        if (this.stop && this.progressScreen.NT$getClearScreenAfterStop()) {
            this.f_96541_.m_91152_(null);
        }
    }

    public void m_6309_(Component component) {
    }

    public void m_6308_(Component header) {
    }

    public void m_6307_(Component stage) {
    }

    public void m_6952_(int progress) {
    }

    public void load() {
        Minecraft minecraft = Minecraft.m_91087_();
        this.ticking = true;
        this.progress = -1;
        while (minecraft.m_91396_() && this.ticking && this.progress < 100) {
            long start = Util.m_137550_();
            double pause = Math.random();
            double wait = (long)(Math.random() + (pause > this.pauseTicking ? Math.random() * 1000.0 : 0.0));
            while ((double)(Util.m_137550_() - start) < wait) {
                RunUtil.nothing();
            }
            ++this.progress;
            minecraft.m_91346_((Screen)this);
        }
        this.ticking = false;
    }

    private void setHeaderAndStage() {
        boolean isChangingLevel;
        Minecraft minecraft = Minecraft.m_91087_();
        MutableComponent header = (MutableComponent)this.header;
        ResourceKey<Level> currentLevel = NostalgicProgressScreen.getCurrentDimension();
        ResourceKey<Level> previousLevel = NostalgicProgressScreen.getPreviousDimension();
        if (header != null && header.getString().equals(Component.m_237115_((String)"menu.savingLevel").getString())) {
            this.setHeader(null);
            this.setStage((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.level.saving"));
            this.setPauseTicking(1.0);
        }
        boolean isTextNeeded = header == null && this.stage == null;
        boolean isMultiplayer = minecraft.m_91403_() != null;
        boolean isConnectedLevel = isMultiplayer && minecraft.f_91073_ != null;
        boolean bl = isChangingLevel = minecraft.f_91074_ != null && currentLevel != null && previousLevel != null;
        if (isTextNeeded && (!isMultiplayer || isConnectedLevel) && isChangingLevel) {
            if (currentLevel == Level.f_46429_) {
                this.setHeader((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.level.enterNether"));
                this.setStage((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.level.building"));
            } else if (currentLevel == Level.f_46430_) {
                this.setHeader((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.level.enterEnd"));
                this.setStage((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.level.building"));
            } else if (currentLevel == Level.f_46428_) {
                if (previousLevel == Level.f_46429_) {
                    this.setHeader((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.level.leaveNether"));
                    this.setStage((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.level.building"));
                } else if (previousLevel == Level.f_46430_) {
                    this.setHeader((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.level.leaveEnd"));
                    this.setStage((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.level.building"));
                }
            }
            if (this.stage == null) {
                this.setHeader((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.level.loading"));
                this.setStage((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.level.building"));
            }
        }
    }

    private void renderDrawableText(PoseStack poseStack) {
        if (this.header != null) {
            ProgressRenderer.drawTitleText(poseStack, this, this.header);
        }
        if (this.stage != null) {
            ProgressRenderer.drawSubtitleText(poseStack, this, this.stage);
        }
    }
}

