/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mod.adrenix.nostalgic.client.screen.NostalgicLogoRenderer;
import mod.adrenix.nostalgic.common.config.ModConfig;
import mod.adrenix.nostalgic.common.config.tweak.TweakVersion;
import mod.adrenix.nostalgic.mixin.widen.ScreenAccessor;
import mod.adrenix.nostalgic.mixin.widen.TitleScreenAccessor;
import mod.adrenix.nostalgic.util.client.GuiUtil;
import mod.adrenix.nostalgic.util.common.TextureLocation;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.LanguageSelectScreen;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class NostalgicTitleScreen
extends TitleScreen {
    public static boolean isGameReady = false;
    private long updateScreenDelay = 0L;
    private final boolean isEasterEgged = (double)RandomSource.m_216327_().m_188501_() < 1.0E-4;
    private static final int BUTTON_WIDTH = 200;
    private static final int BUTTON_HEIGHT = 20;
    private static final ResourceLocation OVERLAY = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    private final PanoramaRenderer panorama = new PanoramaRenderer(TitleScreen.f_96716_);
    private final List<Widget> alpha = new ArrayList<Widget>();
    private final List<Widget> beta = new ArrayList<Widget>();
    private final List<Widget> release = new ArrayList<Widget>();
    private final NostalgicLogoRenderer logo = new NostalgicLogoRenderer(this.isEasterEgged);

    protected void m_7856_() {
        List<Widget> widgets;
        int x = this.f_96543_ / 2 - 100;
        int y = this.f_96544_ / 4 + 48;
        int rowHeight = 24;
        this.alpha.clear();
        this.beta.clear();
        this.release.clear();
        this.createAlphaOptions(x, y, rowHeight);
        this.createBetaOptions(x, y, rowHeight);
        this.createReleaseOptions(x, y, rowHeight);
        switch (ModConfig.Candy.getButtonLayout()) {
            case ALPHA: {
                List<Widget> list = this.alpha;
                break;
            }
            case BETA: {
                List<Widget> list = this.beta;
                break;
            }
            default: {
                List<Widget> list = widgets = this.release;
            }
        }
        if (ModConfig.Candy.getButtonLayout() != TweakVersion.TitleLayout.MODERN) {
            widgets.forEach(widget -> super.m_142416_((GuiEventListener)((AbstractWidget)widget)));
        }
        super.m_7856_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_96541_ == null) {
            return false;
        }
        if (keyCode == 77) {
            this.f_96541_.m_91152_((Screen)new NostalgicTitleScreen());
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return switch (ModConfig.Candy.getButtonLayout()) {
            default -> throw new IncompatibleClassChangeError();
            case TweakVersion.TitleLayout.MODERN -> super.m_6375_(mouseX, mouseY, button);
            case TweakVersion.TitleLayout.ALPHA -> this.getClicked(this.alpha, mouseX, mouseY, button);
            case TweakVersion.TitleLayout.BETA -> this.getClicked(this.beta, mouseX, mouseY, button);
            case TweakVersion.TitleLayout.RELEASE_TEXTURE_PACK, TweakVersion.TitleLayout.RELEASE_NO_TEXTURE_PACK -> this.getClicked(this.release, mouseX, mouseY, button);
        };
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        Component copyright;
        boolean isDelayed;
        if (ModConfig.Candy.oldTitleBackground()) {
            this.m_96626_(0);
        } else {
            this.panorama.m_110003_(partialTick, 1.0f);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)OVERLAY);
            RenderSystem.m_69478_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TitleScreen.m_93160_((PoseStack)poseStack, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (float)0.0f, (float)0.0f, (int)16, (int)128, (int)16, (int)128);
        }
        if (this.updateScreenDelay == 0L) {
            this.updateScreenDelay = Util.m_137550_();
        }
        boolean isModern = ModConfig.Candy.getLoadingOverlay() == TweakVersion.Overlay.MODERN;
        boolean bl = isDelayed = !isGameReady && Util.m_137550_() - this.updateScreenDelay < 1200L;
        if (this.f_96541_ == null || isModern && isDelayed) {
            return;
        }
        if (ModConfig.Candy.oldAlphaLogo()) {
            this.logo.render(partialTick);
        } else {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TextureLocation.MINECRAFT_LOGO);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int width = this.f_96543_ / 2 - 137;
            int height = 30;
            if (ModConfig.Candy.oldLogoOutline()) {
                if (this.isEasterEgged) {
                    this.m_93228_(poseStack, width, height, 0, 0, 99, 44);
                    this.m_93228_(poseStack, width + 99, height, 129, 0, 27, 44);
                    this.m_93228_(poseStack, width + 99 + 26, height, 126, 0, 3, 44);
                    this.m_93228_(poseStack, width + 99 + 26 + 3, height, 99, 0, 26, 44);
                    this.m_93228_(poseStack, width + 155, height, 0, 45, 155, 44);
                } else {
                    this.m_93228_(poseStack, width, height, 0, 0, 155, 44);
                    this.m_93228_(poseStack, width + 155, height, 0, 45, 155, 44);
                }
            } else if (this.isEasterEgged) {
                this.m_93101_(width, height, (x, y) -> {
                    this.m_93228_(poseStack, (int)x, (int)y, 0, 0, 99, 44);
                    this.m_93228_(poseStack, x + 99, (int)y, 129, 0, 27, 44);
                    this.m_93228_(poseStack, x + 99 + 26, (int)y, 126, 0, 3, 44);
                    this.m_93228_(poseStack, x + 99 + 26 + 3, (int)y, 99, 0, 26, 44);
                    this.m_93228_(poseStack, x + 155, (int)y, 0, 45, 155, 44);
                });
            } else {
                this.m_93101_(width, height, (x, y) -> {
                    this.m_93228_(poseStack, (int)x, (int)y, 0, 0, 155, 44);
                    this.m_93228_(poseStack, x + 155, (int)y, 0, 45, 155, 44);
                });
            }
        }
        isGameReady = true;
        TweakVersion.TitleLayout layout = ModConfig.Candy.getButtonLayout();
        TitleScreenAccessor titleAccessor = (TitleScreenAccessor)((Object)this);
        ScreenAccessor screenAccessor = (ScreenAccessor)((Object)this);
        if (titleAccessor.NT$getSplash() != null) {
            poseStack.m_85836_();
            poseStack.m_85837_((double)((float)this.f_96543_ / 2.0f + 90.0f), 70.0, 0.0);
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-20.0f));
            float scale = 1.8f - Mth.m_14154_((float)(Mth.m_14031_((float)((float)(Util.m_137550_() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
            scale = scale * 100.0f / (float)(this.f_96547_.m_92895_(titleAccessor.NT$getSplash()) + 32);
            poseStack.m_85841_(scale, scale, scale);
            TitleScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)titleAccessor.NT$getSplash(), (int)0, (int)-8, (int)0xFFFF00);
            poseStack.m_85849_();
        }
        Object minecraft = ModConfig.Candy.getVersionText();
        switch (layout) {
            case ALPHA: {
                Component component = Component.m_237115_((String)"gui.nostalgic_tweaks.config.candy.title.copyright.alpha");
                break;
            }
            case BETA: {
                Component component = Component.m_237115_((String)"gui.nostalgic_tweaks.config.candy.title.copyright.beta");
                break;
            }
            default: {
                Component component = copyright = f_169438_;
            }
        }
        if (Minecraft.m_193589_().m_184597_() && !ModConfig.Candy.removeTitleModLoaderText()) {
            minecraft = (String)minecraft + "/" + this.f_96541_.m_91389_() + I18n.m_118938_((String)"menu.modded", (Object[])new Object[0]);
        }
        int versionColor = ModConfig.Candy.oldTitleBackground() && !((String)minecraft).contains("\u00a7") ? 0x505050 : 0xFFFFFF;
        int height = ModConfig.Candy.titleBottomLeftText() ? this.f_96544_ - 10 : 2;
        TitleScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)minecraft, (int)2, (int)height, (int)versionColor);
        TitleScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)copyright, (int)(this.f_96543_ - this.f_96547_.m_92852_((FormattedText)copyright) - 2), (int)(this.f_96544_ - 10), (int)0xFFFFFF);
        boolean isRelease = layout == TweakVersion.TitleLayout.RELEASE_TEXTURE_PACK || layout == TweakVersion.TitleLayout.RELEASE_NO_TEXTURE_PACK;
        this.setLayoutVisibility(screenAccessor.NT$getRenderables(), layout == TweakVersion.TitleLayout.MODERN);
        this.setLayoutVisibility(this.alpha, layout == TweakVersion.TitleLayout.ALPHA);
        this.setLayoutVisibility(this.beta, layout == TweakVersion.TitleLayout.BETA);
        this.setLayoutVisibility(this.release, isRelease);
        switch (layout) {
            case MODERN: {
                for (GuiEventListener child : this.m_6702_()) {
                    if (!(child instanceof AbstractWidget)) continue;
                    ((AbstractWidget)child).m_93650_(1.0f);
                }
                this.setButtonVisibility();
                for (Widget widget2 : screenAccessor.NT$getRenderables()) {
                    widget2.m_6305_(poseStack, mouseX, mouseY, partialTick);
                }
                if (!titleAccessor.NT$getRealmsNotificationsEnabled()) break;
                titleAccessor.NT$getRealmsNotificationsScreen().m_6305_(poseStack, mouseX, mouseY, partialTick);
                break;
            }
            case ALPHA: {
                this.alpha.forEach(widget -> widget.m_6305_(poseStack, mouseX, mouseY, partialTick));
                break;
            }
            case BETA: {
                this.beta.forEach(widget -> widget.m_6305_(poseStack, mouseX, mouseY, partialTick));
                break;
            }
            default: {
                this.release.forEach(widget -> widget.m_6305_(poseStack, mouseX, mouseY, partialTick));
            }
        }
    }

    private void setButtonVisibility() {
        ScreenAccessor screen = (ScreenAccessor)((Object)this);
        for (Widget widget : screen.NT$getRenderables()) {
            if (widget instanceof ImageButton && ((ImageButton)widget).f_93620_ == this.f_96543_ / 2 - 124) {
                ((ImageButton)widget).f_93624_ = !ModConfig.Candy.removeLanguageButton();
                continue;
            }
            if (widget instanceof ImageButton && ((ImageButton)widget).f_93620_ == this.f_96543_ / 2 + 104) {
                ((ImageButton)widget).f_93624_ = !ModConfig.Candy.removeAccessibilityButton();
                continue;
            }
            if (!(widget instanceof Button)) continue;
            Button button = (Button)widget;
            boolean isRealms = button.m_6035_().getString().equals(Component.m_237115_((String)"menu.online").getString());
            boolean isRemovable = ModConfig.Candy.removeRealmsButton();
            ((Button)widget).f_93624_ = !isRealms || !isRemovable;
        }
    }

    private void setLayoutVisibility(List<Widget> widgets, boolean visible) {
        for (Widget widget : widgets) {
            if (!(widget instanceof AbstractWidget)) continue;
            ((AbstractWidget)widget).f_93624_ = visible;
        }
    }

    private boolean getClicked(List<Widget> widgets, double mouseX, double mouseY, int button) {
        boolean isClicked = false;
        for (Widget widget : widgets) {
            if (widget instanceof AbstractWidget) {
                isClicked = ((AbstractWidget)widget).m_6375_(mouseX, mouseY, button);
            }
            if (!isClicked) continue;
            break;
        }
        return isClicked;
    }

    private void onSingleplayer(Button ignored) {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_((Screen)new SelectWorldScreen((Screen)this));
        }
    }

    private void onMultiplayer(Button ignored) {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_((Screen)new JoinMultiplayerScreen((Screen)this));
        }
    }

    private void onOptions(Button ignored) {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_((Screen)new OptionsScreen((Screen)this, this.f_96541_.f_91066_));
        }
    }

    private void onMods(Button ignored) {
        if (this.f_96541_ != null && GuiUtil.modScreen != null) {
            this.f_96541_.m_91152_(GuiUtil.modScreen.apply(this.f_96541_.f_91080_));
        }
    }

    private void updatePackList(PackRepository repository) {
        if (this.f_96541_ == null) {
            return;
        }
        Options options = this.f_96541_.f_91066_;
        ImmutableList before = ImmutableList.copyOf((Collection)options.f_92117_);
        options.f_92117_.clear();
        options.f_92118_.clear();
        for (Pack pack : repository.m_10524_()) {
            if (pack.m_10450_()) continue;
            options.f_92117_.add(pack.m_10446_());
            if (pack.m_10443_().m_10489_()) continue;
            options.f_92118_.add(pack.m_10446_());
        }
        options.m_92169_();
        ImmutableList after = ImmutableList.copyOf((Collection)options.f_92117_);
        if (!after.equals((Object)before)) {
            this.f_96541_.m_91391_();
        }
    }

    private void onResources(Button ignored) {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_((Screen)new PackSelectionScreen((Screen)this, this.f_96541_.m_91099_(), this::updatePackList, this.f_96541_.m_91101_(), (Component)Component.m_237115_((String)"resourcePack.title")));
        }
    }

    private void createAlphaOptions(int x, int y, int rowHeight) {
        int row = 1;
        this.alpha.add((Widget)new Button(x, y, 200, 20, (Component)Component.m_237115_((String)"menu.singleplayer"), this::onSingleplayer));
        this.alpha.add((Widget)new Button(x, y + rowHeight, 200, 20, (Component)Component.m_237115_((String)"menu.multiplayer"), this::onMultiplayer));
        if (ModConfig.Candy.includeModsOnTitle() && GuiUtil.modScreen != null) {
            this.alpha.add((Widget)new Button(x, y + rowHeight * ++row, 200, 20, (Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.candy.title.mods"), this::onMods));
        }
        Button tutorial = new Button(x, y + rowHeight * ++row, 200, 20, (Component)Component.m_237119_(), button -> {});
        tutorial.f_93623_ = false;
        tutorial.m_93666_((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.candy.title.tutorial").m_130940_(ChatFormatting.GRAY));
        this.alpha.add((Widget)tutorial);
        this.alpha.add((Widget)new Button(x, y + rowHeight * (++row + 1) - 12, 200, 20, (Component)Component.m_237115_((String)"menu.options"), this::onOptions));
    }

    private void createBetaOptions(int x, int y, int rowHeight) {
        boolean isMods;
        int row = 1;
        this.beta.add((Widget)new Button(x, y, 200, 20, (Component)Component.m_237115_((String)"menu.singleplayer"), this::onSingleplayer));
        this.beta.add((Widget)new Button(x, y + rowHeight, 200, 20, (Component)Component.m_237115_((String)"menu.multiplayer"), this::onMultiplayer));
        boolean bl = isMods = ModConfig.Candy.includeModsOnTitle() && GuiUtil.modScreen != null;
        if (isMods) {
            this.beta.add((Widget)new Button(x, y + rowHeight * ++row, 200, 20, (Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.candy.title.mods"), this::onMods));
        }
        this.beta.add((Widget)new Button(x, y + rowHeight * ++row, 200, 20, (Component)Component.m_237115_((String)(isMods ? "gui.nostalgic_tweaks.config.candy.title.texture_pack" : "gui.nostalgic_tweaks.config.candy.title.mods_texture")), this::onResources));
        this.beta.add((Widget)new Button(x, y + rowHeight * ++row, 200, 20, (Component)Component.m_237115_((String)"menu.options"), this::onOptions));
    }

    private void createReleaseOptions(int x, int y, int rowHeight) {
        boolean isMods;
        int row = 1;
        this.release.add((Widget)new Button(x, y, 200, 20, (Component)Component.m_237115_((String)"menu.singleplayer"), this::onSingleplayer));
        this.release.add((Widget)new Button(x, y + rowHeight, 200, 20, (Component)Component.m_237115_((String)"menu.multiplayer"), this::onMultiplayer));
        boolean bl = isMods = ModConfig.Candy.includeModsOnTitle() && GuiUtil.modScreen != null;
        if (isMods) {
            this.release.add((Widget)new Button(x, y + rowHeight * ++row, 200, 20, (Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.candy.title.mods"), this::onMods));
        }
        if (ModConfig.Candy.getButtonLayout() == TweakVersion.TitleLayout.RELEASE_TEXTURE_PACK) {
            this.release.add((Widget)new Button(x, y + rowHeight * ++row, 200, 20, (Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.candy.title.texture_pack"), this::onResources));
        }
        int lastRow = this.f_96544_ / 4 + 48 + 72 + 12;
        if (this.release.size() == 4) {
            lastRow += 24;
        }
        if (this.f_96541_ != null && !ModConfig.Candy.removeLanguageButton()) {
            this.release.add((Widget)new ImageButton(this.f_96543_ / 2 - 124, lastRow, 20, 20, 0, 106, 20, Button.f_93617_, 256, 256, button -> this.f_96541_.m_91152_((Screen)new LanguageSelectScreen((Screen)this, this.f_96541_.f_91066_, this.f_96541_.m_91102_())), (Component)Component.m_237115_((String)"narrator.button.language")));
        }
        this.release.add((Widget)new Button(this.f_96543_ / 2 - 100, lastRow, 98, 20, (Component)Component.m_237115_((String)"menu.options"), button -> this.f_96541_.m_91152_((Screen)new OptionsScreen((Screen)this, this.f_96541_.f_91066_))));
        this.release.add((Widget)new Button(this.f_96543_ / 2 + 2, lastRow, 98, 20, (Component)Component.m_237115_((String)"menu.quit"), button -> this.f_96541_.m_91395_()));
    }
}

