/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.common.config;

import dev.architectury.platform.Platform;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.config.ClientConfigCache;
import mod.adrenix.nostalgic.common.config.auto.ConfigData;
import mod.adrenix.nostalgic.common.config.auto.serializer.ConfigSerializer;
import mod.adrenix.nostalgic.util.common.PathUtil;

public abstract class BackupConfig {
    private static final String MOD_ID = "nostalgic_tweaks";
    private static final String LOGICAL_SIDE = Platform.getEnv().toString().toLowerCase();
    public static final String FILE_NAME = String.format("%s-%s-backup_%s.json", "nostalgic_tweaks", LOGICAL_SIDE, "%s");
    public static final String STARTUP_NAME = String.format("%s-%s-startup_backup.json", "nostalgic_tweaks", LOGICAL_SIDE);
    private static final String REGEX_MONTH = "[a-z]{3}-\\d{2}-\\d{4}-";
    private static final String REGEX_TIME = "\\d{4}(?>am|pm)(?>_\\d+)?";
    public static final String FILE_REGEX = "nostalgic_tweaks-" + LOGICAL_SIDE + "-backup_[a-z]{3}-\\d{2}-\\d{4}-\\d{4}(?>am|pm)(?>_\\d+)?\\.json";

    private static String getSavedPath(String path, String filename) {
        return String.format("%s%s%s", path, PathUtil.getDirectorySlash(), filename);
    }

    public static <T extends ConfigData> void startup(ConfigSerializer<T> serializer) throws IOException {
        Files.createDirectories(PathUtil.getBackupPath(), new FileAttribute[0]);
        String message = "Created new startup config backup at %s";
        String info = String.format(message, BackupConfig.getSavedPath(PathUtil.getBackupPath().toString(), STARTUP_NAME));
        Files.copy(serializer.getConfigPath(), PathUtil.getBackupPath().resolve(STARTUP_NAME), StandardCopyOption.REPLACE_EXISTING);
        NostalgicTweaks.LOGGER.info(info);
    }

    public static <T extends ConfigData> Path save(ConfigSerializer<T> serializer) throws IOException {
        int limit = 5;
        if (ClientConfigCache.getRoot() != null) {
            limit = ClientConfigCache.getGui().numberOfBackups;
        }
        if (limit != -1) {
            List<Path> oldest = PathUtil.getOldestFiles(PathUtil.getBackupPath(), PathUtil::isBackupFile);
            if (limit != 0 && oldest.size() >= limit) {
                int remove = oldest.size() + 1 - limit;
                for (int i = 0; i < remove; ++i) {
                    PathUtil.delete(oldest.get(i));
                }
            } else if (limit == 0) {
                for (Path file : oldest) {
                    PathUtil.delete(file);
                }
            }
        }
        int underscore = 1;
        String filename = String.format(FILE_NAME, BackupConfig.getTimestamp());
        List<String> backups = PathUtil.getFilenames(PathUtil.getBackupPath(), PathUtil::isBackupFile);
        for (String name : backups) {
            if (!name.equals(filename)) continue;
            boolean naming = true;
            while (naming) {
                boolean isValueFound = false;
                for (String duplicate : backups) {
                    if (!duplicate.equals(filename.replace(".json", String.format("_%s.json", underscore)))) continue;
                    isValueFound = true;
                    break;
                }
                if (!isValueFound) {
                    naming = false;
                    continue;
                }
                ++underscore;
            }
            filename = filename.replace(".json", String.format("_%s.json", underscore));
            break;
        }
        Files.createDirectories(PathUtil.getBackupPath(), new FileAttribute[0]);
        String info = String.format("Created new config backup at %s", BackupConfig.getSavedPath(PathUtil.getBackupPath().toString(), filename));
        Path copy = Files.copy(serializer.getConfigPath(), PathUtil.getBackupPath().resolve(filename), new CopyOption[0]);
        NostalgicTweaks.LOGGER.info(info);
        return copy;
    }

    private static String getTimestamp() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("MMM-dd-yyyy-hhmma")).toLowerCase();
    }
}

