/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.common.config;

import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.config.ClientConfig;
import mod.adrenix.nostalgic.client.config.ClientConfigCache;
import mod.adrenix.nostalgic.common.config.list.ConfigList;
import mod.adrenix.nostalgic.common.config.list.ListMap;
import mod.adrenix.nostalgic.common.config.list.ListSet;
import mod.adrenix.nostalgic.common.config.reflect.TweakStatus;
import mod.adrenix.nostalgic.common.config.tweak.AnimationTweak;
import mod.adrenix.nostalgic.common.config.tweak.CandyTweak;
import mod.adrenix.nostalgic.common.config.tweak.DisabledTweak;
import mod.adrenix.nostalgic.common.config.tweak.GameplayTweak;
import mod.adrenix.nostalgic.common.config.tweak.SoundTweak;
import mod.adrenix.nostalgic.common.config.tweak.Tweak;
import mod.adrenix.nostalgic.common.config.tweak.TweakType;
import mod.adrenix.nostalgic.common.config.tweak.TweakVersion;
import mod.adrenix.nostalgic.network.packet.PacketS2CTweakUpdate;
import mod.adrenix.nostalgic.server.config.ServerConfig;
import mod.adrenix.nostalgic.server.config.ServerConfigCache;
import mod.adrenix.nostalgic.server.config.reflect.TweakServerCache;
import mod.adrenix.nostalgic.util.ModTracker;
import mod.adrenix.nostalgic.util.client.NetUtil;
import mod.adrenix.nostalgic.util.common.PacketUtil;
import net.minecraft.SharedConstants;
import net.minecraft.world.entity.MobCategory;

public abstract class ModConfig {
    private static final ServerConfig.EyeCandy SERVER_CANDY = ServerConfigCache.getCandy();
    private static final ServerConfig.Gameplay SERVER_GAMEPLAY = ServerConfigCache.getGameplay();
    private static final ServerConfig.Animation SERVER_ANIMATION = ServerConfigCache.getAnimation();
    private static final ClientConfig.Animation ANIMATION = ClientConfigCache.getAnimation();
    private static final ClientConfig.Gameplay GAMEPLAY = ClientConfigCache.getGameplay();
    private static final ClientConfig.EyeCandy CANDY = ClientConfigCache.getCandy();
    private static final ClientConfig.Sound SOUND = ClientConfigCache.getSound();
    private static final ClientConfig CONFIG = ClientConfigCache.getRoot();

    public static boolean isTweakOn(Tweak tweak) {
        ModConfig.loadTweak(tweak);
        if (tweak.getCommonCache().isConflict()) {
            return false;
        }
        if (NostalgicTweaks.isServer()) {
            return true;
        }
        if (NetUtil.isLocalHost()) {
            return true;
        }
        if (ModConfig.isTweakExempt(tweak)) {
            return true;
        }
        TweakServerCache cache = TweakServerCache.get(tweak);
        if (!NostalgicTweaks.isNetworkVerified() && cache != null && !cache.isDynamic()) {
            return false;
        }
        return ModConfig.CONFIG.isModEnabled;
    }

    private static boolean isTweakExempt(Tweak tweak) {
        return ModConfig.CONFIG.isModEnabled && (tweak.equals(CandyTweak.CREATIVE_HOTBAR) || tweak.equals(CandyTweak.SQUARE_BORDER) || tweak.equals(GameplayTweak.CART_BOOSTING));
    }

    private static void loadTweak(Tweak tweak) {
        TweakServerCache cache = TweakServerCache.get(tweak);
        if (!tweak.isLoaded() || cache != null && cache.getStatus().equals((Object)TweakStatus.FAIL)) {
            tweak.setEnabled();
            if (cache != null) {
                cache.setStatus(TweakStatus.LOADED);
                if (NostalgicTweaks.isServer() && NostalgicTweaks.getServer() != null) {
                    PacketUtil.sendToAll(new PacketS2CTweakUpdate(cache));
                } else if (NostalgicTweaks.isClient() && NetUtil.getIntegratedServer() != null) {
                    PacketUtil.sendToAll(NetUtil.getIntegratedServer().m_6846_().m_11314_(), new PacketS2CTweakUpdate(cache));
                }
            }
        }
    }

    private static <T> T getSidedTweak(Tweak tweak, T client, T server) {
        boolean isDynamic;
        if (NostalgicTweaks.isServer()) {
            return server;
        }
        if (NetUtil.isSingleplayer()) {
            return client;
        }
        TweakServerCache cache = TweakServerCache.get(tweak);
        boolean bl = isDynamic = cache != null && cache.isDynamic();
        if (isDynamic && NetUtil.isMultiplayer() && !NostalgicTweaks.isNetworkVerified()) {
            return client;
        }
        if (isDynamic || cache != null && NostalgicTweaks.isNetworkVerified()) {
            return cache.getServerCache();
        }
        return client;
    }

    private static boolean getBoolTweak(Tweak tweak, boolean client) {
        return ModConfig.isTweakOn(tweak) && client;
    }

    private static boolean getSidedBoolTweak(Tweak tweak, boolean client, boolean server) {
        return ModConfig.isTweakOn(tweak) && ModConfig.getSidedTweak(tweak, client, server) != false;
    }

    private static <E extends Enum<E>> E getEnum(Tweak tweak, E client) {
        return !ModConfig.isTweakOn(tweak) ? ((DisabledTweak)((Object)client)).getDisabledValue() : client;
    }

    private static <E extends Enum<E>> E getSidedEnum(Tweak tweak, E client, E server) {
        return NostalgicTweaks.isClient() ? ModConfig.getEnum(tweak, client) : server;
    }

    private static <V> ListMap<V> getListMap(Tweak tweak) {
        ModConfig.loadTweak(tweak);
        if (NostalgicTweaks.isServer()) {
            return ConfigList.getMapFromTweak(tweak.getServerCache());
        }
        return ConfigList.getMapFromTweak(tweak.getClientCache());
    }

    private static ListSet getListSet(Tweak tweak) {
        ModConfig.loadTweak(tweak);
        if (NostalgicTweaks.isServer()) {
            return ConfigList.getSetFromTweak(tweak.getServerCache());
        }
        return ConfigList.getSetFromTweak(tweak.getClientCache());
    }

    private static String parseColor(String text, String value) {
        text = text.replaceAll("%([a-fA-F\\d])", "\u00a7$1");
        text = text.replaceAll("%v", value);
        return text;
    }

    public static boolean isModEnabled() {
        return ModConfig.CONFIG.isModEnabled;
    }

    public static class Animation {
        public static float getArmSwayIntensity() {
            float mirror = Animation.shouldMirrorArmSway() ? -1.0f : 1.0f;
            return ModConfig.isTweakOn(AnimationTweak.ARM_SWAY_INTENSITY) ? (float)ModConfig.ANIMATION.armSwayIntensity * mirror / 100.0f : 1.0f;
        }

        public static boolean oldSwing() {
            return ModConfig.getBoolTweak(AnimationTweak.ITEM_SWING, ModConfig.ANIMATION.oldSwing);
        }

        public static boolean oldArmSway() {
            return ModConfig.getBoolTweak(AnimationTweak.ARM_SWAY, ModConfig.ANIMATION.oldArmSway);
        }

        public static boolean oldClassicSwing() {
            return ModConfig.getBoolTweak(AnimationTweak.CLASSIC_SWING, ModConfig.ANIMATION.oldClassicSwing);
        }

        public static boolean oldSwingDropping() {
            return ModConfig.getBoolTweak(AnimationTweak.SWING_DROP, ModConfig.ANIMATION.oldSwingDropping);
        }

        public static boolean oldInterruptSwing() {
            return ModConfig.getBoolTweak(AnimationTweak.SWING_INTERRUPT, ModConfig.ANIMATION.oldSwingInterrupt);
        }

        public static boolean shouldMirrorArmSway() {
            return ModConfig.getBoolTweak(AnimationTweak.ARM_SWAY_MIRROR, ModConfig.ANIMATION.armSwayMirror);
        }

        public static boolean oldToolExplosion() {
            return ModConfig.getBoolTweak(AnimationTweak.TOOL_EXPLODE, ModConfig.ANIMATION.oldToolExplosion);
        }

        public static boolean oldItemCooldown() {
            return ModConfig.getBoolTweak(AnimationTweak.COOLDOWN, ModConfig.ANIMATION.oldItemCooldown);
        }

        public static boolean oldItemReequip() {
            return ModConfig.getBoolTweak(AnimationTweak.REEQUIP, ModConfig.ANIMATION.oldItemReequip);
        }

        public static boolean oldGhastCharging() {
            return ModConfig.getBoolTweak(AnimationTweak.GHAST_CHARGING, ModConfig.ANIMATION.oldGhastCharging);
        }

        public static boolean oldSkeletonArms() {
            return ModConfig.getBoolTweak(AnimationTweak.SKELETON_ARMS, ModConfig.ANIMATION.oldSkeletonArms);
        }

        public static boolean oldZombieArms() {
            return ModConfig.getBoolTweak(AnimationTweak.ZOMBIE_ARMS, ModConfig.ANIMATION.oldZombieArms);
        }

        public static boolean disablePlayerTopple() {
            return ModConfig.getBoolTweak(AnimationTweak.DEATH_TOPPLE, ModConfig.ANIMATION.disableDeathTopple);
        }

        public static boolean oldBackwardsWalking() {
            return ModConfig.getBoolTweak(AnimationTweak.BACKWARD_WALK, ModConfig.ANIMATION.oldBackwardWalking);
        }

        public static boolean oldVerticalBobbing() {
            return ModConfig.getBoolTweak(AnimationTweak.BOB_VERTICAL, ModConfig.ANIMATION.oldVerticalBobbing);
        }

        public static boolean oldCollideBobbing() {
            return ModConfig.getBoolTweak(AnimationTweak.COLLIDE_BOB, ModConfig.ANIMATION.oldCollideBobbing);
        }

        public static boolean oldCreativeCrouch() {
            return ModConfig.getSidedBoolTweak(AnimationTweak.CREATIVE_CROUCH, ModConfig.ANIMATION.oldCreativeCrouch, ModConfig.SERVER_ANIMATION.oldCreativeCrouch);
        }

        public static boolean oldDirectionTilt() {
            return ModConfig.getSidedBoolTweak(AnimationTweak.DIRECTIONAL_DAMAGE, ModConfig.ANIMATION.oldDirectionalDamage, ModConfig.SERVER_ANIMATION.oldDirectionalDamage);
        }

        public static boolean oldRandomTilt() {
            return ModConfig.getBoolTweak(AnimationTweak.RANDOM_DAMAGE, ModConfig.ANIMATION.oldRandomDamage);
        }

        public static boolean oldSneaking() {
            return ModConfig.getBoolTweak(AnimationTweak.SNEAK_SMOOTH, ModConfig.ANIMATION.oldSneaking);
        }

        public static float getSneakHeight() {
            return 1.41f;
        }
    }

    public static class Gameplay {
        public static int instantBowSpeed() {
            return ModConfig.isTweakOn(GameplayTweak.ARROW_SPEED) ? ModConfig.getSidedTweak(GameplayTweak.ARROW_SPEED, ModConfig.GAMEPLAY.arrowSpeed, ModConfig.SERVER_GAMEPLAY.arrowSpeed) : 0;
        }

        public static boolean disableCriticalHit() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.DISABLE_CRITICAL_HIT, ModConfig.GAMEPLAY.disableCriticalHit, ModConfig.SERVER_GAMEPLAY.disableCriticalHit);
        }

        public static boolean oldDamageValues() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.DAMAGE_VALUES, ModConfig.GAMEPLAY.oldDamageValues, ModConfig.SERVER_GAMEPLAY.oldDamageValues);
        }

        public static boolean disableMissTime() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.DISABLE_MISS_TIMER, ModConfig.GAMEPLAY.disableMissTimer, ModConfig.SERVER_GAMEPLAY.disableMissTimer);
        }

        public static boolean disableCooldown() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.DISABLE_COOLDOWN, ModConfig.GAMEPLAY.disableCooldown, ModConfig.SERVER_GAMEPLAY.disableCooldown);
        }

        public static boolean invincibleBow() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.INVINCIBLE_BOW, ModConfig.GAMEPLAY.invincibleBow, ModConfig.SERVER_GAMEPLAY.invincibleBow);
        }

        public static boolean disableSweep() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.DISABLE_SWEEP, ModConfig.GAMEPLAY.disableSweep, ModConfig.SERVER_GAMEPLAY.disableSweep);
        }

        public static boolean instantBow() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.INSTANT_BOW, ModConfig.GAMEPLAY.instantBow, ModConfig.SERVER_GAMEPLAY.instantBow);
        }

        public static boolean oldLadderGap() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.LADDER_GAP, ModConfig.GAMEPLAY.oldLadderGap, ModConfig.SERVER_GAMEPLAY.oldLadderGap);
        }

        public static boolean oldSquidMilk() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.SQUID_MILK, ModConfig.GAMEPLAY.oldSquidMilking, ModConfig.SERVER_GAMEPLAY.oldSquidMilking);
        }

        public static int getMonsterSpawnCap() {
            return ModConfig.isTweakOn(GameplayTweak.MONSTER_CAP) ? ModConfig.getSidedTweak(GameplayTweak.MONSTER_CAP, ModConfig.GAMEPLAY.monsterSpawnCap, ModConfig.SERVER_GAMEPLAY.monsterSpawnCap).intValue() : MobCategory.MONSTER.m_21608_();
        }

        public static int getAnimalSpawnCap() {
            return ModConfig.isTweakOn(GameplayTweak.ANIMAL_CAP) ? ModConfig.getSidedTweak(GameplayTweak.ANIMAL_CAP, ModConfig.GAMEPLAY.animalSpawnCap, ModConfig.SERVER_GAMEPLAY.animalSpawnCap).intValue() : MobCategory.CREATURE.m_21608_();
        }

        public static boolean disableSheepEatGrass() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.SHEEP_EAT_GRASS, ModConfig.GAMEPLAY.disableSheepEatGrass, ModConfig.SERVER_GAMEPLAY.disableSheepEatGrass);
        }

        public static boolean disableAnimalPanic() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.ANIMAL_PANIC, ModConfig.GAMEPLAY.disableAnimalPanic, ModConfig.SERVER_GAMEPLAY.disableAnimalPanic);
        }

        public static boolean oldAnimalSpawning() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.ANIMAL_SPAWNING, ModConfig.GAMEPLAY.oldAnimalSpawning, ModConfig.SERVER_GAMEPLAY.oldAnimalSpawning);
        }

        public static boolean oldSheepPunching() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.SHEEP_PUNCHING, ModConfig.GAMEPLAY.oldSheepPunching, ModConfig.SERVER_GAMEPLAY.oldSheepPunching);
        }

        public static boolean oneWoolPunch() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.ONE_WOOL_PUNCH, ModConfig.GAMEPLAY.oneWoolPunch, ModConfig.SERVER_GAMEPLAY.oneWoolPunch);
        }

        public static boolean oldZombiePigmenDrops() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.ZOMBIE_PIGMEN_DROPS, ModConfig.GAMEPLAY.oldZombiePigmenDrops, ModConfig.SERVER_GAMEPLAY.oldZombiePigmenDrops);
        }

        public static boolean oldSkeletonDrops() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.SKELETON_DROPS, ModConfig.GAMEPLAY.oldSkeletonDrops, ModConfig.SERVER_GAMEPLAY.oldSkeletonDrops);
        }

        public static boolean oldChickenDrops() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.CHICKEN_DROPS, ModConfig.GAMEPLAY.oldChickenDrops, ModConfig.SERVER_GAMEPLAY.oldChickenDrops);
        }

        public static boolean oldZombieDrops() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.ZOMBIE_DROPS, ModConfig.GAMEPLAY.oldZombieDrops, ModConfig.SERVER_GAMEPLAY.oldZombieDrops);
        }

        public static boolean oldSpiderDrops() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.SPIDER_DROPS, ModConfig.GAMEPLAY.oldSpiderDrops, ModConfig.SERVER_GAMEPLAY.oldSpiderDrops);
        }

        public static boolean oldSheepDrops() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.SHEEP_DROPS, ModConfig.GAMEPLAY.oldSheepDrops, ModConfig.SERVER_GAMEPLAY.oldSheepDrops);
        }

        public static boolean oldCowDrops() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.COW_DROPS, ModConfig.GAMEPLAY.oldCowDrops, ModConfig.SERVER_GAMEPLAY.oldCowDrops);
        }

        public static boolean oldPigDrops() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.PIG_DROPS, ModConfig.GAMEPLAY.oldPigDrops, ModConfig.SERVER_GAMEPLAY.oldPigDrops);
        }

        public static boolean oldZombieVillagerDrops() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.ZOMBIE_VILLAGER_DROPS, ModConfig.GAMEPLAY.oldStyleZombieVillagerDrops, ModConfig.SERVER_GAMEPLAY.oldStyleZombieVillagerDrops);
        }

        public static boolean oldCaveSpiderDrops() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.CAVE_SPIDER_DROPS, ModConfig.GAMEPLAY.oldStyleCaveSpiderDrops, ModConfig.SERVER_GAMEPLAY.oldStyleCaveSpiderDrops);
        }

        public static boolean oldMooshroomDrops() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.MOOSHROOM_DROPS, ModConfig.GAMEPLAY.oldStyleMooshroomDrops, ModConfig.SERVER_GAMEPLAY.oldStyleMooshroomDrops);
        }

        public static boolean oldDrownedDrops() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.DROWNED_DROPS, ModConfig.GAMEPLAY.oldStyleDrownedDrops, ModConfig.SERVER_GAMEPLAY.oldStyleDrownedDrops);
        }

        public static boolean oldRabbitDrops() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.RABBIT_DROPS, ModConfig.GAMEPLAY.oldStyleRabbitDrops, ModConfig.SERVER_GAMEPLAY.oldStyleRabbitDrops);
        }

        public static boolean oldStrayDrops() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.STRAY_DROPS, ModConfig.GAMEPLAY.oldStyleStrayDrops, ModConfig.SERVER_GAMEPLAY.oldStyleStrayDrops);
        }

        public static boolean oldHuskDrops() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.HUSK_DROPS, ModConfig.GAMEPLAY.oldStyleHuskDrops, ModConfig.SERVER_GAMEPLAY.oldStyleHuskDrops);
        }

        public static TweakType.Corner alternativeProgressCorner() {
            return ModConfig.getEnum(GameplayTweak.XP_PROGRESS_CORNER, ModConfig.GAMEPLAY.altXpProgressCorner);
        }

        public static TweakType.Corner alternativeLevelCorner() {
            return ModConfig.getEnum(GameplayTweak.XP_LEVEL_CORNER, ModConfig.GAMEPLAY.altXpLevelCorner);
        }

        public static boolean displayAlternativeLevelCreative() {
            return ModConfig.getBoolTweak(GameplayTweak.SHOW_XP_LEVEL_CREATIVE, ModConfig.GAMEPLAY.showXpLevelInCreative);
        }

        public static boolean displayAlternativeProgressCreative() {
            return ModConfig.getBoolTweak(GameplayTweak.SHOW_XP_PROGRESS_CREATIVE, ModConfig.GAMEPLAY.showXpProgressInCreative);
        }

        public static boolean displayAlternativeProgressText() {
            return ModConfig.getBoolTweak(GameplayTweak.SHOW_XP_PROGRESS, ModConfig.GAMEPLAY.showXpProgressText);
        }

        public static boolean displayAlternativeLevelText() {
            return ModConfig.getBoolTweak(GameplayTweak.SHOW_XP_LEVEL, ModConfig.GAMEPLAY.showXpLevelText);
        }

        public static boolean useDynamicProgressColor() {
            return ModConfig.getBoolTweak(GameplayTweak.USE_DYNAMIC_PROGRESS_COLOR, ModConfig.GAMEPLAY.useDynamicProgressColor);
        }

        public static boolean disableExperienceBar() {
            return ModConfig.getBoolTweak(GameplayTweak.DISABLE_EXP_BAR, ModConfig.GAMEPLAY.disableExperienceBar);
        }

        public static boolean disableOrbRendering() {
            return ModConfig.getBoolTweak(GameplayTweak.ORB_RENDERING, ModConfig.GAMEPLAY.disableOrbRendering);
        }

        public static boolean disableEnchantTable() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.ENCHANT_TABLE, ModConfig.GAMEPLAY.disableEnchantTable, ModConfig.SERVER_GAMEPLAY.disableEnchantTable);
        }

        public static boolean disableOrbSpawn() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.ORB_SPAWN, ModConfig.GAMEPLAY.disableOrbSpawn, ModConfig.SERVER_GAMEPLAY.disableOrbSpawn);
        }

        public static boolean disableAnvil() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.ANVIL, ModConfig.GAMEPLAY.disableAnvil, ModConfig.SERVER_GAMEPLAY.disableAnvil);
        }

        public static boolean cartBoosting() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.CART_BOOSTING, ModConfig.GAMEPLAY.cartBoosting, ModConfig.SERVER_GAMEPLAY.cartBoosting);
        }

        public static boolean disableBedBounce() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.BED_BOUNCE, ModConfig.GAMEPLAY.disableBedBounce, ModConfig.SERVER_GAMEPLAY.disableBedBounce);
        }

        public static boolean tilledGrassSeeds() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.TILLED_GRASS_SEEDS, ModConfig.GAMEPLAY.tilledGrassSeeds, ModConfig.SERVER_GAMEPLAY.tilledGrassSeeds);
        }

        public static boolean instantBonemeal() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.INSTANT_BONE_MEAL, ModConfig.GAMEPLAY.instantBonemeal, ModConfig.SERVER_GAMEPLAY.instantBonemeal);
        }

        public static boolean leftClickButton() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.LEFT_CLICK_BUTTON, ModConfig.GAMEPLAY.leftClickButton, ModConfig.SERVER_GAMEPLAY.leftClickButton);
        }

        public static boolean leftClickLever() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.LEFT_CLICK_LEVER, ModConfig.GAMEPLAY.leftClickLever, ModConfig.SERVER_GAMEPLAY.leftClickLever);
        }

        public static boolean leftClickDoor() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.LEFT_CLICK_DOOR, ModConfig.GAMEPLAY.leftClickDoor, ModConfig.SERVER_GAMEPLAY.leftClickDoor);
        }

        public static boolean disableSprint() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.SPRINT, ModConfig.GAMEPLAY.disableSprint, ModConfig.SERVER_GAMEPLAY.disableSprint);
        }

        public static boolean infiniteBurn() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.INFINITE_BURN, ModConfig.GAMEPLAY.infiniteBurn, ModConfig.SERVER_GAMEPLAY.infiniteBurn);
        }

        public static boolean disableSwim() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.SWIM, ModConfig.GAMEPLAY.disableSwim, ModConfig.SERVER_GAMEPLAY.disableSwim);
        }

        public static boolean instantAir() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.INSTANT_AIR, ModConfig.GAMEPLAY.instantAir, ModConfig.SERVER_GAMEPLAY.instantAir);
        }

        public static boolean oldFire() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.FIRE_SPREAD, ModConfig.GAMEPLAY.oldFire, ModConfig.SERVER_GAMEPLAY.oldFire);
        }

        public static TweakType.Corner alternativeSaturationCorner() {
            return ModConfig.getEnum(GameplayTweak.HUNGER_SATURATION_CORNER, ModConfig.GAMEPLAY.altHungerSaturationCorner);
        }

        public static TweakType.Corner alternativeFoodCorner() {
            return ModConfig.getEnum(GameplayTweak.HUNGER_FOOD_CORNER, ModConfig.GAMEPLAY.altHungerFoodCorner);
        }

        public static boolean displayAlternativeSatText() {
            return ModConfig.getBoolTweak(GameplayTweak.SHOW_HUNGER_SATURATION, ModConfig.GAMEPLAY.showHungerSaturationText);
        }

        public static boolean displayAlternativeFoodText() {
            return ModConfig.getBoolTweak(GameplayTweak.SHOW_HUNGER_FOOD, ModConfig.GAMEPLAY.showHungerFoodText);
        }

        public static boolean useDynamicFoodColor() {
            return ModConfig.getBoolTweak(GameplayTweak.USE_DYNAMIC_FOOD_COLOR, ModConfig.GAMEPLAY.useDynamicFoodColor);
        }

        public static boolean useDynamicSatColor() {
            return ModConfig.getBoolTweak(GameplayTweak.USE_DYNAMIC_SATURATION_COLOR, ModConfig.GAMEPLAY.useDynamicSaturationColor);
        }

        public static boolean disableHungerBar() {
            return ModConfig.getBoolTweak(GameplayTweak.DISABLE_HUNGER_BAR, ModConfig.GAMEPLAY.disableHungerBar);
        }

        public static boolean oldFoodStacking() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.FOOD_STACKING, ModConfig.GAMEPLAY.oldFoodStacking, ModConfig.SERVER_GAMEPLAY.oldFoodStacking);
        }

        public static boolean disableHunger() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.HUNGER, ModConfig.GAMEPLAY.disableHunger, ModConfig.SERVER_GAMEPLAY.disableHunger);
        }

        public static boolean instantEat() {
            return ModConfig.getSidedBoolTweak(GameplayTweak.INSTANT_EAT, ModConfig.GAMEPLAY.instantEat, ModConfig.SERVER_GAMEPLAY.instantEat);
        }

        public static ListMap<Integer> getFoodHealth() {
            return ModConfig.getListMap(GameplayTweak.CUSTOM_FOOD_HEALTH);
        }

        public static ListMap<Integer> getFoodStacking() {
            return ModConfig.getListMap(GameplayTweak.CUSTOM_FOOD_STACKING);
        }

        public static ListMap<Integer> getItemStacking() {
            return ModConfig.getListMap(GameplayTweak.CUSTOM_ITEM_STACKING);
        }

        public static String getAlternativeSaturationText(String saturation) {
            return ModConfig.parseColor(ModConfig.GAMEPLAY.altHungerSaturationText, saturation);
        }

        public static String getAlternativeProgressText(String progress) {
            return ModConfig.parseColor(ModConfig.GAMEPLAY.altXpProgressText, progress);
        }

        public static String getAlternativeLevelText(String level) {
            return ModConfig.parseColor(ModConfig.GAMEPLAY.altXpLevelText, level);
        }

        public static String getAlternativeFoodText(String food) {
            return ModConfig.parseColor(ModConfig.GAMEPLAY.altHungerFoodText, food);
        }
    }

    public static class Candy {
        private static final String MINECRAFT_VERSION = SharedConstants.m_183709_().getName();

        public static TweakVersion.MissingTexture oldMissingTexture() {
            return ModConfig.getEnum(CandyTweak.OLD_MISSING_TEXTURE, ModConfig.CANDY.oldMissingTexture);
        }

        public static boolean fixAmbientOcclusion() {
            return ModConfig.getBoolTweak(CandyTweak.FIX_AO, ModConfig.CANDY.fixAmbientOcclusion);
        }

        public static boolean disableFlowerOffset() {
            return ModConfig.getBoolTweak(CandyTweak.DISABLE_FLOWER_OFFSET, ModConfig.CANDY.disableFlowerOffset);
        }

        public static boolean disableAllOffset() {
            return ModConfig.getBoolTweak(CandyTweak.DISABLE_ALL_OFFSET, ModConfig.CANDY.disableAllOffset);
        }

        public static boolean oldTrappedChest() {
            return ModConfig.getBoolTweak(CandyTweak.TRAPPED_CHEST, ModConfig.CANDY.oldTrappedChest);
        }

        public static boolean oldEnderChest() {
            return ModConfig.getBoolTweak(CandyTweak.ENDER_CHEST, ModConfig.CANDY.oldEnderChest);
        }

        public static boolean oldChestVoxel() {
            return ModConfig.getSidedBoolTweak(CandyTweak.CHEST_VOXEL, ModConfig.CANDY.oldChestVoxel, ModConfig.SERVER_CANDY.oldChestVoxel);
        }

        public static boolean oldChest() {
            return ModConfig.getBoolTweak(CandyTweak.CHEST, ModConfig.CANDY.oldChest);
        }

        private static boolean getModelState(Tweak tweak, boolean client) {
            return !ModTracker.SODIUM.isInstalled() && ModConfig.getBoolTweak(tweak, client);
        }

        public static boolean oldTorchBrightness() {
            return ModConfig.getBoolTweak(CandyTweak.TORCH_BRIGHTNESS, ModConfig.CANDY.oldTorchBrightness);
        }

        public static boolean oldRedstoneTorchModel() {
            return Candy.getModelState(CandyTweak.REDSTONE_TORCH_MODEL, ModConfig.CANDY.oldRedstoneTorchModel);
        }

        public static boolean oldSoulTorchModel() {
            return Candy.getModelState(CandyTweak.SOUL_TORCH_MODEL, ModConfig.CANDY.oldSoulTorchModel);
        }

        public static boolean oldTorchModel() {
            return Candy.getModelState(CandyTweak.TORCH_MODEL, ModConfig.CANDY.oldTorchModel);
        }

        public static boolean oldStairOutline() {
            return ModConfig.getBoolTweak(CandyTweak.OLD_STAIR_OUTLINE, ModConfig.CANDY.oldStairOutline);
        }

        public static boolean oldFenceOutline() {
            return ModConfig.getBoolTweak(CandyTweak.OLD_FENCE_OUTLINE, ModConfig.CANDY.oldFenceOutline);
        }

        public static boolean oldSlabOutline() {
            return ModConfig.getBoolTweak(CandyTweak.OLD_SLAB_OUTLINE, ModConfig.CANDY.oldSlabOutline);
        }

        public static boolean oldWallOutline() {
            return ModConfig.getBoolTweak(CandyTweak.OLD_WALL_OUTLINE, ModConfig.CANDY.oldWallOutline);
        }

        public static ListSet getFullOutlines() {
            return ModConfig.getListSet(CandyTweak.FULL_BLOCK_OUTLINE);
        }

        public static TweakType.Corner oldOverlayCorner() {
            return ModConfig.getEnum(CandyTweak.VERSION_CORNER, ModConfig.CANDY.oldOverlayCorner);
        }

        public static boolean oldPlainSelectedItemName() {
            return ModConfig.getBoolTweak(CandyTweak.PLAIN_SELECTED_ITEM_NAME, ModConfig.CANDY.oldPlainSelectedItemName);
        }

        public static boolean oldNoSelectedItemName() {
            return ModConfig.getBoolTweak(CandyTweak.NO_SELECTED_ITEM_NAME, ModConfig.CANDY.oldNoSelectedItemName);
        }

        public static boolean oldDurabilityColors() {
            return ModConfig.getBoolTweak(CandyTweak.DURABILITY_COLORS, ModConfig.CANDY.oldDurabilityColors);
        }

        public static boolean includeModsOnPause() {
            return ModConfig.getBoolTweak(CandyTweak.PAUSE_MODS, ModConfig.CANDY.includeModsOnPause);
        }

        public static boolean oldVersionOverlay() {
            return ModConfig.getBoolTweak(CandyTweak.VERSION_OVERLAY, ModConfig.CANDY.oldVersionOverlay);
        }

        public static boolean oldLoadingScreens() {
            return ModConfig.getBoolTweak(CandyTweak.LOADING_SCREENS, ModConfig.CANDY.oldLoadingScreens);
        }

        public static boolean removeLoadingBar() {
            return ModConfig.getBoolTweak(CandyTweak.REMOVE_LOADING_BAR, ModConfig.CANDY.removeLoadingBar);
        }

        public static boolean oldButtonHover() {
            return ModConfig.getBoolTweak(CandyTweak.BUTTON_HOVER, ModConfig.CANDY.oldButtonHover);
        }

        public static int getChatOffset() {
            return ModConfig.CANDY.chatOffset;
        }

        public static boolean disableSignatureBoxes() {
            return ModConfig.getBoolTweak(CandyTweak.SIGNATURE_BOXES, ModConfig.CANDY.disableSignatureBoxes);
        }

        public static boolean oldChatInput() {
            return ModConfig.getBoolTweak(CandyTweak.CHAT_INPUT, ModConfig.CANDY.oldChatInput);
        }

        public static boolean oldChatBox() {
            return ModConfig.getBoolTweak(CandyTweak.CHAT_BOX, ModConfig.CANDY.oldChatBox);
        }

        public static String getWindowTitle() {
            return ModConfig.CANDY.windowTitleText.replaceAll("%v", MINECRAFT_VERSION);
        }

        public static boolean enableWindowTitle() {
            return ModConfig.getBoolTweak(CandyTweak.ENABLE_WINDOW_TITLE, ModConfig.CANDY.enableWindowTitle);
        }

        public static boolean matchVersionOverlay() {
            return ModConfig.getBoolTweak(CandyTweak.MATCH_VERSION_OVERLAY, ModConfig.CANDY.matchVersionOverlay);
        }

        public static TweakType.InventoryShield getInventoryShield() {
            return ModConfig.getEnum(CandyTweak.INVENTORY_SHIELD, ModConfig.CANDY.inventoryShield);
        }

        public static TweakType.GuiBackground oldGuiBackground() {
            return ModConfig.getEnum(CandyTweak.OLD_GUI_BACKGROUND, ModConfig.CANDY.oldGuiBackground);
        }

        public static TweakType.RecipeBook getInventoryBook() {
            return ModConfig.getEnum(CandyTweak.INVENTORY_BOOK, ModConfig.CANDY.inventoryBook);
        }

        public static TweakType.RecipeBook getCraftingBook() {
            return ModConfig.getEnum(CandyTweak.CRAFTING_RECIPE, ModConfig.CANDY.craftingBook);
        }

        public static TweakType.RecipeBook getFurnaceBook() {
            return ModConfig.getEnum(CandyTweak.FURNACE_RECIPE, ModConfig.CANDY.furnaceBook);
        }

        public static TweakType.DebugChart getDebugChart() {
            return ModConfig.getEnum(CandyTweak.DEBUG_FPS_CHART, ModConfig.CANDY.fpsChart);
        }

        public static String customTopGradient() {
            return ModConfig.CANDY.customTopGradient;
        }

        public static String customBottomGradient() {
            return ModConfig.CANDY.customBottomGradient;
        }

        public static String debugBackgroundColor() {
            return ModConfig.CANDY.debugBackgroundColor;
        }

        public static boolean removeExtraPauseButtons() {
            return ModConfig.getBoolTweak(CandyTweak.PAUSE_REMOVE_EXTRA, ModConfig.CANDY.removeExtraPauseButtons);
        }

        public static boolean showDebugTextShadow() {
            return ModConfig.getBoolTweak(CandyTweak.DEBUG_SHOW_SHADOW, ModConfig.CANDY.showDebugTextShadow);
        }

        public static boolean showDebugBackground() {
            return ModConfig.getBoolTweak(CandyTweak.DEBUG_SHOW_COLOR, ModConfig.CANDY.showDebugBackground);
        }

        public static boolean showDebugTargetData() {
            return ModConfig.getBoolTweak(CandyTweak.DEBUG_TARGETED, ModConfig.CANDY.showDebugTargetData);
        }

        public static boolean showDebugFacingData() {
            return ModConfig.getBoolTweak(CandyTweak.DEBUG_FACING, ModConfig.CANDY.showDebugFacingData);
        }

        public static boolean showDebugLightData() {
            return ModConfig.getBoolTweak(CandyTweak.DEBUG_LIGHT, ModConfig.CANDY.showDebugLightData);
        }

        public static boolean showDebugBiomeData() {
            return ModConfig.getBoolTweak(CandyTweak.DEBUG_BIOME, ModConfig.CANDY.showDebugBiomeData);
        }

        public static boolean showDebugGpuUsage() {
            return ModConfig.getBoolTweak(CandyTweak.DEBUG_GPU, ModConfig.CANDY.showDebugGpuUsage);
        }

        public static boolean customGuiBackground() {
            return ModConfig.getBoolTweak(CandyTweak.CUSTOM_GUI_BACKGROUND, ModConfig.CANDY.customGuiBackground);
        }

        public static boolean disableEmptyShield() {
            return ModConfig.getBoolTweak(CandyTweak.DISABLE_EMPTY_SHIELD, ModConfig.CANDY.disableEmptyShieldTexture);
        }

        public static boolean disableEmptyArmor() {
            return ModConfig.getBoolTweak(CandyTweak.DISABLE_EMPTY_ARMOR, ModConfig.CANDY.disableEmptyArmorTexture);
        }

        public static boolean invertPlayerLight() {
            return ModConfig.getBoolTweak(CandyTweak.INVERTED_PLAYER_LIGHTING, ModConfig.CANDY.invertedPlayerLighting);
        }

        public static boolean oldCraftingScreen() {
            return ModConfig.getBoolTweak(CandyTweak.CRAFTING_SCREEN, ModConfig.CANDY.oldCraftingScreen);
        }

        public static boolean invertBlockLight() {
            return ModConfig.getBoolTweak(CandyTweak.INVERTED_BLOCK_LIGHTING, ModConfig.CANDY.invertedBlockLighting);
        }

        public static boolean oldPieBackground() {
            return ModConfig.getBoolTweak(CandyTweak.OLD_PIE_BACKGROUND, ModConfig.CANDY.oldPieChartBackground);
        }

        public static boolean oldFurnaceScreen() {
            return ModConfig.getBoolTweak(CandyTweak.FURNACE_SCREEN, ModConfig.CANDY.oldFurnaceScreen);
        }

        public static boolean displayPieChart() {
            return ModConfig.getBoolTweak(CandyTweak.DEBUG_PIE_CHART, ModConfig.CANDY.showDebugPieChart);
        }

        public static boolean displayTpsChart() {
            return ModConfig.getBoolTweak(CandyTweak.DEBUG_TPS_CHART, ModConfig.CANDY.showDebugTpsChart);
        }

        public static boolean oldAnvilScreen() {
            return ModConfig.getBoolTweak(CandyTweak.ANVIL_SCREEN, ModConfig.CANDY.oldAnvilScreen);
        }

        public static boolean debugEntityId() {
            return ModConfig.getSidedBoolTweak(CandyTweak.DEBUG_ENTITY_ID, ModConfig.CANDY.debugEntityId, ModConfig.SERVER_CANDY.debugEntityId);
        }

        public static boolean oldInventory() {
            return ModConfig.getBoolTweak(CandyTweak.OLD_INVENTORY, ModConfig.CANDY.oldInventory);
        }

        public static boolean addDyeTip() {
            return ModConfig.getBoolTweak(CandyTweak.DYE_TIP, ModConfig.CANDY.showDyeTip);
        }

        public static boolean oldTooltips() {
            return ModConfig.getBoolTweak(CandyTweak.TOOLTIP_BOXES, ModConfig.CANDY.oldTooltipBoxes);
        }

        public static boolean addModifiersTip() {
            return ModConfig.getBoolTweak(CandyTweak.MODIFIERS_TIP, ModConfig.CANDY.showModifiersTip);
        }

        public static boolean addEnchantmentTip() {
            return ModConfig.getBoolTweak(CandyTweak.ENCHANTMENT_TIP, ModConfig.CANDY.showEnchantmentTip);
        }

        public static boolean oldNoItemTooltips() {
            return ModConfig.getBoolTweak(CandyTweak.NO_ITEM_TOOLTIPS, ModConfig.CANDY.oldNoItemTooltips);
        }

        public static boolean fixItemModelGaps() {
            return ModConfig.getBoolTweak(CandyTweak.FIX_ITEM_MODEL_GAP, ModConfig.CANDY.fixItemModelGap);
        }

        public static boolean oldDamageArmorTint() {
            return ModConfig.getBoolTweak(CandyTweak.DAMAGE_ARMOR_TINT, ModConfig.CANDY.oldDamageArmorTint);
        }

        public static boolean oldFlatEnchantment() {
            return ModConfig.getBoolTweak(CandyTweak.FLAT_ENCHANTED_ITEMS, ModConfig.CANDY.old2dEnchantedItems) && Candy.oldFloatingItems();
        }

        public static boolean oldFlatRendering() {
            return ModConfig.getBoolTweak(CandyTweak.FLAT_RENDERING, ModConfig.CANDY.old2dRendering);
        }

        public static boolean oldFloatingItems() {
            return ModConfig.getBoolTweak(CandyTweak.FLAT_ITEMS, ModConfig.CANDY.old2dItems);
        }

        public static boolean oldFlatThrowing() {
            return ModConfig.getBoolTweak(CandyTweak.FLAT_THROW_ITEMS, ModConfig.CANDY.old2dThrownItems);
        }

        public static boolean oldItemHolding() {
            return ModConfig.getBoolTweak(CandyTweak.ITEM_HOLDING, ModConfig.CANDY.oldItemHolding);
        }

        public static boolean oldItemMerging() {
            return ModConfig.getSidedBoolTweak(CandyTweak.ITEM_MERGING, ModConfig.CANDY.oldItemMerging, ModConfig.SERVER_CANDY.oldItemMerging);
        }

        public static boolean oldFlatFrames() {
            return ModConfig.getBoolTweak(CandyTweak.FLAT_FRAMES, ModConfig.CANDY.old2dFrames);
        }

        public static boolean oldFlatColors() {
            return ModConfig.getBoolTweak(CandyTweak.FLAT_COLORS, ModConfig.CANDY.old2dColors);
        }

        public static ListSet getIgnoredItemHoldings() {
            return ModConfig.getListSet(CandyTweak.IGNORED_ITEM_HOLDING);
        }

        public static boolean disableLightFlicker() {
            return ModConfig.getBoolTweak(CandyTweak.LIGHT_FLICKER, ModConfig.CANDY.disableLightFlicker);
        }

        public static boolean disableBrightness() {
            return ModConfig.getBoolTweak(CandyTweak.DISABLE_BRIGHTNESS, ModConfig.CANDY.disableBrightness);
        }

        public static boolean fixChunkBorderLag() {
            return ModConfig.getBoolTweak(CandyTweak.FIX_CHUNK_BORDER_LAG, ModConfig.CANDY.fixChunkBorderLag);
        }

        public static boolean oldLightRendering() {
            return ModConfig.getBoolTweak(CandyTweak.LIGHT_RENDERING, ModConfig.CANDY.oldLightRendering);
        }

        public static boolean oldSmoothLighting() {
            return ModConfig.getBoolTweak(CandyTweak.SMOOTH_LIGHTING, ModConfig.CANDY.oldSmoothLighting);
        }

        public static boolean oldNetherLighting() {
            return ModConfig.getBoolTweak(CandyTweak.NETHER_LIGHTING, ModConfig.CANDY.oldNetherLighting);
        }

        public static boolean oldLeavesLighting() {
            return ModConfig.getBoolTweak(CandyTweak.LEAVES_LIGHTING, ModConfig.CANDY.oldLeavesLighting);
        }

        public static boolean oldWaterLighting() {
            return ModConfig.getBoolTweak(CandyTweak.WATER_LIGHTING, ModConfig.CANDY.oldWaterLighting);
        }

        public static boolean oldClassicLight() {
            return ModConfig.getSidedBoolTweak(CandyTweak.CLASSIC_LIGHTING, ModConfig.CANDY.oldClassicLighting, ModConfig.SERVER_CANDY.oldClassicLighting);
        }

        public static boolean oldLightColor() {
            return ModConfig.getBoolTweak(CandyTweak.LIGHT_COLOR, ModConfig.CANDY.oldLightColor);
        }

        public static boolean disableModelDestructionParticles() {
            return ModConfig.getBoolTweak(CandyTweak.NO_MODEL_DESTRUCTION_PARTICLES, ModConfig.CANDY.disableModelDestructionParticles);
        }

        public static boolean unoptimizedExplosionParticles() {
            return ModConfig.getBoolTweak(CandyTweak.UNOPTIMIZED_EXPLOSION_PARTICLES, ModConfig.CANDY.unoptimizedExplosionParticles);
        }

        public static boolean disableUnderwaterParticles() {
            return ModConfig.getBoolTweak(CandyTweak.NO_UNDERWATER_PARTICLES, ModConfig.CANDY.disableUnderwaterParticles);
        }

        public static boolean oldMixedExplosionParticles() {
            return ModConfig.getBoolTweak(CandyTweak.MIXED_EXPLOSION_PARTICLES, ModConfig.CANDY.oldMixedExplosionParticles);
        }

        public static boolean oldNoCriticalHitParticles() {
            return ModConfig.getBoolTweak(CandyTweak.NO_CRIT_PARTICLES, ModConfig.CANDY.oldNoCritParticles);
        }

        public static boolean disableSprintingParticles() {
            return ModConfig.getBoolTweak(CandyTweak.NO_SPRINTING_PARTICLES, ModConfig.CANDY.disableSprintingParticles);
        }

        public static boolean oldNoEnchantHitParticles() {
            return ModConfig.getBoolTweak(CandyTweak.NO_MAGIC_HIT_PARTICLES, ModConfig.CANDY.oldNoMagicHitParticles);
        }

        public static boolean disableFallingParticles() {
            return ModConfig.getBoolTweak(CandyTweak.NO_FALLING_PARTICLES, ModConfig.CANDY.disableFallingParticles);
        }

        public static boolean disableGrowthParticles() {
            return ModConfig.getBoolTweak(CandyTweak.NO_GROWTH_PARTICLES, ModConfig.CANDY.disableGrowthParticles);
        }

        public static boolean disableNetherParticles() {
            return ModConfig.getBoolTweak(CandyTweak.NO_NETHER_PARTICLES, ModConfig.CANDY.disableNetherParticles);
        }

        public static boolean disableLeverParticles() {
            return ModConfig.getBoolTweak(CandyTweak.NO_LEVER_PARTICLES, ModConfig.CANDY.disableLeverParticles);
        }

        public static boolean oldExplosionParticles() {
            return ModConfig.getBoolTweak(CandyTweak.EXPLOSION_PARTICLES, ModConfig.CANDY.oldExplosionParticles);
        }

        public static boolean disableLavaParticles() {
            return ModConfig.getBoolTweak(CandyTweak.NO_LAVA_PARTICLES, ModConfig.CANDY.disableLavaParticles);
        }

        public static boolean oldNoDamageParticles() {
            return ModConfig.getBoolTweak(CandyTweak.NO_DAMAGE_PARTICLES, ModConfig.CANDY.oldNoDamageParticles);
        }

        public static boolean oldOpaqueExperience() {
            return ModConfig.getBoolTweak(CandyTweak.OPAQUE_EXPERIENCE, ModConfig.CANDY.oldOpaqueExperience);
        }

        public static boolean oldSweepParticles() {
            return ModConfig.getBoolTweak(CandyTweak.SWEEP, ModConfig.CANDY.oldSweepParticles);
        }

        public static boolean includeModsOnTitle() {
            return ModConfig.getBoolTweak(CandyTweak.TITLE_MODS_BUTTON, ModConfig.CANDY.includeModsOnTitle);
        }

        public static boolean overrideTitleScreen() {
            return ModConfig.getBoolTweak(CandyTweak.OVERRIDE_TITLE_SCREEN, ModConfig.CANDY.overrideTitleScreen);
        }

        public static boolean removeAccessibilityButton() {
            return ModConfig.getBoolTweak(CandyTweak.TITLE_ACCESSIBILITY, ModConfig.CANDY.removeTitleAccessibilityButton);
        }

        public static boolean removeTitleModLoaderText() {
            return ModConfig.getBoolTweak(CandyTweak.TITLE_MOD_LOADER_TEXT, ModConfig.CANDY.removeTitleModLoaderText);
        }

        public static boolean removeLanguageButton() {
            return ModConfig.getBoolTweak(CandyTweak.TITLE_LANGUAGE, ModConfig.CANDY.removeTitleLanguageButton);
        }

        public static boolean removeRealmsButton() {
            return ModConfig.getBoolTweak(CandyTweak.TITLE_REALMS, ModConfig.CANDY.removeTitleRealmsButton);
        }

        public static boolean titleBottomLeftText() {
            return ModConfig.getBoolTweak(CandyTweak.TITLE_BOTTOM_LEFT_TEXT, ModConfig.CANDY.titleBottomLeftText);
        }

        public static boolean oldTitleBackground() {
            return ModConfig.getBoolTweak(CandyTweak.TITLE_BACKGROUND, ModConfig.CANDY.oldTitleBackground);
        }

        public static boolean oldLogoOutline() {
            return ModConfig.getBoolTweak(CandyTweak.LOGO_OUTLINE, ModConfig.CANDY.oldLogoOutline);
        }

        public static boolean oldAlphaLogo() {
            return ModConfig.getBoolTweak(CandyTweak.ALPHA_LOGO, ModConfig.CANDY.oldAlphaLogo);
        }

        public static boolean uncapTitleFPS() {
            return ModConfig.getBoolTweak(CandyTweak.UNCAP_TITLE_FPS, ModConfig.CANDY.uncapTitleFPS);
        }

        public static boolean disableSunriseSunsetColor() {
            return ModConfig.getBoolTweak(CandyTweak.DISABLE_SUNRISE_SUNSET_COLOR, ModConfig.CANDY.disableSunriseSunsetColors);
        }

        public static boolean oldSunriseSunsetFog() {
            return ModConfig.getBoolTweak(CandyTweak.SUNRISE_SUNSET_FOG, ModConfig.CANDY.oldSunriseSunsetFog);
        }

        public static boolean oldBlueVoidOverride() {
            return ModConfig.getBoolTweak(CandyTweak.BLUE_VOID_OVERRIDE, ModConfig.CANDY.oldBlueVoidOverride);
        }

        public static boolean oldDynamicSkyColor() {
            return ModConfig.getBoolTweak(CandyTweak.DYNAMIC_SKY_COLOR, ModConfig.CANDY.oldDynamicSkyColor);
        }

        public static boolean oldDynamicFogColor() {
            return ModConfig.getBoolTweak(CandyTweak.DYNAMIC_FOG_COLOR, ModConfig.CANDY.oldDynamicFogColor);
        }

        public static boolean smoothWaterDensity() {
            return ModConfig.getBoolTweak(CandyTweak.SMOOTH_WATER_DENSITY, ModConfig.CANDY.smoothWaterDensity);
        }

        public static boolean oldWaterFogDensity() {
            return ModConfig.getBoolTweak(CandyTweak.WATER_FOG_DENSITY, ModConfig.CANDY.oldWaterFogDensity);
        }

        public static boolean oldDarkVoidHeight() {
            return ModConfig.getBoolTweak(CandyTweak.DARK_VOID_HEIGHT, ModConfig.CANDY.oldDarkVoidHeight);
        }

        public static boolean oldSunriseAtNorth() {
            return ModConfig.getBoolTweak(CandyTweak.SUNRISE_AT_NORTH, ModConfig.CANDY.oldSunriseAtNorth);
        }

        public static boolean disableHorizonFog() {
            return ModConfig.getBoolTweak(CandyTweak.DISABLE_HORIZON_FOG, ModConfig.CANDY.disableHorizonFog);
        }

        public static boolean smoothWaterColor() {
            return ModConfig.getBoolTweak(CandyTweak.SMOOTH_WATER_COLOR, ModConfig.CANDY.smoothWaterColor);
        }

        public static boolean oldWaterFogColor() {
            return ModConfig.getBoolTweak(CandyTweak.WATER_FOG_COLOR, ModConfig.CANDY.oldWaterFogColor);
        }

        public static boolean oldSquareBorder() {
            return ModConfig.getSidedBoolTweak(CandyTweak.SQUARE_BORDER, ModConfig.CANDY.oldSquareBorder, ModConfig.SERVER_CANDY.oldSquareBorder);
        }

        public static boolean oldNetherFog() {
            return ModConfig.getBoolTweak(CandyTweak.NETHER_FOG, ModConfig.CANDY.oldNetherFog);
        }

        public static boolean oldNetherSky() {
            return ModConfig.getBoolTweak(CandyTweak.NETHER_SKY, ModConfig.CANDY.oldNetherSky);
        }

        public static boolean oldNameTags() {
            return ModConfig.getBoolTweak(CandyTweak.NAME_TAGS, ModConfig.CANDY.oldNameTags);
        }

        public static boolean oldDarkFog() {
            return ModConfig.getBoolTweak(CandyTweak.DARK_FOG, ModConfig.CANDY.oldDarkFog);
        }

        public static String getTerrainFogColor() {
            return ModConfig.CANDY.customTerrainFogColor;
        }

        public static String getNetherFogColor() {
            return ModConfig.CANDY.customNetherFogColor;
        }

        public static boolean isTerrainFogCustom() {
            return ModConfig.getBoolTweak(CandyTweak.CUSTOM_TERRAIN_FOG, ModConfig.CANDY.customTerrainFog);
        }

        public static boolean isNetherFogCustom() {
            return ModConfig.getBoolTweak(CandyTweak.CUSTOM_NETHER_FOG, ModConfig.CANDY.customNetherFog);
        }

        public static String getWorldSkyColor() {
            return ModConfig.CANDY.customWorldSkyColor;
        }

        public static String getNetherSkyColor() {
            return ModConfig.CANDY.customNetherSkyColor;
        }

        public static boolean isWorldSkyCustom() {
            return ModConfig.getBoolTweak(CandyTweak.CUSTOM_WORLD_SKY, ModConfig.CANDY.customWorldSky);
        }

        public static boolean isNetherSkyCustom() {
            return ModConfig.getBoolTweak(CandyTweak.CUSTOM_NETHER_SKY, ModConfig.CANDY.customNetherSky);
        }

        public static String getVoidSkyColor() {
            return ModConfig.CANDY.customVoidSkyColor;
        }

        public static boolean isVoidSkyCustom() {
            return ModConfig.getBoolTweak(CandyTweak.CUSTOM_VOID_SKY, ModConfig.CANDY.customVoidSky);
        }

        public static String getVoidFogColor() {
            return ModConfig.CANDY.voidFogColor;
        }

        public static boolean disableVoidFog() {
            return ModConfig.getBoolTweak(CandyTweak.DISABLE_VOID_FOG, ModConfig.CANDY.disableVoidFog);
        }

        public static boolean creativeVoidFog() {
            return ModConfig.getBoolTweak(CandyTweak.CREATIVE_VOID_FOG, ModConfig.CANDY.creativeVoidFog);
        }

        public static boolean creativeVoidParticles() {
            return ModConfig.getBoolTweak(CandyTweak.CREATIVE_VOID_PARTICLE, ModConfig.CANDY.creativeVoidParticles);
        }

        public static boolean shouldLightRemoveVoidFog() {
            return ModConfig.getBoolTweak(CandyTweak.LIGHT_REMOVES_VOID_FOG, ModConfig.CANDY.lightRemovesVoidFog);
        }

        public static TweakVersion.WorldFog getWorldFog() {
            return ModConfig.getEnum(CandyTweak.WORLD_FOG, ModConfig.CANDY.oldWorldFog);
        }

        public static TweakVersion.TitleLayout getButtonLayout() {
            return ModConfig.getEnum(CandyTweak.TITLE_BUTTON_LAYOUT, ModConfig.CANDY.oldButtonLayout);
        }

        public static TweakVersion.PauseLayout getPauseLayout() {
            return ModConfig.getEnum(CandyTweak.PAUSE_LAYOUT, ModConfig.CANDY.oldPauseMenu);
        }

        public static TweakVersion.Overlay getLoadingOverlay() {
            return ModConfig.getEnum(CandyTweak.LOADING_OVERLAY, ModConfig.CANDY.oldLoadingOverlay);
        }

        public static TweakVersion.Generic getDebugScreen() {
            return ModConfig.getEnum(CandyTweak.DEBUG_SCREEN, ModConfig.CANDY.oldDebug);
        }

        public static TweakVersion.Generic getBlueVoid() {
            return ModConfig.getEnum(CandyTweak.BLUE_VOID, ModConfig.CANDY.oldBlueVoid);
        }

        public static TweakVersion.Generic getStars() {
            return ModConfig.getEnum(CandyTweak.STARS, ModConfig.CANDY.oldStars);
        }

        public static TweakVersion.Hotbar getHotbar() {
            return ModConfig.getSidedEnum(CandyTweak.CREATIVE_HOTBAR, ModConfig.CANDY.oldCreativeHotbar, ModConfig.SERVER_CANDY.oldCreativeHotbar);
        }

        public static TweakVersion.FogColor getUniversalFog() {
            return ModConfig.getEnum(CandyTweak.UNIVERSAL_FOG_COLOR, ModConfig.CANDY.universalFogColor);
        }

        public static TweakVersion.SkyColor getUniversalSky() {
            return ModConfig.getEnum(CandyTweak.UNIVERSAL_SKY_COLOR, ModConfig.CANDY.universalSkyColor);
        }

        public static String getOverlayText() {
            return ModConfig.parseColor(ModConfig.CANDY.oldOverlayText, MINECRAFT_VERSION);
        }

        public static String getVersionText() {
            return ModConfig.parseColor(ModConfig.CANDY.titleVersionText, MINECRAFT_VERSION);
        }

        public static int getVoidParticleDensity() {
            return ModConfig.isTweakOn(CandyTweak.VOID_PARTICLE_DENSITY) ? ModConfig.CANDY.voidParticleDensity : 20;
        }

        public static int getVoidParticleRadius() {
            return ModConfig.isTweakOn(CandyTweak.VOID_PARTICLE_RADIUS) ? ModConfig.CANDY.voidParticleRadius : 16;
        }

        public static int getVoidParticleStart() {
            return ModConfig.isTweakOn(CandyTweak.VOID_PARTICLE_START) ? ModConfig.CANDY.voidParticleStart + 64 : 17;
        }

        public static int getVoidFogEncroach() {
            return ModConfig.isTweakOn(CandyTweak.VOID_FOG_ENCROACH) ? ModConfig.CANDY.voidFogEncroach : 50;
        }

        public static int getMaxBlockLight() {
            return ModConfig.isTweakOn(CandyTweak.MAX_BLOCK_LIGHT) ? ModConfig.CANDY.maxBlockLight : 15;
        }

        public static int getVoidFogStart() {
            return ModConfig.isTweakOn(CandyTweak.VOID_FOG_START) ? ModConfig.CANDY.voidFogStart + 64 : 114;
        }

        public static int getCloudHeight() {
            return ModConfig.isTweakOn(CandyTweak.CLOUD_HEIGHT) ? ModConfig.CANDY.oldCloudHeight : 192;
        }

        public static int getItemMergeLimit() {
            return ModConfig.isTweakOn(CandyTweak.ITEM_MERGE_LIMIT) ? ModConfig.getSidedTweak(CandyTweak.ITEM_MERGE_LIMIT, ModConfig.CANDY.itemMergeLimit, ModConfig.SERVER_CANDY.itemMergeLimit) : 1;
        }
    }

    public static class Sound {
        public static boolean disableGlowSquidAmbience() {
            return ModConfig.getBoolTweak(SoundTweak.DISABLE_GLOW_SQUID_AMBIENCE, ModConfig.SOUND.disableGlowSquidAmbience);
        }

        public static boolean disableGlowSquidOther() {
            return ModConfig.getBoolTweak(SoundTweak.DISABLE_GLOW_SQUID_OTHER, ModConfig.SOUND.disableGlowSquidOther);
        }

        public static boolean disableNetherAmbience() {
            return ModConfig.getBoolTweak(SoundTweak.DISABLE_NETHER_AMBIENCE, ModConfig.SOUND.disableNetherAmbience);
        }

        public static boolean disableWaterAmbience() {
            return ModConfig.getBoolTweak(SoundTweak.DISABLE_WATER_AMBIENCE, ModConfig.SOUND.disableWaterAmbience);
        }

        public static boolean disableLavaAmbience() {
            return ModConfig.getBoolTweak(SoundTweak.DISABLE_LAVA_AMBIENCE, ModConfig.SOUND.disableLavaAmbience);
        }

        public static boolean disableGenericSwim() {
            return ModConfig.getBoolTweak(SoundTweak.DISABLE_GENERIC_SWIM, ModConfig.SOUND.disableGenericSwim);
        }

        public static boolean ignoreModdedStep() {
            return ModConfig.getBoolTweak(SoundTweak.IGNORE_MODDED_STEP, ModConfig.SOUND.ignoreModdedStep);
        }

        public static boolean disableFishDeath() {
            return ModConfig.getBoolTweak(SoundTweak.DISABLE_FISH_DEATH, ModConfig.SOUND.disableFishDeath);
        }

        public static boolean disableFishSwim() {
            return ModConfig.getBoolTweak(SoundTweak.DISABLE_FISH_SWIM, ModConfig.SOUND.disableFishSwim);
        }

        public static boolean disableFishHurt() {
            return ModConfig.getBoolTweak(SoundTweak.DISABLE_FISH_HURT, ModConfig.SOUND.disableFishHurt);
        }

        public static boolean disableXpPickup() {
            return ModConfig.getBoolTweak(SoundTweak.DISABLE_PICKUP, ModConfig.SOUND.disableXpPickup);
        }

        public static boolean disableFurnace() {
            return ModConfig.getBoolTweak(SoundTweak.DISABLE_FURNACE, ModConfig.SOUND.disableFurnace);
        }

        public static boolean disableXpLevel() {
            return ModConfig.getBoolTweak(SoundTweak.DISABLE_LEVEL, ModConfig.SOUND.disableXpLevel);
        }

        public static boolean disableLavaPop() {
            return ModConfig.getBoolTweak(SoundTweak.DISABLE_LAVA_POP, ModConfig.SOUND.disableLavaPop);
        }

        public static boolean disableGrowth() {
            return ModConfig.getBoolTweak(SoundTweak.DISABLE_GROWTH, ModConfig.SOUND.disableGrowth);
        }

        public static boolean disableChest() {
            return ModConfig.getBoolTweak(SoundTweak.DISABLE_CHEST, ModConfig.SOUND.disableChest);
        }

        public static boolean disableEnderChest() {
            return ModConfig.getBoolTweak(SoundTweak.DISABLE_ENDER_CHEST, ModConfig.SOUND.disableEnderChest);
        }

        public static boolean disableTrappedChest() {
            return ModConfig.getBoolTweak(SoundTweak.DISABLE_TRAPPED_CHEST, ModConfig.SOUND.disableTrappedChest);
        }

        public static boolean disableSquid() {
            return ModConfig.getBoolTweak(SoundTweak.DISABLE_SQUID, ModConfig.SOUND.disableSquid);
        }

        public static boolean disableDoor() {
            return ModConfig.getBoolTweak(SoundTweak.DISABLE_DOOR, ModConfig.SOUND.disableDoorPlace);
        }

        public static boolean disableBed() {
            return ModConfig.getBoolTweak(SoundTweak.DISABLE_BED, ModConfig.SOUND.disableBedPlace);
        }

        public static boolean oldAttack() {
            return ModConfig.getBoolTweak(SoundTweak.OLD_ATTACK, ModConfig.SOUND.oldAttack);
        }

        public static boolean oldDamage() {
            return ModConfig.getBoolTweak(SoundTweak.OLD_HURT, ModConfig.SOUND.oldHurt);
        }

        public static boolean oldChest() {
            return ModConfig.getBoolTweak(SoundTweak.OLD_CHEST, ModConfig.SOUND.oldChest);
        }

        public static boolean oldFall() {
            return ModConfig.getBoolTweak(SoundTweak.OLD_FALL, ModConfig.SOUND.oldFall);
        }

        public static boolean oldStep() {
            return ModConfig.getBoolTweak(SoundTweak.OLD_STEP, ModConfig.SOUND.oldStep);
        }

        public static boolean oldBed() {
            return ModConfig.getBoolTweak(SoundTweak.OLD_BED, ModConfig.SOUND.oldBed);
        }

        public static boolean oldXp() {
            return ModConfig.getBoolTweak(SoundTweak.OLD_XP, ModConfig.SOUND.oldXp);
        }
    }
}

