/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.common.config;

import com.mojang.datafixers.util.Pair;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.config.annotation.TweakGui;
import mod.adrenix.nostalgic.common.config.annotation.TweakData;
import mod.adrenix.nostalgic.common.config.auto.ConfigData;
import mod.adrenix.nostalgic.common.config.list.ValidateList;
import mod.adrenix.nostalgic.util.common.ColorUtil;
import mod.adrenix.nostalgic.util.common.log.LogColor;

public abstract class ValidateConfig {
    private static final Map<String, String> TWEAK_PLACEMENT = new HashMap<String, String>();
    private static final String NO_METADATA = "NO_METADATA";
    private static final String NO_CLASS_DATA = "NO_CLASS_DATA";
    private static final String SKIP_HASH_MAP = "SKIPPED_HASH_MAP";
    private static final String VALIDATE_FIELD = "SHOULD_NOT_APPEAR";
    private static final String LIST_VALIDATED = "LIST_VALIDATED";
    private static final String PASSED_VALIDATION = "PASSED_VALIDATION";

    public static void scan(Object config) throws ConfigData.ValidationException {
        Field[] fields = config.getClass().getFields();
        ValidateConfig.validate(fields, config, TweakData.BoundedSlider.class, ValidateConfig::boundedSliders);
        ValidateConfig.validate(fields, config, TweakData.List.class, ValidateConfig::customLists);
        ValidateConfig.validate(fields, config, TweakData.Color.class, ValidateConfig::colorStrings);
        ValidateConfig.validate(fields, config, TweakGui.Placement.class, ValidateConfig::configPlacement);
        TWEAK_PLACEMENT.clear();
    }

    private static <T extends Annotation> void validate(Field[] fields, Object config, Class<T> annotation, TriFunction<Field, Object, T, Pair<Scan, String>> validator) throws ConfigData.ValidationException {
        NostalgicTweaks.LOGGER.debug("VALIDATING: %s", annotation.getName());
        Pair<Scan, String> result = ValidateConfig.getValidation(fields, config, annotation, validator);
        Scan resultScan = (Scan)((Object)result.getFirst());
        String resultMessage = (String)result.getSecond();
        if (resultScan == Scan.STOP) {
            throw new ConfigData.ValidationException(new Throwable(resultMessage));
        }
        NostalgicTweaks.LOGGER.debug("VALIDATED: %s", annotation.getName());
    }

    private static Pair<Scan, String> boundedSliders(Field field, Object container, TweakData.BoundedSlider slider) throws IllegalAccessException {
        String name = field.getName();
        Object saved = field.get(container);
        if (saved instanceof Map) {
            return new Pair((Object)Scan.CONTINUE, (Object)LogColor.apply(LogColor.LIGHT_PURPLE, SKIP_HASH_MAP));
        }
        long min = slider.min();
        long max = slider.max();
        long reset = slider.reset();
        long value = ((Number)saved).longValue();
        if (reset < min || reset > max) {
            String reason = "[%s %s]: reset is out-of-bounds (min: %s, max: %s, reset: %s)";
            String message = String.format(reason, container.toString(), name, min, max, reset);
            return new Pair((Object)Scan.STOP, (Object)message);
        }
        if (value < min || value > max) {
            String warning = "%s is out-of-bounds (min: %s, max: %s) (had: %s) this tweak has been reset to (%s)";
            String message = String.format(warning, name, min, max, saved, reset);
            NostalgicTweaks.LOGGER.warn(message);
            if (saved instanceof Long) {
                field.set(container, reset);
            } else {
                field.set(container, (int)reset);
            }
            return new Pair((Object)Scan.CONTINUE, (Object)LogColor.apply(LogColor.YELLOW, message));
        }
        return new Pair((Object)Scan.CONTINUE, (Object)LogColor.apply(LogColor.GREEN, PASSED_VALIDATION));
    }

    private static Pair<Scan, String> colorStrings(Field field, Object container, TweakData.Color color) throws IllegalAccessException {
        String name = field.getName();
        String saved = (String)field.get(container);
        String reset = color.reset();
        if (!ColorUtil.isValidHexString(reset)) {
            String reason = "[%s %s]: reset is an invalid hexadecimal (reset: %s)";
            String message = String.format(reason, container.toString(), name, reset);
            return new Pair((Object)Scan.STOP, (Object)message);
        }
        if (ColorUtil.isValidHexString(saved)) {
            return new Pair((Object)Scan.CONTINUE, (Object)LogColor.apply(LogColor.GREEN, PASSED_VALIDATION));
        }
        String warning = "%s is an invalid hexadecimal (had: %s) this tweak has been reset to (%s)";
        String message = String.format(warning, name, saved, reset);
        NostalgicTweaks.LOGGER.warn(message);
        field.set(container, reset);
        return new Pair((Object)Scan.CONTINUE, (Object)LogColor.apply(LogColor.YELLOW, message));
    }

    private static Pair<Scan, String> customLists(Field field, Object container, TweakData.List list) throws IllegalAccessException {
        String fieldId = field.getName();
        if (ValidateList.scan(list.id(), field.get(container))) {
            return new Pair((Object)Scan.CONTINUE, (Object)LogColor.apply(LogColor.GREEN, LIST_VALIDATED));
        }
        String warning = "list (%s) was invalid so it was modified - please see config and backup config";
        String message = String.format(warning, fieldId);
        NostalgicTweaks.LOGGER.warn(message);
        NostalgicTweaks.LOGGER.debug("(%s@%s) has invalid list data", container, fieldId);
        return new Pair((Object)Scan.CONTINUE, (Object)LogColor.apply(LogColor.YELLOW, message));
    }

    private static Pair<Scan, String> configPlacement(Field field, Object container, TweakGui.Placement placement) {
        String fieldId = field.getName();
        TweakGui.Category category = field.getAnnotation(TweakGui.Category.class);
        TweakGui.Subcategory subcategory = field.getAnnotation(TweakGui.Subcategory.class);
        TweakGui.Embed embed = field.getAnnotation(TweakGui.Embed.class);
        if (category == null && subcategory == null && embed == null) {
            return new Pair((Object)Scan.CONTINUE, (Object)LogColor.apply(LogColor.YELLOW, "NO_CONTAINER"));
        }
        if (category != null) {
            return ValidateConfig.scanContainer(category.container(), placement, fieldId);
        }
        if (subcategory != null) {
            return ValidateConfig.scanContainer(subcategory.container(), placement, fieldId);
        }
        return ValidateConfig.scanContainer(embed.container(), placement, fieldId);
    }

    private static Pair<Scan, String> scanContainer(Enum<?> container, TweakGui.Placement placement, String fieldId) {
        String key = String.format("%s@%s#%s", new Object[]{container, placement.pos(), placement.order()});
        if (TWEAK_PLACEMENT.containsKey(key) && !TWEAK_PLACEMENT.containsValue(fieldId)) {
            String holder = TWEAK_PLACEMENT.get(key);
            String warning = "group (%s@%s) already has a tweak (%s) with an order # of %s";
            String message = String.format(warning, new Object[]{container, placement.pos(), holder, placement.order()});
            return new Pair((Object)Scan.STOP, (Object)LogColor.apply(LogColor.RED, message));
        }
        TWEAK_PLACEMENT.put(key, fieldId);
        return new Pair((Object)Scan.CONTINUE, (Object)LogColor.apply(LogColor.GREEN, PASSED_VALIDATION));
    }

    private static <T extends Annotation> Pair<Scan, String> getValidation(Field[] fields, Object container, Class<T> annotation, TriFunction<Field, Object, T, Pair<Scan, String>> validator) {
        if (fields[0] != null && fields[0].getDeclaringClass() == String.class) {
            return new Pair((Object)Scan.VALIDATE, (Object)LogColor.apply(LogColor.RED, VALIDATE_FIELD));
        }
        for (Field field : fields) {
            Pair<Scan, String> result;
            Field[] typeFields = field.getType().getFields();
            if (typeFields.length > 0 && !field.isSynthetic() && !field.isEnumConstant()) {
                try {
                    result = ValidateConfig.getValidation(typeFields, field.get(container), annotation, validator);
                }
                catch (IllegalAccessException exception) {
                    throw new RuntimeException(exception);
                }
                if (result.getFirst() == Scan.VALIDATE) {
                    result = ValidateConfig.getAnnotationAndValidate(field, container, annotation, validator);
                }
            } else {
                result = ValidateConfig.getAnnotationAndValidate(field, container, annotation, validator);
            }
            Scan LOAD_STATE = (Scan)((Object)result.getFirst());
            String FIELD = LogColor.apply(LogColor.GOLD, field.getName());
            String RESULT = switch (LOAD_STATE) {
                default -> throw new IncompatibleClassChangeError();
                case Scan.STOP -> LogColor.apply(LogColor.RED, LOAD_STATE.toString());
                case Scan.VALIDATE -> LogColor.apply(LogColor.DARK_RED, LOAD_STATE.toString());
                case Scan.CONTINUE -> LogColor.apply(LogColor.GREEN, LOAD_STATE.toString());
            };
            NostalgicTweaks.LOGGER.debug("Field: %s | Result: %s | Message: %s", FIELD, RESULT, result.getSecond());
            if (result.getFirst() != Scan.STOP) continue;
            return result;
        }
        if (container == null) {
            return new Pair((Object)Scan.CONTINUE, (Object)LogColor.apply(LogColor.DARK_RED, NO_CLASS_DATA));
        }
        String CHECKED = LogColor.apply(LogColor.GOLD, container.getClass().getSimpleName());
        String ANNOTATION = LogColor.apply(LogColor.AQUA, annotation.getSimpleName());
        String MESSAGE = String.format("CHECKED %s FOR %s", CHECKED, ANNOTATION);
        return new Pair((Object)Scan.CONTINUE, (Object)MESSAGE);
    }

    private static <T extends Annotation> Pair<Scan, String> getAnnotationAndValidate(Field field, Object container, Class<T> annotation, TriFunction<Field, Object, T, Pair<Scan, String>> validator) {
        T data = field.getAnnotation(annotation);
        if (data != null) {
            try {
                return validator.apply(field, container, data);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
        }
        return new Pair((Object)Scan.CONTINUE, (Object)LogColor.apply(LogColor.RED, NO_METADATA));
    }

    static interface TriFunction<Fields, Config, Annotation, Result> {
        public Result apply(Fields var1, Config var2, Annotation var3) throws IllegalAccessException;
    }

    private static enum Scan {
        CONTINUE,
        VALIDATE,
        STOP;

    }
}

