/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.common.config.auto;

import java.util.HashMap;
import java.util.Map;
import mod.adrenix.nostalgic.common.config.auto.ConfigData;
import mod.adrenix.nostalgic.common.config.auto.ConfigHolder;
import mod.adrenix.nostalgic.common.config.auto.ConfigManager;
import mod.adrenix.nostalgic.common.config.auto.annotation.Config;
import mod.adrenix.nostalgic.common.config.auto.serializer.ConfigSerializer;

public abstract class AutoConfig {
    private static final Map<Class<? extends ConfigData>, ConfigHolder<?>> HOLDERS = new HashMap();

    public static <T extends ConfigData> ConfigHolder<T> register(Class<T> configClass, ConfigSerializer.Factory<T> factory) {
        if (HOLDERS.containsKey(configClass)) {
            throw new RuntimeException(String.format("config '%s' already registered", configClass));
        }
        Config definition = configClass.getAnnotation(Config.class);
        if (definition == null) {
            throw new RuntimeException(String.format("no @Config annotation is attached to %s", configClass));
        }
        ConfigSerializer<T> serializer = factory.create(definition, configClass);
        ConfigManager<T> manager = new ConfigManager<T>(definition, configClass, serializer);
        HOLDERS.put(configClass, manager);
        return manager;
    }

    public static <T extends ConfigData> ConfigHolder<T> getConfigHolder(Class<T> configClass) {
        if (HOLDERS.containsKey(configClass)) {
            return HOLDERS.get(configClass);
        }
        throw new RuntimeException(String.format("config '%s' has not been registered", configClass));
    }
}

