/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.common.config.auto;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.common.config.BackupConfig;
import mod.adrenix.nostalgic.common.config.auto.ConfigData;
import mod.adrenix.nostalgic.common.config.auto.ConfigHolder;
import mod.adrenix.nostalgic.common.config.auto.annotation.Config;
import mod.adrenix.nostalgic.common.config.auto.event.ConfigSerializeEvent;
import mod.adrenix.nostalgic.common.config.auto.serializer.ConfigSerializer;
import net.minecraft.world.InteractionResult;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ConfigManager<T extends ConfigData>
implements ConfigHolder<T> {
    private final Config definition;
    private final Class<T> configClass;
    private final ConfigSerializer<T> serializer;
    private final List<ConfigSerializeEvent.Save<T>> saveEvent = new ArrayList<ConfigSerializeEvent.Save<T>>();
    private final List<ConfigSerializeEvent.Load<T>> loadEvent = new ArrayList<ConfigSerializeEvent.Load<T>>();
    private T config;

    public ConfigManager(Config definition, Class<T> configClass, ConfigSerializer<T> serializer) {
        this.definition = definition;
        this.configClass = configClass;
        this.serializer = serializer;
        this.startup();
        if (this.load()) {
            this.save();
        }
    }

    public Config getDefinition() {
        return this.definition;
    }

    @Override
    public T getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(T config) {
        this.config = config;
    }

    @Override
    public void registerLoadListener(ConfigSerializeEvent.Load<T> load) {
        this.loadEvent.add(load);
    }

    @Override
    public void registerSaveListener(ConfigSerializeEvent.Save<T> save) {
        this.saveEvent.add(save);
    }

    public void startup() {
        try {
            BackupConfig.startup(this.serializer);
        }
        catch (IOException exception) {
            NostalgicTweaks.LOGGER.error("could not created a startup backup config file (%s)", exception.toString());
        }
    }

    @Override
    public void save() {
        for (ConfigSerializeEvent.Save<T> save : this.saveEvent) {
            InteractionResult result = save.onSave(this, this.config);
            if (result == InteractionResult.FAIL) {
                return;
            }
            if (result == InteractionResult.PASS) continue;
            break;
        }
        try {
            this.serializer.serialize(this.config);
        }
        catch (ConfigSerializer.SerializationException exception) {
            NostalgicTweaks.LOGGER.error("Failed to save config '{}'", this.configClass, exception);
        }
    }

    @Override
    public void backup() {
        try {
            BackupConfig.save(this.serializer);
        }
        catch (IOException exception) {
            throw new RuntimeException("could not create a backup config file", exception);
        }
    }

    @Override
    public boolean load() {
        try {
            T deserialized = this.serializer.deserialize();
            for (ConfigSerializeEvent.Load<T> load : this.loadEvent) {
                InteractionResult result = load.onLoad(this, deserialized);
                if (result == InteractionResult.FAIL) {
                    this.config = this.serializer.createDefault();
                    this.config.validatePostLoad();
                    return false;
                }
                if (result == InteractionResult.PASS) continue;
                break;
            }
            this.config = deserialized;
            if (this.config == null) {
                this.config = this.serializer.createDefault();
            }
            this.config.validatePostLoad();
            return true;
        }
        catch (ConfigData.ValidationException | ConfigSerializer.SerializationException exception) {
            NostalgicTweaks.LOGGER.error("Failed to load config due to invalid data", this.configClass, exception);
            this.resetToDefault();
            this.save();
            NostalgicTweaks.LOGGER.warn("Config file has been reset - see backup file for old data");
            return false;
        }
    }

    @Override
    public void resetToDefault() {
        this.backup();
        this.config = this.serializer.createDefault();
        try {
            this.config.validatePostLoad();
        }
        catch (ConfigData.ValidationException exception) {
            throw new RuntimeException("could not create a default config file", exception);
        }
    }
}

