/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.common.config.list;

import java.util.LinkedHashSet;
import java.util.Set;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.common.config.list.ListId;
import mod.adrenix.nostalgic.common.config.list.ListInclude;
import mod.adrenix.nostalgic.common.config.tweak.Tweak;
import mod.adrenix.nostalgic.util.client.NetUtil;

public abstract class AbstractList {
    private final Tweak tweak;
    private final ListId listId;
    private final ListInclude listInclude;
    private final Set<String> disabledDefaults;
    private final Set<String> serverDisabledDefaults;

    public AbstractList(Tweak tweak, ListId listId, ListInclude listInclude, Set<String> disabledDefaults) {
        if (!tweak.isLoaded()) {
            tweak.setEnabled();
        }
        this.tweak = tweak;
        this.listId = listId;
        this.listInclude = listInclude;
        this.disabledDefaults = disabledDefaults;
        this.serverDisabledDefaults = new LinkedHashSet<String>(disabledDefaults);
    }

    public Tweak getTweak() {
        return this.tweak;
    }

    public ListId getId() {
        return this.listId;
    }

    public ListInclude getInclude() {
        return this.listInclude;
    }

    public Set<String> getDisabledDefaults() {
        return this.isServerNeeded() ? this.serverDisabledDefaults : this.disabledDefaults;
    }

    public boolean isServerNeeded() {
        if (NostalgicTweaks.isServer() || NetUtil.isLocalHost()) {
            return false;
        }
        return NostalgicTweaks.isNetworkVerified() && NetUtil.isMultiplayer() && this.tweak.getServerCache() != null;
    }

    public boolean isDefaultDisabled(String resourceKey) {
        return this.getDisabledDefaults().contains(resourceKey);
    }
}

