/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.common.config.list;

import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.config.ClientConfig;
import mod.adrenix.nostalgic.client.config.ClientConfigCache;
import mod.adrenix.nostalgic.common.config.DefaultConfig;
import mod.adrenix.nostalgic.common.config.list.ListId;
import mod.adrenix.nostalgic.common.config.list.ListInclude;
import mod.adrenix.nostalgic.common.config.list.ListMap;
import mod.adrenix.nostalgic.common.config.list.ListSet;
import mod.adrenix.nostalgic.common.config.reflect.TweakCommonCache;
import mod.adrenix.nostalgic.common.config.tweak.CandyTweak;
import mod.adrenix.nostalgic.common.config.tweak.GameplayTweak;
import mod.adrenix.nostalgic.common.config.tweak.SwingTweak;
import mod.adrenix.nostalgic.server.config.ServerConfig;
import mod.adrenix.nostalgic.server.config.ServerConfigCache;
import mod.adrenix.nostalgic.util.common.ItemCommonUtil;
import net.minecraft.world.item.Items;

public abstract class ConfigList {
    private static final boolean IS_CLIENT = NostalgicTweaks.isClient();
    private static final ClientConfig.Gameplay GAMEPLAY = ClientConfigCache.getGameplay();
    private static final ClientConfig.EyeCandy CANDY = ClientConfigCache.getCandy();
    private static final ClientConfig.Swing SWING = ClientConfigCache.getSwing();
    private static final ServerConfig.Gameplay SERVER_GAMEPLAY = ServerConfigCache.getGameplay();
    private static final ListSet IGNORED_ITEM_HOLDING = new ListSet(CandyTweak.IGNORED_ITEM_HOLDING, ListId.IGNORED_ITEM_HOLDING, ListInclude.NO_BLOCKS, ItemCommonUtil.getKeysFromItems(Items.f_42717_), ConfigList.CANDY.ignoredHoldingItems, ConfigList.CANDY.disabledIgnoredHoldingItems);
    private static final ListSet FULL_BLOCK_OUTLINE = new ListSet(CandyTweak.FULL_BLOCK_OUTLINE, ListId.FULL_BLOCK_OUTLINE, ListInclude.ONLY_BLOCKS, ConfigList.CANDY.oldBlockOutlines);
    public static final ListMap<Integer> LEFT_CLICK_SPEEDS = new ListMap<Integer>(SwingTweak.LEFT_CLICK_SPEEDS, ListId.LEFT_CLICK_SPEEDS, ListInclude.ALL, 8, ConfigList.SWING.leftClickSwingSpeeds);
    public static final ListMap<Integer> RIGHT_CLICK_SPEEDS = new ListMap<Integer>(SwingTweak.RIGHT_CLICK_SPEEDS, ListId.RIGHT_CLICK_SPEEDS, ListInclude.ALL, 8, ConfigList.SWING.rightClickSwingSpeeds);
    private static final ListMap<Integer> CUSTOM_FOOD_HEALTH = new ListMap<Integer>(GameplayTweak.CUSTOM_FOOD_HEALTH, ListId.CUSTOM_FOOD_HEALTH, ListInclude.ONLY_EDIBLE, 10, DefaultConfig.Gameplay.DEFAULT_FOOD_HEALTH, IS_CLIENT ? ConfigList.GAMEPLAY.customFoodHealth : ConfigList.SERVER_GAMEPLAY.customFoodHealth, IS_CLIENT ? ConfigList.GAMEPLAY.disabledFoodHealth : ConfigList.SERVER_GAMEPLAY.disabledFoodHealth);
    private static final ListMap<Integer> CUSTOM_FOOD_STACKING = new ListMap<Integer>(GameplayTweak.CUSTOM_FOOD_STACKING, ListId.CUSTOM_FOOD_STACKING, ListInclude.ONLY_EDIBLE, 1, DefaultConfig.Gameplay.DEFAULT_OLD_FOOD_STACKING, IS_CLIENT ? ConfigList.GAMEPLAY.customFoodStacking : ConfigList.SERVER_GAMEPLAY.customFoodStacking, IS_CLIENT ? ConfigList.GAMEPLAY.disabledFoodStacking : ConfigList.SERVER_GAMEPLAY.disabledFoodStacking);
    private static final ListMap<Integer> CUSTOM_ITEM_STACKING = new ListMap<Integer>(GameplayTweak.CUSTOM_ITEM_STACKING, ListId.CUSTOM_ITEM_STACKING, ListInclude.ALL, 64, IS_CLIENT ? ConfigList.GAMEPLAY.customItemStacking : ConfigList.SERVER_GAMEPLAY.customItemStacking);

    public static ListMap<?> getMapFromId(ListId listId) {
        return switch (listId) {
            case ListId.CUSTOM_ITEM_STACKING -> CUSTOM_ITEM_STACKING;
            case ListId.CUSTOM_FOOD_STACKING -> CUSTOM_FOOD_STACKING;
            case ListId.CUSTOM_FOOD_HEALTH -> CUSTOM_FOOD_HEALTH;
            case ListId.RIGHT_CLICK_SPEEDS -> RIGHT_CLICK_SPEEDS;
            case ListId.LEFT_CLICK_SPEEDS -> LEFT_CLICK_SPEEDS;
            default -> null;
        };
    }

    public static ListMap<?> getMapFromTweak(TweakCommonCache tweak) {
        if (tweak.getList() == null) {
            return null;
        }
        return ConfigList.getMapFromId(tweak.getList().id());
    }

    public static ListSet getSetFromId(ListId listId) {
        return switch (listId) {
            case ListId.FULL_BLOCK_OUTLINE -> FULL_BLOCK_OUTLINE;
            case ListId.IGNORED_ITEM_HOLDING -> IGNORED_ITEM_HOLDING;
            default -> null;
        };
    }

    public static ListSet getSetFromTweak(TweakCommonCache tweak) {
        if (tweak.getList() == null) {
            return null;
        }
        return ConfigList.getSetFromId(tweak.getList().id());
    }
}

