/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.common.config.list;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import mod.adrenix.nostalgic.common.config.list.AbstractList;
import mod.adrenix.nostalgic.common.config.list.ListId;
import mod.adrenix.nostalgic.common.config.list.ListInclude;
import mod.adrenix.nostalgic.common.config.tweak.Tweak;
import mod.adrenix.nostalgic.util.common.ItemCommonUtil;
import net.minecraft.world.item.Item;

public class ListMap<V>
extends AbstractList {
    private final Map<String, V> serverMap = new LinkedHashMap<String, V>();
    private final Map<String, V> configMap;
    private final Map<String, V> defaultMap;
    private final V resetValue;

    public ListMap(Tweak tweak, ListId listId, ListInclude listInclude, V resetValue, Map<String, V> defaultMap, Map<String, V> configMap, Set<String> disabledDefaults) {
        super(tweak, listId, listInclude, disabledDefaults);
        this.configMap = configMap;
        this.defaultMap = defaultMap;
        this.resetValue = resetValue;
    }

    public ListMap(Tweak tweak, ListId listId, ListInclude listInclude, V resetValue, Map<String, V> configMap) {
        this(tweak, listId, listInclude, resetValue, new LinkedHashMap(), configMap, new LinkedHashSet<String>());
    }

    public V getResetValue() {
        return this.resetValue;
    }

    public Map<String, V> getConfigMap() {
        return this.isServerNeeded() ? this.serverMap : this.configMap;
    }

    public Map<String, V> getDefaultMap() {
        return this.defaultMap;
    }

    public Map.Entry<String, V> getEntryFromItem(Item item) {
        String resourceKey = ItemCommonUtil.getResourceKey(item);
        ArrayList<Map.Entry<String, V>> saved = new ArrayList<Map.Entry<String, V>>(this.getConfigMap().entrySet());
        ArrayList<Map.Entry<String, V>> defaults = new ArrayList<Map.Entry<String, V>>(this.getDefaultMap().entrySet());
        for (Map.Entry entry : saved) {
            if (!((String)entry.getKey()).equals(resourceKey)) continue;
            return entry;
        }
        for (Map.Entry entry : defaults) {
            if (!((String)entry.getKey()).equals(resourceKey) || this.isDefaultDisabled((String)entry.getKey())) continue;
            return entry;
        }
        return null;
    }
}

