/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.common.config.list;

import java.util.LinkedHashSet;
import java.util.Set;
import mod.adrenix.nostalgic.common.config.list.AbstractList;
import mod.adrenix.nostalgic.common.config.list.ListId;
import mod.adrenix.nostalgic.common.config.list.ListInclude;
import mod.adrenix.nostalgic.common.config.tweak.Tweak;
import mod.adrenix.nostalgic.util.common.ItemCommonUtil;
import net.minecraft.world.item.Item;

public class ListSet
extends AbstractList {
    private final Set<String> serverSet = new LinkedHashSet<String>();
    private final Set<String> configSet;
    private final Set<String> defaultSet;

    public ListSet(Tweak tweak, ListId listId, ListInclude listInclude, Set<String> defaultSet, Set<String> configSet, Set<String> disabledDefaults) {
        super(tweak, listId, listInclude, disabledDefaults);
        this.configSet = configSet;
        this.defaultSet = defaultSet;
    }

    public ListSet(Tweak tweak, ListId listId, ListInclude listInclude, Set<String> configSet) {
        this(tweak, listId, listInclude, new LinkedHashSet<String>(), configSet, new LinkedHashSet<String>());
    }

    public Set<String> getConfigSet() {
        return this.isServerNeeded() ? this.serverSet : this.configSet;
    }

    public Set<String> getDefaultSet() {
        return this.defaultSet;
    }

    public String getKeyFromItem(Item item) {
        String resourceKey = ItemCommonUtil.getResourceKey(item);
        for (String key : this.getConfigSet()) {
            if (!key.equals(resourceKey)) continue;
            return key;
        }
        for (String key : this.getDefaultSet()) {
            if (!key.equals(resourceKey) || this.isDefaultDisabled(key)) continue;
            return key;
        }
        return null;
    }

    public boolean isItemInList(Item item) {
        return this.getKeyFromItem(item) != null;
    }
}

