/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.common.config.list;

import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.common.config.list.ListId;

public abstract class ValidateList {
    public static boolean scan(ListId id, Object list) {
        return switch (id) {
            default -> throw new IncompatibleClassChangeError();
            case ListId.LEFT_CLICK_SPEEDS, ListId.RIGHT_CLICK_SPEEDS -> ValidateList.customSwings((Map)list, id);
            case ListId.FULL_BLOCK_OUTLINE -> ValidateList.customOutlines((Set)list);
            case ListId.CUSTOM_FOOD_HEALTH -> ValidateList.customFoodHealth((Map)list);
            case ListId.CUSTOM_FOOD_STACKING -> ValidateList.customFoodStacking((Map)list);
            case ListId.CUSTOM_ITEM_STACKING -> ValidateList.customItemStacking((Map)list);
            case ListId.IGNORED_ITEM_HOLDING -> ValidateList.ignoredHoldings((Set)list);
        };
    }

    private static boolean scanIntegerMap(Map<String, Integer> map, int min, int max, int reset, BiConsumer<String, Integer> onInvalid, BiConsumer<String, Integer> onUpdated, Consumer<Integer> onFinish) {
        boolean isValid = true;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            String key = entry.getKey();
            int value = entry.getValue();
            if (value >= min && value <= max) continue;
            onInvalid.accept(key, value);
            onUpdated.accept(key, reset);
            entry.setValue(reset);
            isValid = false;
        }
        onFinish.accept(map.size());
        return isValid;
    }

    private static boolean customSwings(Map<String, Integer> speedMap, ListId listId) {
        String list = switch (listId) {
            case ListId.LEFT_CLICK_SPEEDS -> "left-click";
            case ListId.RIGHT_CLICK_SPEEDS -> "right-click";
            default -> "N/A";
        };
        return ValidateList.scanIntegerMap(speedMap, 0, 16, 8, (key, value) -> NostalgicTweaks.LOGGER.warn("%s has an invalid %s swing speed: %s", key, list, value), (key, reset) -> NostalgicTweaks.LOGGER.warn("%s has been updated to speed: %s", key, reset), size -> NostalgicTweaks.LOGGER.info("Validated %d %s customized swing speeds", size, list));
    }

    private static boolean customFoodHealth(Map<String, Integer> healthMap) {
        return ValidateList.scanIntegerMap(healthMap, 0, 20, 10, (key, value) -> NostalgicTweaks.LOGGER.warn("%s has an invalid health value: %s", key, value), (key, reset) -> NostalgicTweaks.LOGGER.warn("%s has been updated to a value of: %s", key, reset), size -> NostalgicTweaks.LOGGER.info("Validated %d customized food health values", size));
    }

    private static boolean customFoodStacking(Map<String, Integer> stackMap) {
        return ValidateList.scanIntegerMap(stackMap, 1, 64, 1, (key, value) -> NostalgicTweaks.LOGGER.warn("%s has an invalid food stacking size: %s", key, value), (key, reset) -> NostalgicTweaks.LOGGER.warn("%s has been updated to a stack size of: %s", key, reset), size -> NostalgicTweaks.LOGGER.info("Validated %d customized maximum food item stack sizes", size));
    }

    private static boolean customItemStacking(Map<String, Integer> itemMap) {
        return ValidateList.scanIntegerMap(itemMap, 1, 64, 64, (key, value) -> NostalgicTweaks.LOGGER.warn("%s has an invalid item stacking size: %s", key, value), (key, reset) -> NostalgicTweaks.LOGGER.warn("%s has been updated to a stack size of: %s", key, reset), size -> NostalgicTweaks.LOGGER.info("Validated %d customized item stack sizes", size));
    }

    private static boolean ignoredHoldings(Set<String> list) {
        NostalgicTweaks.LOGGER.info("Validated %d ignored old item holding entries", list.size());
        return true;
    }

    private static boolean customOutlines(Set<String> list) {
        NostalgicTweaks.LOGGER.info("Validated %d customized block outline entries", list.size());
        return true;
    }
}

