/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.common.config.reflect;

import com.mojang.datafixers.util.Pair;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import javax.annotation.CheckForNull;
import mod.adrenix.nostalgic.client.config.ClientConfig;
import mod.adrenix.nostalgic.common.config.annotation.TweakData;
import mod.adrenix.nostalgic.common.config.reflect.TweakCommonCache;
import mod.adrenix.nostalgic.common.config.reflect.TweakGroup;

public abstract class CommonReflect {
    public static final ClientConfig DEFAULT_CONFIG = new ClientConfig();

    public static Pair<Class<?>, Object> getGroupClass(TweakGroup group, ClientConfig config) {
        switch (group) {
            case ROOT: {
                return new Pair(ClientConfig.class, (Object)config);
            }
            case SOUND: {
                return new Pair(ClientConfig.Sound.class, (Object)config.sound);
            }
            case CANDY: {
                return new Pair(ClientConfig.EyeCandy.class, (Object)config.eyeCandy);
            }
            case GAMEPLAY: {
                return new Pair(ClientConfig.Gameplay.class, (Object)config.gameplay);
            }
            case ANIMATION: {
                return new Pair(ClientConfig.Animation.class, (Object)config.animation);
            }
            case SWING: {
                return new Pair(ClientConfig.Swing.class, (Object)config.swing);
            }
            case GUI: {
                return new Pair(ClientConfig.Gui.class, (Object)config.gui);
            }
        }
        return new Pair(ClientConfig.class, (Object)config);
    }

    public static void setFieldHelper(Pair<Class<?>, Object> groupClass, String key, Object value) {
        Class reference = (Class)groupClass.getFirst();
        Object instance = groupClass.getSecond();
        for (Field field : reference.getFields()) {
            try {
                if (!field.getName().equals(key)) continue;
                field.set(instance, value);
                break;
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                exception.printStackTrace();
            }
        }
    }

    public static <T> T getFieldHelper(Pair<Class<?>, Object> groupClass, String key) {
        Class reference = (Class)groupClass.getFirst();
        Object instance = groupClass.getSecond();
        for (Field field : reference.getFields()) {
            try {
                if (!key.equals(field.getName())) continue;
                return (T)field.get(instance);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    @CheckForNull
    public static <T extends Annotation> T getAnnotation(TweakGroup group, String key, Class<T> annotation) {
        return CommonReflect.getFieldAnnotation(group, key, annotation);
    }

    @CheckForNull
    public static <T extends Annotation> T getAnnotation(TweakCommonCache cache, Class<T> annotation) {
        return CommonReflect.getAnnotation(cache.getGroup(), cache.getKey(), annotation);
    }

    @CheckForNull
    private static <T extends Annotation> T getFieldAnnotation(TweakGroup group, String key, Class<T> annotation) {
        Pair<Class<?>, Object> groupClass = CommonReflect.getGroupClass(group, DEFAULT_CONFIG);
        Class reference = (Class)groupClass.getFirst();
        for (Field field : reference.getFields()) {
            if (!field.getName().equals(key)) continue;
            return field.getAnnotation(annotation);
        }
        return null;
    }

    public static HashMap<String, Object> fetchFieldsHelper(Pair<Class<?>, Object> groupClass) {
        Class reference = (Class)groupClass.getFirst();
        Object instance = groupClass.getSecond();
        HashMap<String, Object> fields = new HashMap<String, Object>();
        for (Field field : reference.getFields()) {
            if (field.getAnnotation(TweakData.Ignore.class) != null) continue;
            try {
                fields.put(field.getName(), field.get(instance));
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                exception.printStackTrace();
            }
        }
        return fields;
    }
}

