/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.common.config.reflect;

import com.google.common.base.Suppliers;
import dev.architectury.platform.Platform;
import java.lang.annotation.Annotation;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import mod.adrenix.nostalgic.common.config.annotation.TweakData;
import mod.adrenix.nostalgic.common.config.reflect.CommonReflect;
import mod.adrenix.nostalgic.common.config.reflect.TweakGroup;
import mod.adrenix.nostalgic.common.config.reflect.TweakStatus;
import net.minecraft.network.chat.Component;

public abstract class TweakCommonCache {
    protected final String key;
    protected final String id;
    protected final TweakGroup group;
    protected TweakStatus status;
    @CheckForNull
    protected final TweakData.List list;
    @CheckForNull
    protected final TweakData.Conflict conflict;
    private final Supplier<Boolean> conflictSupplier = Suppliers.memoize(this::getConflict);
    public static final String RELATED_APPENDIX = ".@Related";

    protected TweakCommonCache(TweakGroup group, String key) {
        this.group = group;
        this.key = key;
        this.id = TweakCommonCache.generateKey(group, key);
        this.list = this.getMetadata(TweakData.List.class);
        this.conflict = this.getMetadata(TweakData.Conflict.class);
        this.status = this.isMetadataPresent(TweakData.EntryStatus.class) ? this.getMetadata(TweakData.EntryStatus.class).status() : TweakStatus.FAIL;
    }

    public void setStatus(TweakStatus status) {
        this.status = status;
    }

    public TweakStatus getStatus() {
        return this.status;
    }

    public TweakGroup getGroup() {
        return this.group;
    }

    public String getKey() {
        return this.key;
    }

    public String getId() {
        return this.id;
    }

    @CheckForNull
    public TweakData.List getList() {
        return this.list;
    }

    private boolean getConflict() {
        if (this.conflict == null) {
            return false;
        }
        for (String id : this.conflict.modId()) {
            if (!Platform.isModLoaded((String)id)) continue;
            return true;
        }
        return false;
    }

    public boolean isConflict() {
        return this.conflictSupplier.get();
    }

    public static String generateKey(TweakGroup group, String key) {
        return group.toString() + "@" + key;
    }

    public <A extends Annotation> A getMetadata(Class<A> annotation) {
        return CommonReflect.getAnnotation(this, annotation);
    }

    public <A extends Annotation> boolean isMetadataPresent(Class<A> annotation) {
        return this.getMetadata(annotation) != null;
    }

    public <A extends Annotation> boolean isMetadataMissing(Class<A> annotation) {
        return this.getMetadata(annotation) == null;
    }

    public String getLangKey() {
        return this.group.getLangKey() + "." + this.key;
    }

    public String getTooltipKey() {
        return this.getLangKey() + ".@Tooltip";
    }

    public String getWarningKey() {
        return this.getLangKey() + ".@Warning";
    }

    public String getOptifineKey() {
        return this.getLangKey() + ".@Optifine";
    }

    public String getSodiumKey() {
        return this.getLangKey() + ".@Sodium";
    }

    public String getConflictKey() {
        return this.getLangKey() + ".@Conflict";
    }

    public String getRelatedKey() {
        return this.getLangKey() + RELATED_APPENDIX;
    }

    public String getTranslation() {
        return this.getComponentTranslation().getString();
    }

    public String getTooltipTranslation() {
        return Component.m_237115_((String)this.getTooltipKey()).getString();
    }

    public Component getComponentTranslation() {
        return Component.m_237115_((String)this.getLangKey());
    }
}

