/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.common.config.tweak;

import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.config.reflect.TweakClientCache;
import mod.adrenix.nostalgic.common.config.reflect.TweakCommonCache;
import mod.adrenix.nostalgic.common.config.reflect.TweakGroup;
import mod.adrenix.nostalgic.common.config.reflect.TweakStatus;
import mod.adrenix.nostalgic.server.config.reflect.TweakServerCache;
import net.minecraftforge.api.distmarker.Dist;

public interface Tweak {
    public TweakGroup getGroup();

    public void setKey(String var1);

    public String getKey();

    public void setEnv(Dist var1);

    public Dist getEnv();

    public void setClientCache(TweakClientCache<?> var1);

    public TweakClientCache<?> getClientCache();

    public void setServerCache(TweakServerCache<?> var1);

    public TweakServerCache<?> getServerCache();

    public void setLoaded(boolean var1);

    public boolean isLoaded();

    default public TweakCommonCache getCommonCache() {
        if (!this.isLoaded()) {
            throw new AssertionError((Object)"Cannot get the common cache before the tweak is loaded");
        }
        if (this.getServerCache() != null) {
            return this.getServerCache();
        }
        return this.getClientCache();
    }

    /*
     * Enabled aggressive block sorting
     */
    default public void setEnabled() {
        if (this.isLoaded()) {
            return;
        }
        TweakClientCache clientCache = TweakClientCache.get(this);
        TweakServerCache serverCache = TweakServerCache.get(this);
        this.setEnv(clientCache != null && serverCache == null ? Dist.CLIENT : Dist.DEDICATED_SERVER);
        if (clientCache != null) {
            clientCache.setTweak(this);
        }
        if (NostalgicTweaks.isClient()) {
            if (clientCache == null) {
                String fail = String.format("[%s] Unable to set status of client tweak '%s' in tweak group '%s'.\nThis is a fault of the mod dev. Please report this key mismatch!", new Object[]{"Nostalgic Tweaks", this.getKey(), this.getGroup()});
                throw new AssertionError((Object)fail);
            }
            clientCache.setStatus(TweakStatus.LOADED);
        } else if (serverCache != null) {
            serverCache.setStatus(TweakStatus.LOADED);
        } else if (clientCache == null) {
            String fail = String.format("[%s] Unable to set status of server tweak '%s' in tweak group '%s'.\nThis is a fault of the mod dev. Please report this key mismatch!", new Object[]{"Nostalgic Tweaks", this.getKey(), this.getGroup()});
            throw new AssertionError((Object)fail);
        }
        this.setLoaded(true);
    }
}

