/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.common.config.tweak;

import com.google.gson.Gson;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import mod.adrenix.nostalgic.common.config.list.ConfigList;
import mod.adrenix.nostalgic.common.config.list.ListId;
import mod.adrenix.nostalgic.common.config.reflect.TweakGroup;
import mod.adrenix.nostalgic.common.config.reflect.TweakStatus;
import mod.adrenix.nostalgic.common.config.tweak.TweakVersion;
import mod.adrenix.nostalgic.server.config.reflect.TweakServerCache;

public class TweakSerializer {
    private static final Gson GSON = new Gson();
    private final String key;
    private final TweakGroup group;
    private final TweakStatus status;
    private Object value;
    private final boolean isByte;
    private final boolean isShort;
    private final boolean isInteger;
    private final boolean isLong;
    private final boolean isFloat;
    private final boolean isDouble;
    private TweakVersion.Hotbar hotbar = null;
    private ListId listId = null;
    private Set<String> disabledDefaults = null;
    private boolean isListByte = false;
    private boolean isListShort = false;
    private boolean isListInteger = false;
    private boolean isListLong = false;
    private boolean isListFloat = false;
    private boolean isListDouble = false;

    public TweakSerializer(TweakServerCache<?> tweak) {
        this.key = tweak.getKey();
        this.value = tweak.getValue();
        this.group = tweak.getGroup();
        this.status = tweak.getStatus();
        this.isByte = this.value instanceof Byte;
        this.isShort = this.value instanceof Short;
        this.isInteger = this.value instanceof Integer;
        this.isLong = this.value instanceof Long;
        this.isFloat = this.value instanceof Float;
        this.isDouble = this.value instanceof Double;
        if (this.value instanceof TweakVersion.Hotbar) {
            this.hotbar = (TweakVersion.Hotbar)this.value;
        }
        if (tweak.getList() != null) {
            this.listId = tweak.getList().id();
            if (this.value instanceof Set) {
                this.value = ConfigList.getSetFromId(this.listId).getConfigSet();
                this.disabledDefaults = ConfigList.getSetFromId(this.listId).getDisabledDefaults();
            } else if (this.value instanceof Map) {
                this.value = ConfigList.getMapFromId(this.listId).getConfigMap();
                this.disabledDefaults = ConfigList.getMapFromId(this.listId).getDisabledDefaults();
                Optional first = ((Map)this.value).values().stream().findFirst();
                if (first.isPresent()) {
                    Object value = first.get();
                    this.isListByte = value instanceof Byte;
                    this.isListShort = value instanceof Short;
                    this.isListInteger = value instanceof Integer;
                    this.isListLong = value instanceof Long;
                    this.isListFloat = value instanceof Float;
                    this.isListDouble = value instanceof Double;
                }
            }
        }
    }

    public String serialize() {
        return GSON.toJson((Object)this);
    }

    public String getKey() {
        return this.key;
    }

    public <T> T getValue() {
        return (T)this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public TweakGroup getGroup() {
        return this.group;
    }

    public TweakStatus getStatus() {
        return this.status;
    }

    public ListId getListId() {
        return this.listId;
    }

    public Set<String> getDisabledDefaults() {
        return this.disabledDefaults;
    }

    public TweakVersion.Hotbar getHotbar() {
        return this.hotbar;
    }

    private static <R> void setMapValues(Map<Object, Object> map, Function<Double, R> converter) {
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            entry.setValue(converter.apply((Double)entry.getValue()));
        }
    }

    public static TweakSerializer deserialize(String json) {
        TweakSerializer serializer = (TweakSerializer)GSON.fromJson(json, TweakSerializer.class);
        if (serializer.isByte) {
            serializer.setValue(((Double)serializer.getValue()).byteValue());
        } else if (serializer.isShort) {
            serializer.setValue(((Double)serializer.getValue()).shortValue());
        } else if (serializer.isInteger) {
            serializer.setValue(((Double)serializer.getValue()).intValue());
        } else if (serializer.isLong) {
            serializer.setValue(((Double)serializer.getValue()).longValue());
        } else if (serializer.isFloat) {
            serializer.setValue(Float.valueOf(((Double)serializer.getValue()).floatValue()));
        } else if (serializer.isDouble) {
            serializer.setValue(serializer.getValue());
        } else if (serializer.getHotbar() != null) {
            serializer.setValue(serializer.getHotbar());
        }
        if (serializer.getValue() instanceof Map) {
            Map map = (Map)serializer.getValue();
            if (serializer.isListByte) {
                TweakSerializer.setMapValues(map, Double::byteValue);
            } else if (serializer.isListShort) {
                TweakSerializer.setMapValues(map, Double::shortValue);
            } else if (serializer.isListInteger) {
                TweakSerializer.setMapValues(map, Double::intValue);
            } else if (serializer.isListLong) {
                TweakSerializer.setMapValues(map, Double::longValue);
            } else if (serializer.isListFloat) {
                TweakSerializer.setMapValues(map, Double::floatValue);
            } else if (serializer.isListDouble) {
                TweakSerializer.setMapValues(map, Double::doubleValue);
            }
        }
        return serializer;
    }
}

