/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.forge.event;

import mod.adrenix.nostalgic.client.config.ClientKeyMapping;
import mod.adrenix.nostalgic.client.event.ClientEventHelper;
import mod.adrenix.nostalgic.forge.event.client.CandyEvents;
import mod.adrenix.nostalgic.forge.event.client.GuiEvents;
import mod.adrenix.nostalgic.util.client.KeyUtil;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="nostalgic_tweaks", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public abstract class ClientEventHandler {
    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            KeyUtil.onOpenConfig(ClientKeyMapping.CONFIG_KEY);
            KeyUtil.onToggleFog(ClientKeyMapping.FOG_KEY);
        }
    }

    @SubscribeEvent
    public static void onLogOut(ClientPlayerNetworkEvent.LoggingOut event) {
        ClientEventHelper.disconnect();
    }

    @SubscribeEvent
    public static void onSetScreen(ScreenEvent.Opening event) {
        CandyEvents.classicTitleScreens(event);
    }

    @SubscribeEvent
    public static void onRenderFog(ViewportEvent.RenderFog event) {
        CandyEvents.renderOldFog(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPreRenderOverlay(RenderGuiOverlayEvent.Pre event) {
        GuiEvents.overlayOverride(event);
    }
}

