/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.forge.event.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mod.adrenix.nostalgic.common.config.ModConfig;
import mod.adrenix.nostalgic.util.client.GuiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.NamedGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public abstract class GuiEvents {
    private static final DebugScreenOverlay DEBUG_OVERLAY = new DebugScreenOverlay(Minecraft.m_91087_());

    public static void overlayOverride(RenderGuiOverlayEvent.Pre event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91066_.f_92062_) {
            event.setCanceled(true);
            return;
        }
        GuiUtil.renderOverlays(event.getPoseStack());
        NamedGuiOverlay overlay = event.getOverlay();
        boolean isDebug = overlay.equals((Object)VanillaGuiOverlay.DEBUG_TEXT.type());
        boolean isArmor = overlay.equals((Object)VanillaGuiOverlay.ARMOR_LEVEL.type());
        boolean isFood = overlay.equals((Object)VanillaGuiOverlay.FOOD_LEVEL.type());
        boolean isAir = overlay.equals((Object)VanillaGuiOverlay.AIR_LEVEL.type());
        boolean isOverlay = isArmor || isFood || isAir;
        boolean isVehiclePresent = false;
        boolean isSurvivalMode = true;
        Entity entity = minecraft.m_91288_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_7500_() || player.m_5833_()) {
                isSurvivalMode = false;
            }
            if (player.m_20202_() instanceof LivingEntity) {
                isVehiclePresent = true;
            }
        }
        if (minecraft.f_91066_.f_92063_ && isDebug) {
            DEBUG_OVERLAY.m_94056_(event.getPoseStack());
            event.setCanceled(true);
        }
        if (isOverlay && isSurvivalMode && !isVehiclePresent) {
            PoseStack poseStack = event.getPoseStack();
            ForgeGui gui = (ForgeGui)minecraft.f_91065_;
            gui.setupOverlayRenderState(true, false);
            int width = event.getWindow().m_85445_();
            int height = event.getWindow().m_85446_();
            if (isArmor) {
                GuiEvents.renderArmor(gui, width, height, poseStack);
            } else if (isFood) {
                GuiEvents.renderFood(gui, width, height, poseStack);
            } else {
                GuiEvents.renderAir(gui, width, height, poseStack);
            }
        }
    }

    private static void renderFood(ForgeGui gui, int width, int height, PoseStack poseStack) {
        if (ModConfig.Gameplay.disableHungerBar()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        Player player = (Player)minecraft.m_91288_();
        if (player == null) {
            return;
        }
        minecraft.m_91307_().m_6180_("food");
        RenderSystem.m_69478_();
        GuiUtil.renderFood((Gui)gui, poseStack, player, width, height, gui.rightHeight);
        RenderSystem.m_69461_();
        minecraft.m_91307_().m_7238_();
    }

    private static void renderArmor(ForgeGui gui, int width, int height, PoseStack poseStack) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null) {
            return;
        }
        minecraft.m_91307_().m_6180_("armor");
        RenderSystem.m_69478_();
        GuiUtil.renderArmor((Gui)gui, poseStack, (Player)minecraft.f_91074_, width, height, gui.leftHeight, gui.rightHeight);
        RenderSystem.m_69461_();
        minecraft.m_91307_().m_7238_();
    }

    public static boolean isPlayerLosingAir(Player player) {
        return player.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) || player.m_20146_() < 300;
    }

    private static void renderAir(ForgeGui gui, int width, int height, PoseStack poseStack) {
        Minecraft minecraft = Minecraft.m_91087_();
        Player player = (Player)minecraft.m_91288_();
        if (player == null) {
            return;
        }
        minecraft.m_91307_().m_6180_("air");
        RenderSystem.m_69478_();
        GuiUtil.renderAir(GuiEvents::isPlayerLosingAir, (Gui)gui, poseStack, player, width, height, gui.leftHeight, gui.rightHeight);
        RenderSystem.m_69461_();
        minecraft.m_91307_().m_7238_();
    }
}

