/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.forge.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import mod.adrenix.nostalgic.common.config.ModConfig;
import mod.adrenix.nostalgic.forge.event.client.GuiEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ForgeGui.class})
public abstract class ForgeGuiMixin {
    @Shadow
    public int rightHeight;
    @Shadow
    public int leftHeight;

    private static boolean isRendererBlocked() {
        Entity entity = Minecraft.m_91087_().m_91288_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return !player.m_7500_() && !player.m_5833_() && !(player.m_20202_() instanceof LivingEntity);
        }
        return false;
    }

    @Inject(method={"render"}, at={@At(ordinal=0, shift=At.Shift.BEFORE, value="INVOKE", target="Lnet/minecraftforge/eventbus/api/IEventBus;post(Lnet/minecraftforge/eventbus/api/Event;)Z")})
    private void NT$onBeforeEventPost(PoseStack poseStack, float partialTick, CallbackInfo callback) {
        if (ForgeGuiMixin.isRendererBlocked()) {
            int offset = ModConfig.Gameplay.disableExperienceBar() ? 7 : 0;
            this.rightHeight -= offset;
            this.leftHeight -= offset;
        }
    }

    @Inject(method={"renderArmor"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onRenderArmor(PoseStack poseStack, int width, int height, CallbackInfo callback) {
        if (ForgeGuiMixin.isRendererBlocked()) {
            if (ModConfig.Gameplay.disableHungerBar()) {
                this.rightHeight += 10;
            } else {
                this.leftHeight += 10;
            }
            callback.cancel();
        }
    }

    @Inject(method={"renderFood"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onRenderFood(int width, int height, PoseStack poseStack, CallbackInfo callback) {
        if (ForgeGuiMixin.isRendererBlocked()) {
            this.rightHeight += 10;
            callback.cancel();
        }
    }

    @Inject(method={"renderAir"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onRenderAir(int width, int height, PoseStack poseStack, CallbackInfo callback) {
        if (ForgeGuiMixin.isRendererBlocked()) {
            Player player;
            Entity entity = Minecraft.m_91087_().m_91288_();
            if (entity instanceof Player && GuiEvents.isPlayerLosingAir(player = (Player)entity)) {
                if (ModConfig.Gameplay.disableHungerBar()) {
                    this.leftHeight += 10;
                } else {
                    this.rightHeight += 10;
                }
            }
            callback.cancel();
        }
    }
}

