/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.config.SwingConfig;
import mod.adrenix.nostalgic.client.screen.NostalgicPauseScreen;
import mod.adrenix.nostalgic.client.screen.NostalgicProgressScreen;
import mod.adrenix.nostalgic.common.config.ModConfig;
import mod.adrenix.nostalgic.common.config.tweak.TweakVersion;
import mod.adrenix.nostalgic.mixin.duck.SwingBlocker;
import mod.adrenix.nostalgic.util.client.AnimationUtil;
import mod.adrenix.nostalgic.util.client.RenderUtil;
import mod.adrenix.nostalgic.util.client.SwingType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.profiling.ProfileResults;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin {
    @Shadow
    @Nullable
    public Screen f_91080_;
    @Shadow
    @Nullable
    public ClientLevel f_91073_;
    @Shadow
    @Nullable
    public LocalPlayer f_91074_;
    @Shadow
    @Nullable
    public HitResult f_91077_;
    @Shadow
    @Nullable
    public MultiPlayerGameMode f_91072_;
    @Shadow
    @Final
    private Window f_90990_;
    @Shadow
    @Final
    public Options f_91066_;
    @Shadow
    protected int f_91078_;

    @Shadow
    public abstract Window m_91268_();

    @Inject(method={"updateTitle"}, at={@At(value="RETURN")})
    private void NT$onUpdateTitle(CallbackInfo callback) {
        if (!ModConfig.Candy.enableWindowTitle()) {
            return;
        }
        if (ModConfig.Candy.matchVersionOverlay()) {
            this.f_90990_.m_85422_(ModConfig.Candy.getOverlayText().replaceAll("\u00a7.", ""));
        } else {
            this.f_90990_.m_85422_(ModConfig.Candy.getWindowTitle().replaceAll("\u00a7.", ""));
        }
    }

    @Inject(method={"handleKeybinds"}, at={@At(shift=At.Shift.BEFORE, value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;swing(Lnet/minecraft/world/InteractionHand;)V")})
    private void NT$onDropItem(CallbackInfo callback) {
        SwingBlocker injector = (SwingBlocker)this.f_91074_;
        if (ModConfig.Animation.oldSwingDropping() && injector != null) {
            injector.NT$setSwingBlocked(true);
        }
    }

    @ModifyArg(method={"clearLevel(Lnet/minecraft/client/gui/screens/Screen;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;updateScreenAndTick(Lnet/minecraft/client/gui/screens/Screen;)V"))
    private Screen NT$onSaveScreen(Screen genericScreen) {
        if (!ModConfig.Candy.oldLoadingScreens()) {
            return genericScreen;
        }
        if (genericScreen.getClass() == GenericDirtMessageScreen.class) {
            NostalgicProgressScreen progressScreen = new NostalgicProgressScreen(new ProgressScreen(false));
            progressScreen.setStage((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.level.saving"));
            progressScreen.setPauseTicking(1.0);
            return progressScreen;
        }
        return genericScreen;
    }

    @Inject(method={"setLevel"}, at={@At(value="HEAD")})
    private void NT$onSetLevel(ClientLevel levelClient, CallbackInfo callback) {
        if (this.f_91073_ != null) {
            NostalgicProgressScreen.setPreviousDimension((ResourceKey<Level>)this.f_91073_.m_46472_());
        }
        NostalgicProgressScreen.setCurrentDimension((ResourceKey<Level>)levelClient.m_46472_());
    }

    @Inject(method={"clearLevel()V"}, at={@At(value="TAIL")})
    private void NT$onClearLevel(CallbackInfo callback) {
        NostalgicProgressScreen.setCurrentDimension(null);
        NostalgicProgressScreen.setPreviousDimension(null);
    }

    @Inject(method={"getFramerateLimit"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onGetFramerateLimit(CallbackInfoReturnable<Integer> callback) {
        if (ModConfig.Candy.uncapTitleFPS()) {
            callback.setReturnValue((Object)this.m_91268_().m_85434_());
        }
    }

    @ModifyArg(method={"pauseGame"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setScreen(Lnet/minecraft/client/gui/screens/Screen;)V"))
    private Screen NT$onPauseGame(Screen vanilla) {
        boolean isDebug = InputConstants.m_84830_((long)this.m_91268_().m_85439_(), (int)292);
        if (!ModConfig.Candy.getPauseLayout().equals(TweakVersion.PauseLayout.MODERN) && !isDebug) {
            return new NostalgicPauseScreen();
        }
        return vanilla;
    }

    @Inject(method={"continueAttack"}, at={@At(value="HEAD")})
    private void NT$onContinueAttack(boolean leftClick, CallbackInfo callback) {
        if (ModConfig.Gameplay.disableMissTime()) {
            this.f_91078_ = 0;
        }
    }

    @Inject(method={"startAttack"}, at={@At(shift=At.Shift.AFTER, value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;startDestroyBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z")})
    private void NT$onLeftClickBlock(CallbackInfoReturnable<Boolean> callback) {
        boolean isNull;
        BlockHitResult result = (BlockHitResult)this.f_91077_;
        boolean bl = isNull = this.f_91073_ == null || this.f_91074_ == null || this.f_91072_ == null || result == null;
        if (!NostalgicTweaks.isNetworkVerified() || isNull || this.f_91074_.m_7500_() || this.f_91074_.m_6144_()) {
            return;
        }
        BlockState state = this.f_91073_.m_8055_(result.m_82425_());
        Block block = state.m_60734_();
        boolean isUsing = false;
        if (ModConfig.Gameplay.leftClickDoor() && (block instanceof DoorBlock || block instanceof TrapDoorBlock || block instanceof FenceGateBlock)) {
            isUsing = true;
        }
        if (ModConfig.Gameplay.leftClickLever() && block instanceof LeverBlock) {
            isUsing = true;
        }
        if (ModConfig.Gameplay.leftClickButton() && block instanceof ButtonBlock) {
            isUsing = true;
        }
        if (isUsing) {
            this.f_91072_.m_233732_(this.f_91074_, InteractionHand.MAIN_HAND, result);
        }
    }

    @Inject(method={"startAttack"}, at={@At(value="HEAD")})
    private void NT$onStartAttack(CallbackInfoReturnable<Boolean> callback) {
        AnimationUtil.swingType = SwingType.LEFT_CLICK;
        if (ModConfig.Animation.oldInterruptSwing() && this.f_91074_ != null) {
            this.f_91074_.f_20921_ = 0.0f;
            this.f_91074_.f_20913_ = 0;
        }
        if (ModConfig.Gameplay.disableMissTime()) {
            this.f_91078_ = 0;
        }
    }

    @Inject(method={"startUseItem"}, at={@At(value="HEAD")})
    private void NT$onStartUseItem(CallbackInfo callback) {
        AnimationUtil.swingType = SwingType.RIGHT_CLICK;
    }

    @Inject(method={"startUseItem"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;useItemOn(Lnet/minecraft/client/player/LocalPlayer;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;"))}, at={@At(value="INVOKE", ordinal=0, shift=At.Shift.BEFORE, target="Lnet/minecraft/client/player/LocalPlayer;swing(Lnet/minecraft/world/InteractionHand;)V")})
    private void NT$onStartUseItemOn(CallbackInfo callback) {
        if (SwingConfig.isLeftSpeedOnBlockInteract() && !ModConfig.Animation.oldClassicSwing()) {
            AnimationUtil.swingType = SwingType.LEFT_CLICK;
        }
    }

    @Redirect(method={"startAttack"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isHandsBusy()Z"))
    private boolean NT$onCheckBusyHands(LocalPlayer instance) {
        return !ModConfig.Gameplay.disableMissTime() && instance.m_108637_();
    }

    @Inject(method={"shouldRenderFpsPie"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onShouldRenderFpsPie(CallbackInfoReturnable<Boolean> callback) {
        boolean isDebugging;
        boolean bl = isDebugging = !ModConfig.Candy.getDebugScreen().equals(TweakVersion.Generic.MODERN);
        if (ModConfig.Candy.displayPieChart() && isDebugging && this.f_91066_.f_92063_ && !this.f_91066_.f_92062_) {
            callback.setReturnValue((Object)true);
        }
    }

    @Inject(method={"renderFpsMeter"}, at={@At(shift=At.Shift.AFTER, ordinal=0, value="INVOKE", target="Lcom/mojang/blaze3d/vertex/BufferBuilder;begin(Lcom/mojang/blaze3d/vertex/VertexFormat$Mode;Lcom/mojang/blaze3d/vertex/VertexFormat;)V")})
    private void NT$onRenderFpsMeter(PoseStack poseStack, ProfileResults profilerResults, CallbackInfo callback) {
        if (!ModConfig.Candy.oldPieBackground()) {
            return;
        }
        int color = -822083584;
        int x = this.f_90990_.m_85441_() - 160 - 10;
        int y = this.f_90990_.m_85442_() - 320;
        RenderUtil.fill(Tesselator.m_85913_().m_85915_(), (float)x - 176.0f, (float)x + 176.0f, (float)y - 96.0f - 16.0f, (float)y + 320.0f, color);
    }
}

