/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.client;

import mod.adrenix.nostalgic.common.config.ModConfig;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;

@Mixin(value={ModelBakery.class})
public abstract class ModelBakeryMixin {
    @Redirect(method={"loadModel"}, at=@At(value="INVOKE", target="Lnet/minecraft/resources/ResourceLocation;getNamespace()Ljava/lang/String;"), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/block/model/BlockModelDefinition$Context;setDefinition(Lnet/minecraft/world/level/block/state/StateDefinition;)V")))
    private String NT$onLoadModel(ResourceLocation blockStateLocation) {
        String minecraft = "minecraft";
        String namespace = blockStateLocation.m_135827_();
        String path = blockStateLocation.m_135815_();
        if (!namespace.equals(minecraft)) {
            return namespace;
        }
        namespace = switch (path) {
            case "chest" -> {
                if (ModConfig.Candy.oldChest()) {
                    yield "nostalgic_tweaks";
                }
                yield minecraft;
            }
            case "ender_chest" -> {
                if (ModConfig.Candy.oldEnderChest()) {
                    yield "nostalgic_tweaks";
                }
                yield minecraft;
            }
            case "trapped_chest" -> {
                if (ModConfig.Candy.oldTrappedChest()) {
                    yield "nostalgic_tweaks";
                }
                yield minecraft;
            }
            default -> namespace;
        };
        return namespace;
    }

    @ModifyVariable(method={"loadBlockModel"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private ResourceLocation NT$onLoadBlockModel(ResourceLocation vanilla) {
        String minecraft = "minecraft";
        String namespace = vanilla.m_135827_();
        String path = vanilla.m_135815_();
        String nt = "nostalgic_tweaks";
        if (!namespace.equals(minecraft)) {
            return vanilla;
        }
        switch (path) {
            case "block/chest": 
            case "item/chest": {
                String string;
                if (ModConfig.Candy.oldChest()) {
                    string = nt;
                    break;
                }
                string = minecraft;
                break;
            }
            case "block/ender_chest": 
            case "item/ender_chest": {
                String string;
                if (ModConfig.Candy.oldEnderChest()) {
                    string = nt;
                    break;
                }
                string = minecraft;
                break;
            }
            case "block/trapped_chest": 
            case "item/trapped_chest": {
                String string;
                if (ModConfig.Candy.oldTrappedChest()) {
                    string = nt;
                    break;
                }
                string = minecraft;
                break;
            }
            default: {
                String string = namespace = namespace;
            }
        }
        if (ModConfig.Candy.oldChest() && !ModConfig.Candy.oldEnderChest() && path.equals("item/ender_chest")) {
            return new ResourceLocation("nostalgic_tweaks", "item/vanilla_ender_chest");
        }
        if (ModConfig.Candy.oldChest() && !ModConfig.Candy.oldTrappedChest() && path.equals("item/trapped_chest")) {
            return new ResourceLocation("nostalgic_tweaks", "item/vanilla_trapped_chest");
        }
        return new ResourceLocation(namespace, path);
    }
}

