/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.client.gui;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import mod.adrenix.nostalgic.common.config.ModConfig;
import mod.adrenix.nostalgic.common.config.tweak.TweakType;
import mod.adrenix.nostalgic.common.config.tweak.TweakVersion;
import mod.adrenix.nostalgic.mixin.widen.LevelRendererAccessor;
import mod.adrenix.nostalgic.mixin.widen.MinecraftAccessor;
import mod.adrenix.nostalgic.util.common.ColorUtil;
import mod.adrenix.nostalgic.util.common.MathUtil;
import mod.adrenix.nostalgic.util.common.TextUtil;
import mod.adrenix.nostalgic.util.common.WorldCommonUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DebugScreenOverlay.class})
public abstract class DebugScreenOverlayMixin
extends GuiComponent {
    @Shadow
    @Final
    private Font f_94031_;
    @Shadow
    @Final
    private Minecraft f_94030_;
    @Shadow
    private HitResult f_94032_;
    @Shadow
    private HitResult f_94033_;

    @Shadow
    protected abstract void m_94058_(PoseStack var1, FrameTimer var2, int var3, int var4, boolean var5);

    @Shadow
    protected abstract int m_94045_(int var1, int var2, int var3, int var4);

    @Shadow
    protected abstract String m_94071_(Map.Entry<Property<?>, Comparable<?>> var1);

    @Shadow
    private static String m_205374_(Holder<Biome> biomeHolder) {
        return null;
    }

    @Unique
    private void NT$drawLineBackground(PoseStack poseStack, String info, int index, boolean isLeft) {
        if (!ModConfig.Candy.showDebugBackground()) {
            return;
        }
        int color = ColorUtil.toHexInt(ModConfig.Candy.debugBackgroundColor());
        int scaledWidth = this.f_94030_.m_91268_().m_85445_();
        int fontWidth = this.f_94031_.m_92895_(info);
        Objects.requireNonNull(this.f_94031_);
        int fontHeight = 9;
        int minX = isLeft ? 1 : scaledWidth - 2 - fontWidth - 1;
        int maxX = isLeft ? 2 + fontWidth + 1 : scaledWidth - 2 - fontWidth + fontWidth + 1;
        int minY = 2 + fontHeight * index - 1;
        int maxY = 2 + fontHeight * index + fontHeight - 1;
        DebugScreenOverlay.m_93172_((PoseStack)poseStack, (int)minX, (int)minY, (int)maxX, (int)maxY, (int)color);
    }

    @Unique
    private void NT$drawInformation(PoseStack poseStack, String text, float x, float y, int color) {
        if (ModConfig.Candy.showDebugTextShadow()) {
            this.f_94031_.m_92750_(poseStack, text, x, y, color);
        } else {
            this.f_94031_.m_92883_(poseStack, text, x, y, color);
        }
    }

    @Redirect(method={"drawGameInformation"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/Font;draw(Lcom/mojang/blaze3d/vertex/PoseStack;Ljava/lang/String;FFI)I"))
    private int NT$onDrawGameInformation(Font font, PoseStack poseStack, String text, float x, float y, int color) {
        return ModConfig.Candy.showDebugTextShadow() ? font.m_92750_(poseStack, text, x, y, color) : font.m_92883_(poseStack, text, x, y, color);
    }

    @Redirect(method={"drawGameInformation"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/DebugScreenOverlay;fill(Lcom/mojang/blaze3d/vertex/PoseStack;IIIII)V"))
    private void NT$onDrawGameInformationColor(PoseStack poseStack, int minX, int minY, int maxX, int maxY, int color) {
        if (ModConfig.Candy.showDebugBackground()) {
            DebugScreenOverlay.m_93172_((PoseStack)poseStack, (int)minX, (int)minY, (int)maxX, (int)maxY, (int)ColorUtil.toHexInt(ModConfig.Candy.debugBackgroundColor()));
        }
    }

    @Redirect(method={"drawSystemInformation"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/Font;draw(Lcom/mojang/blaze3d/vertex/PoseStack;Ljava/lang/String;FFI)I"))
    private int NT$onDrawSystemInformation(Font font, PoseStack poseStack, String text, float x, float y, int color) {
        return ModConfig.Candy.showDebugTextShadow() ? font.m_92750_(poseStack, text, x, y, color) : font.m_92883_(poseStack, text, x, y, color);
    }

    @Redirect(method={"drawSystemInformation"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/DebugScreenOverlay;fill(Lcom/mojang/blaze3d/vertex/PoseStack;IIIII)V"))
    private void NT$onDrawSystemInformationColor(PoseStack poseStack, int minX, int minY, int maxX, int maxY, int color) {
        if (ModConfig.Candy.showDebugBackground()) {
            DebugScreenOverlay.m_93172_((PoseStack)poseStack, (int)minX, (int)minY, (int)maxX, (int)maxY, (int)ColorUtil.toHexInt(ModConfig.Candy.debugBackgroundColor()));
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onRender(PoseStack poseStack, CallbackInfo callback) {
        String text;
        int i;
        String gpu;
        String usage;
        Entity entity = this.f_94030_.m_91288_();
        TweakVersion.Generic debug = ModConfig.Candy.getDebugScreen();
        if (debug.equals(TweakVersion.Generic.MODERN) || this.f_94030_.f_91073_ == null || entity == null) {
            return;
        }
        this.f_94032_ = entity.m_19907_(20.0, 0.0f, false);
        this.f_94033_ = entity.m_19907_(20.0, 0.0f, true);
        boolean isReducedInfo = this.f_94030_.m_91299_();
        String overlay = ModConfig.Candy.getOverlayText();
        String title = overlay.isEmpty() ? "Minecraft " + SharedConstants.m_183709_().getName() : overlay;
        String fps = String.format(" (%s fps, %s chunk updates)", MinecraftAccessor.NT$getFPS(), this.f_94030_.f_91060_.m_173015_().m_173713_());
        String chunks = String.format("C: %d/%d. F: 0, O: 0, E: 0", this.f_94030_.f_91060_.m_109821_(), (long)this.f_94030_.f_91060_.m_173016_());
        String entities = String.format("E: %s/%s. B: %s, I: 0", ((LevelRendererAccessor)this.f_94030_.f_91060_).NT$getRenderedEntities(), this.f_94030_.f_91073_.m_104813_(), ((LevelRendererAccessor)this.f_94030_.f_91060_).NT$getCulledEntities());
        String particles = String.format("P: %s. T: All: %s", this.f_94030_.f_91061_.m_107403_(), this.f_94030_.f_91073_.m_104813_());
        String overflow = String.format(" (%s fps)", MinecraftAccessor.NT$getFPS());
        BlockPos blockPos = entity.m_20183_();
        long max = Runtime.getRuntime().maxMemory();
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        long used = total - free;
        int width = this.f_94030_.m_91268_().m_85445_();
        String memory = String.format("Used memory: %2d%% (%03dMB) of %03dMB", used * 100L / max, MathUtil.bytesToMegabytes(used), MathUtil.bytesToMegabytes(max));
        String allocated = String.format("Allocated memory: %2d%% (%03dMB)", total * 100L / max, MathUtil.bytesToMegabytes(total));
        if (this.f_94031_.m_92895_(title + fps) + 2 > width - 2 - this.f_94031_.m_92895_(memory)) {
            fps = overflow;
        }
        ArrayList left = Lists.newArrayList((Object[])new String[]{title + fps, chunks, entities, particles});
        ArrayList right = Lists.newArrayList((Object[])new String[]{memory, allocated});
        if (ModConfig.Candy.showDebugGpuUsage() && !(usage = TextUtil.extract(gpu = TextUtil.extract(this.f_94030_.f_90977_, "GPU:.+"), "\\d+")).isEmpty()) {
            right.add("GPU usage: " + TextUtil.getPercentColorHigh(Integer.parseInt(usage)) + "%");
        }
        if (debug.equals(TweakVersion.Generic.BETA)) {
            left.add(String.format("ChunkCache: %d", this.f_94030_.f_91073_.m_7726_().m_8482_()));
            if (!isReducedInfo) {
                left.add("");
                left.add(String.format("X: %f", entity.m_20185_()));
                left.add(String.format("Y: %f", entity.m_20186_()));
                left.add(String.format("Z: %f", entity.m_20189_()));
            }
        }
        if (!isReducedInfo) {
            boolean isValidHeight;
            left.add("");
            if (ModConfig.Candy.showDebugFacingData()) {
                Direction direction = entity.m_6350_();
                String facing = switch (direction) {
                    case Direction.NORTH -> "Towards negative Z";
                    case Direction.SOUTH -> "Towards positive Z";
                    case Direction.WEST -> "Towards negative X";
                    case Direction.EAST -> "Towards positive X";
                    default -> "Invalid";
                };
                left.add(String.format("Facing: %s (%s) (%.1f / %.1f)", direction, facing, Float.valueOf(Mth.m_14177_((float)entity.m_146908_())), Float.valueOf(Mth.m_14177_((float)entity.m_146909_()))));
            }
            if (ModConfig.Candy.showDebugLightData()) {
                int nostalgicSkyLight = this.f_94030_.f_91073_.m_45517_(LightLayer.SKY, blockPos);
                int nostalgicBlockLight = this.f_94030_.f_91073_.m_45517_(LightLayer.BLOCK, blockPos);
                int nostalgicClientLight = Math.max(nostalgicSkyLight, nostalgicBlockLight);
                left.add(String.format("Nostalgic Light: %d (%d sky, %d block)", nostalgicClientLight, nostalgicSkyLight, nostalgicBlockLight));
                int clientLight = this.f_94030_.f_91073_.m_7726_().m_7827_().m_75831_(blockPos, 0);
                int vanillaSkyLight = WorldCommonUtil.getBrightness((BlockAndTintGetter)this.f_94030_.f_91073_, LightLayer.SKY, blockPos);
                int vanillaBlockLight = WorldCommonUtil.getBrightness((BlockAndTintGetter)this.f_94030_.f_91073_, LightLayer.BLOCK, blockPos);
                left.add(String.format("Vanilla Light: %d (%d sky, %d block)", clientLight, vanillaSkyLight, vanillaBlockLight));
            }
            Entity targetEntity = this.f_94030_.f_91076_;
            boolean isTargeted = ModConfig.Candy.showDebugTargetData();
            boolean bl = isValidHeight = blockPos.m_123342_() >= this.f_94030_.f_91073_.m_141937_() && blockPos.m_123342_() < this.f_94030_.f_91073_.m_151558_();
            if (ModConfig.Candy.showDebugBiomeData() && isValidHeight) {
                left.add(String.format("Biome: %s", DebugScreenOverlayMixin.m_205374_((Holder<Biome>)this.f_94030_.f_91073_.m_204166_(blockPos))));
            }
            if (isTargeted && this.f_94032_.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos targetPos = ((BlockHitResult)this.f_94032_).m_82425_();
                BlockState targetState = this.f_94030_.f_91073_.m_8055_(targetPos);
                right.add("");
                right.add(String.format(ChatFormatting.UNDERLINE + "Targeted Block: %s, %s, %s", targetPos.m_123341_(), targetPos.m_123342_(), targetPos.m_123343_()));
                right.add(String.valueOf(Registry.f_122824_.m_7981_((Object)targetState.m_60734_())));
                for (Map.Entry entry : targetState.m_61148_().entrySet()) {
                    right.add(this.m_94071_(entry));
                }
                targetState.m_204343_().map(tagKey -> "#" + tagKey.f_203868_()).forEach(right::add);
            }
            if (isTargeted && this.f_94033_.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos targetPos = ((BlockHitResult)this.f_94033_).m_82425_();
                FluidState targetState = this.f_94030_.f_91073_.m_6425_(targetPos);
                right.add("");
                right.add(String.format(ChatFormatting.UNDERLINE + "Targeted Fluid: %s, %s, %s", targetPos.m_123341_(), targetPos.m_123342_(), targetPos.m_123343_()));
                right.add(String.valueOf(Registry.f_122822_.m_7981_((Object)targetState.m_76152_())));
                for (Map.Entry entry : targetState.m_61148_().entrySet()) {
                    right.add(this.m_94071_(entry));
                }
                targetState.m_205075_().map(tagKey -> "#" + tagKey.f_203868_()).forEach(right::add);
            }
            if (isTargeted && targetEntity != null) {
                right.add("");
                right.add(ChatFormatting.UNDERLINE + "Targeted Entity:");
                right.add(String.valueOf(Registry.f_122826_.m_7981_((Object)targetEntity.m_6095_())));
            }
        }
        for (i = 0; i < left.size(); ++i) {
            text = (String)left.get(i);
            if (Strings.isNullOrEmpty((String)text)) continue;
            this.NT$drawLineBackground(poseStack, text, i, true);
            Objects.requireNonNull(this.f_94031_);
            this.NT$drawInformation(poseStack, text, 2.0f, 2.0f + (float)(9 * i), 0xFFFFFF);
        }
        for (i = 0; i < right.size(); ++i) {
            text = (String)right.get(i);
            if (Strings.isNullOrEmpty((String)text)) continue;
            int x = width - 2 - this.f_94031_.m_92895_(text);
            Objects.requireNonNull(this.f_94031_);
            int y = 2 + 9 * i;
            this.NT$drawLineBackground(poseStack, text, i, false);
            this.NT$drawInformation(poseStack, text, x, y, 0xE0E0E0);
        }
        this.m_94058_(poseStack, this.f_94030_.m_91293_(), 0, width / 2, true);
        IntegratedServer server = this.f_94030_.m_91092_();
        if (ModConfig.Candy.displayTpsChart() && server != null) {
            this.m_94058_(poseStack, server.m_129904_(), width - Math.min(width / 2, 240), width / 2, false);
        }
        callback.cancel();
    }

    @Inject(method={"drawChart"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onDrawChart(PoseStack poseStack, FrameTimer frameTimer, int startX, int width, boolean drawForFps, CallbackInfo callback) {
        int limit;
        TweakVersion.Generic debug = ModConfig.Candy.getDebugScreen();
        TweakType.DebugChart chart = ModConfig.Candy.getDebugChart();
        boolean isDisabled = chart.equals(TweakType.DebugChart.DISABLED);
        boolean isModern = chart.equals(TweakType.DebugChart.MODERN);
        boolean isOld = chart.equals(TweakType.DebugChart.CLASSIC);
        if (debug.equals(TweakVersion.Generic.MODERN) || !drawForFps) {
            return;
        }
        if (isDisabled) {
            callback.cancel();
            return;
        }
        RenderSystem.m_69465_();
        long[] log = frameTimer.m_13764_();
        int maxWidth = (int)Math.max(0.0f, (float)log.length - (float)this.f_94030_.m_91268_().m_85445_() / 3.5f);
        int endX = log.length - maxWidth - (isOld ? 1 : 0);
        int max = Integer.MAX_VALUE;
        int min = Integer.MIN_VALUE;
        int index = frameTimer.m_13762_(frameTimer.m_13754_() + maxWidth);
        long avg = 0L;
        for (int i = 0; i < endX; ++i) {
            int time = (int)(log[frameTimer.m_13762_(index + i)] / 1000000L);
            max = Math.min(max, time);
            min = Math.max(min, time);
            avg += (long)time;
        }
        int height = this.f_94030_.m_91268_().m_85446_();
        int color = isOld ? -1876951040 : -1873784752;
        GuiComponent.m_93172_((PoseStack)poseStack, (int)startX, (int)(height - 60), (int)(startX + endX), (int)height, (int)color);
        if (isOld) {
            GuiComponent.m_93172_((PoseStack)poseStack, (int)startX, (int)(height - 32), (int)(startX + endX), (int)(height - 15), (int)-1879048192);
        }
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        Matrix4f transform = Transformation.m_121093_().m_121104_();
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        int drawX = startX;
        while (index != frameTimer.m_13761_()) {
            int scale = frameTimer.m_13757_(log[index], 30, 60);
            int rgb = this.m_94045_(Mth.m_14045_((int)scale, (int)0, (int)100), 0, 50, 100);
            int a = rgb >> 24 & 0xFF;
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            builder.m_85982_(transform, (float)(drawX + 1), (float)height, 0.0f).m_6122_(r, g, b, a).m_5752_();
            builder.m_85982_(transform, (float)(drawX + 1), (float)(height - scale + 1), 0.0f).m_6122_(r, g, b, a).m_5752_();
            builder.m_85982_(transform, (float)drawX, (float)(height - scale + 1), 0.0f).m_6122_(r, g, b, a).m_5752_();
            builder.m_85982_(transform, (float)drawX, (float)height, 0.0f).m_6122_(r, g, b, a).m_5752_();
            index = frameTimer.m_13762_(index + 1);
            ++drawX;
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
        if (isModern) {
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(startX + 1), (int)(height - 30 + 1), (int)(startX + 14), (int)(height - 30 + 10), (int)-1873784752);
            this.f_94031_.m_92883_(poseStack, "60 FPS", (float)(startX + 2), (float)(height - 30 + 2), 0xE0E0E0);
            this.m_93154_(poseStack, startX, startX + endX - 1, height - 30, -1);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(startX + 1), (int)(height - 60 + 1), (int)(startX + 14), (int)(height - 60 + 10), (int)-1873784752);
            this.f_94031_.m_92883_(poseStack, "30 FPS", (float)(startX + 2), (float)(height - 60 + 2), 0xE0E0E0);
            this.m_93154_(poseStack, startX, startX + endX - 1, height - 60, -1);
            this.m_93154_(poseStack, startX, startX + endX - 1, height - 1, -1);
            this.m_93222_(poseStack, startX, height - 60, height, -1);
            this.m_93222_(poseStack, startX + endX - 1, height - 60, height, -1);
        }
        if ((limit = ((Integer)this.f_94030_.f_91066_.m_232035_().m_231551_()).intValue()) > 0 && limit <= 250) {
            int fpsLine = height - 1 - (int)(1800.0 / (double)limit);
            if (isOld) {
                this.m_93154_(poseStack, startX, startX + endX - 1, fpsLine, -65536);
            } else {
                this.m_93154_(poseStack, startX + 1, startX + endX - 2, fpsLine, -65536);
            }
        }
        if (isModern) {
            String maxed = max + " ms min";
            String average = avg / (long)endX + " ms avg";
            String minimum = min + " ms max";
            float f = startX + 2;
            Objects.requireNonNull(this.f_94031_);
            this.f_94031_.m_92750_(poseStack, maxed, f, (float)(height - 70 - 9), 0xFFFFFF);
            float f2 = startX + 2;
            Objects.requireNonNull(this.f_94031_);
            this.f_94031_.m_92750_(poseStack, average, f2, (float)(height - 60 - 9), 0xFFFFFF);
            float f3 = startX + 2;
            Objects.requireNonNull(this.f_94031_);
            this.f_94031_.m_92750_(poseStack, minimum, f3, (float)(height - 80 - 9), 0xFFFFFF);
        }
        RenderSystem.m_69482_();
        callback.cancel();
    }
}

