/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.client.renderer;

import java.util.List;
import java.util.Map;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.common.config.ModConfig;
import mod.adrenix.nostalgic.util.ModTracker;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ItemModelGenerator.class})
public abstract class ItemModelGeneratorMixin {
    private static float reduce(float start, float end, float delta) {
        return (start - delta * end) / (1.0f - delta);
    }

    private static void reduceUVs(float[] uvs, float delta) {
        float centerU = (uvs[0] + uvs[2]) / 2.0f;
        float centerV = (uvs[1] + uvs[3]) / 2.0f;
        uvs[0] = ItemModelGeneratorMixin.reduce(uvs[0], centerU, delta);
        uvs[1] = ItemModelGeneratorMixin.reduce(uvs[1], centerV, delta);
        uvs[2] = ItemModelGeneratorMixin.reduce(uvs[2], centerU, delta);
        uvs[3] = ItemModelGeneratorMixin.reduce(uvs[3], centerV, delta);
    }

    @Inject(method={"processFrames"}, at={@At(value="TAIL")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void NT$onProcessFrames(int tintIndex, String texture, TextureAtlasSprite sprite, CallbackInfoReturnable<List<BlockElement>> callback, Map<Direction, BlockElementFace> faceMap, List<BlockElement> blockElements) {
        try {
            if (!ModConfig.Candy.fixItemModelGaps()) {
                return;
            }
        }
        catch (Error error) {
            // empty catch block
        }
        boolean isForge = NostalgicTweaks.isForge() && !ModTracker.OPTIFINE.isInstalled();
        for (BlockElement element : blockElements) {
            for (BlockElementFace face : element.f_111310_.values()) {
                ItemModelGeneratorMixin.reduceUVs(face.f_111357_.f_111387_, sprite.m_118417_() + (isForge ? 0.00193f : 0.0f));
            }
        }
    }
}

