/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import mod.adrenix.nostalgic.common.config.ModConfig;
import mod.adrenix.nostalgic.common.config.tweak.TweakVersion;
import mod.adrenix.nostalgic.mixin.widen.LevelRendererAccessor;
import mod.adrenix.nostalgic.util.ModTracker;
import mod.adrenix.nostalgic.util.client.FogUtil;
import mod.adrenix.nostalgic.util.client.ItemClientUtil;
import mod.adrenix.nostalgic.util.client.RunUtil;
import mod.adrenix.nostalgic.util.client.WorldClientUtil;
import mod.adrenix.nostalgic.util.common.BlockCommonUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.PrioritizeChunkUpdates;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.ViewArea;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin {
    private static boolean isStarRunnableSaved = false;
    private static boolean isBlueRunnableSaved = false;
    @Shadow
    @Final
    private Minecraft f_109461_;
    @Shadow
    @Final
    private RenderBuffers f_109464_;
    @Unique
    @Nullable
    private VertexBuffer blueBuffer;
    @Shadow
    @Nullable
    private ViewArea f_109469_;
    @Shadow
    @Nullable
    private ClientLevel f_109465_;

    @Shadow
    protected abstract void m_109837_();

    @Unique
    private void NT$createBlueBuffer() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        if (this.blueBuffer != null) {
            this.blueBuffer.close();
        }
        float height = switch (ModConfig.Candy.getBlueVoid()) {
            default -> throw new IncompatibleClassChangeError();
            case TweakVersion.Generic.ALPHA -> -32.0f;
            case TweakVersion.Generic.BETA, TweakVersion.Generic.MODERN -> -48.0f;
        };
        this.blueBuffer = new VertexBuffer();
        BufferBuilder.RenderedBuffer renderedBuffer = WorldClientUtil.buildSkyDisc(builder, height);
        this.blueBuffer.m_85921_();
        this.blueBuffer.m_231221_(renderedBuffer);
        VertexBuffer.m_85931_();
    }

    @Inject(method={"<init>(Lnet/minecraft/client/Minecraft;Lnet/minecraft/client/renderer/entity/EntityRenderDispatcher;Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderDispatcher;Lnet/minecraft/client/renderer/RenderBuffers;)V"}, at={@At(value="TAIL")})
    private void NT$onInitLevelRenderer(Minecraft minecraft, EntityRenderDispatcher entityRenderDispatcher, BlockEntityRenderDispatcher blockEntityRenderDispatcher, RenderBuffers renderBuffers, CallbackInfo callback) {
        this.NT$createBlueBuffer();
        if (!isStarRunnableSaved) {
            isStarRunnableSaved = true;
            RunUtil.onSave.add(this::m_109837_);
        }
        if (!isBlueRunnableSaved) {
            isBlueRunnableSaved = true;
            RunUtil.onSave.add(this::NT$createBlueBuffer);
        }
    }

    @Inject(method={"renderSky"}, at={@At(value="HEAD")})
    private void NT$onCacheSkyPose(PoseStack poseStack, Matrix4f projectionMatrix, float partialTicks, Camera camera, boolean isFoggy, Runnable skyFogSetup, CallbackInfo callback) {
        WorldClientUtil.blueModelView = poseStack.m_85850_().m_85861_().m_27658_();
        WorldClientUtil.blueProjection = projectionMatrix.m_27658_();
    }

    @Inject(method={"renderSky"}, at={@At(ordinal=1, shift=At.Shift.AFTER, value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;popPose()V")})
    private void NT$onDrawSkyBuffer(PoseStack poseStack, Matrix4f projectionMatrix, float partialTicks, Camera camera, boolean isFoggy, Runnable skyFogSetup, CallbackInfo callback) {
        if (ModConfig.Candy.getBlueVoid() != TweakVersion.Generic.MODERN) {
            WorldClientUtil.setBlueVoidColor();
            ShaderInstance shader = RenderSystem.m_157196_();
            if (this.blueBuffer != null && shader != null) {
                this.blueBuffer.m_85921_();
                this.blueBuffer.m_166867_(WorldClientUtil.blueModelView, WorldClientUtil.blueProjection, shader);
                VertexBuffer.m_85931_();
            }
        }
    }

    @Redirect(method={"renderSky"}, at=@At(ordinal=2, value="INVOKE", target="Lcom/mojang/blaze3d/vertex/VertexBuffer;drawWithShader(Lcom/mojang/math/Matrix4f;Lcom/mojang/math/Matrix4f;Lnet/minecraft/client/renderer/ShaderInstance;)V"))
    private void NT$onRenderDarkVoid(VertexBuffer instance, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, ShaderInstance shaderInstance) {
        TweakVersion.Generic voidState = ModConfig.Candy.getBlueVoid();
        boolean isBlueRendered = voidState == TweakVersion.Generic.ALPHA || voidState == TweakVersion.Generic.BETA;
        boolean isBlueOverride = ModConfig.Candy.oldBlueVoidOverride();
        if (!isBlueRendered || !isBlueOverride) {
            float[] DARK_RGB = RenderSystem.m_157197_();
            float[] VOID_RGB = FogUtil.Void.getVoidRGB();
            FogUtil.Void.setVoidRGB(DARK_RGB[0], DARK_RGB[1], DARK_RGB[2]);
            if (FogUtil.Void.isRendering()) {
                RenderSystem.m_157429_((float)VOID_RGB[0], (float)VOID_RGB[1], (float)VOID_RGB[2], (float)DARK_RGB[3]);
            }
            instance.m_166867_(modelViewMatrix, projectionMatrix, shaderInstance);
        }
    }

    @ModifyArg(method={"renderSky"}, index=1, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(DDD)V"))
    private double NT$onTranslateDarkSkyBuffer(double y) {
        return ModConfig.Candy.oldDarkVoidHeight() ? y - Math.max(this.f_109461_.f_91063_.m_109153_().m_90583_().f_82480_ - 65.0, 0.0) : y;
    }

    @Redirect(method={"renderSky"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/DimensionSpecialEffects;getSunriseColor(FF)[F"))
    private float[] NT$onGetSunriseColor(DimensionSpecialEffects instance, float timeOfDay, float partialTicks) {
        return ModConfig.Candy.disableSunriseSunsetColor() ? null : instance.m_7518_(timeOfDay, partialTicks);
    }

    @Inject(method={"renderSky"}, at={@At(ordinal=1, shift=At.Shift.AFTER, value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderColor(FFFF)V")})
    private void NT$onSetSunriseColor(PoseStack poseStack, Matrix4f projectionMatrix, float partialTicks, Camera camera, boolean isFoggy, Runnable skyFogSetup, CallbackInfo callback) {
        FogUtil.Void.setCelestialTransparency();
    }

    @Inject(method={"renderSky"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getRainLevel(F)F"))}, at={@At(ordinal=0, shift=At.Shift.AFTER, value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderColor(FFFF)V")})
    private void NT$onSetSunMoonShading(PoseStack poseStack, Matrix4f projectionMatrix, float partialTicks, Camera camera, boolean isFoggy, Runnable skyFogSetup, CallbackInfo callback) {
        boolean isShort;
        FogUtil.Void.setCelestialTransparency();
        boolean isAlphaFog = ModConfig.Candy.getWorldFog() == TweakVersion.WorldFog.ALPHA_R164;
        boolean bl = isShort = this.f_109461_.f_91066_.m_193772_() <= 4;
        if (ModConfig.Candy.oldClassicLight() || isAlphaFog && isShort) {
            RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    private void NT$onStartLevelRendering(PoseStack poseStack, float partialTick, long finishNanoTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f projectionMatrix, CallbackInfo callback) {
        ItemClientUtil.levelPoseStack = poseStack.m_85850_();
        ItemClientUtil.levelBufferSource = this.f_109464_.m_110104_();
    }

    @ModifyArg(method={"renderSky"}, at=@At(value="INVOKE", ordinal=2, target="Lcom/mojang/math/Vector3f;rotationDegrees(F)Lcom/mojang/math/Quaternion;"))
    private float NT$onRenderSkyDiscColor(float vanilla) {
        return WorldClientUtil.getSunriseRotation(vanilla);
    }

    @ModifyArg(method={"renderSky"}, at=@At(value="INVOKE", ordinal=3, target="Lcom/mojang/math/Vector3f;rotationDegrees(F)Lcom/mojang/math/Quaternion;"))
    private float NT$onRenderSun(float vanilla) {
        return WorldClientUtil.getSunriseRotation(vanilla);
    }

    @ModifyConstant(method={"drawStars"}, constant={@Constant(floatValue=0.15f)})
    private float NT$onDrawStarsWidth(float vanilla) {
        return switch (ModConfig.Candy.getStars()) {
            case TweakVersion.Generic.ALPHA, TweakVersion.Generic.BETA -> 0.25f;
            default -> 0.15f;
        };
    }

    @ModifyConstant(method={"drawStars"}, constant={@Constant(floatValue=0.1f)})
    private float NT$onDrawStarsHeight(float vanilla) {
        return switch (ModConfig.Candy.getStars()) {
            case TweakVersion.Generic.ALPHA, TweakVersion.Generic.BETA -> 0.25f;
            default -> 0.1f;
        };
    }

    @Inject(method={"renderSky"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/FogRenderer;setupNoFog()V")})
    private void NT$onSetupStarColor(PoseStack poseStack, Matrix4f projectionMatrix, float partialTick, Camera camera, boolean isFoggy, Runnable skyFogSetup, CallbackInfo callback) {
        boolean isDimmed;
        TweakVersion.Generic stars = ModConfig.Candy.getStars();
        boolean bl = isDimmed = stars.equals(TweakVersion.Generic.MODERN) || stars.equals(TweakVersion.Generic.BETA);
        if (this.f_109465_ == null) {
            return;
        }
        float rain = 1.0f - this.f_109465_.m_46722_(partialTick);
        float transparency = this.f_109465_.m_104811_(partialTick) * rain;
        float color = isDimmed ? transparency : transparency / 0.5f;
        FogUtil.Void.setStarAlpha(transparency);
        if (FogUtil.Void.isRendering()) {
            transparency = FogUtil.Void.getStarAlpha();
        }
        RenderSystem.m_157429_((float)color, (float)color, (float)color, (float)transparency);
        if (ModConfig.Candy.getWorldFog() == TweakVersion.WorldFog.ALPHA_R164 && this.f_109461_.f_91066_.m_193772_() <= 4) {
            RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        }
    }

    @Inject(method={"renderHitOutline"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onRenderHitOutline(PoseStack poseStack, VertexConsumer consumer, Entity entity, double camX, double camY, double camZ, BlockPos pos, BlockState state, CallbackInfo callback) {
        boolean isFullOutline;
        Block block = state.m_60734_();
        boolean isOldChest = BlockCommonUtil.isOldChest(block);
        boolean isOldFence = ModConfig.Candy.oldFenceOutline() && (block instanceof FenceBlock || block instanceof FenceGateBlock);
        boolean isOldStair = ModConfig.Candy.oldStairOutline() && block instanceof StairBlock;
        boolean isOldSlab = ModConfig.Candy.oldSlabOutline() && block instanceof SlabBlock;
        boolean isOldWall = ModConfig.Candy.oldWallOutline() && block instanceof WallBlock;
        boolean isCustom = ModConfig.Candy.getFullOutlines().isItemInList(block.m_5456_());
        boolean bl = isFullOutline = isOldChest || isOldFence || isOldStair || isOldSlab || isOldWall || isCustom;
        if (!isFullOutline) {
            return;
        }
        LevelRendererAccessor.NT$renderShape(poseStack, consumer, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (double)pos.m_123341_() - camX, (double)pos.m_123342_() - camY, (double)pos.m_123343_() - camZ, 0.0f, 0.0f, 0.0f, 0.4f);
        callback.cancel();
    }

    @Redirect(method={"getLightColor(Lnet/minecraft/world/level/BlockAndTintGetter;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;)I"}, at=@At(ordinal=0, value="INVOKE", target="Lnet/minecraft/world/level/BlockAndTintGetter;getBrightness(Lnet/minecraft/world/level/LightLayer;Lnet/minecraft/core/BlockPos;)I"))
    private static int NT$onGetSkyLightColor(BlockAndTintGetter level, LightLayer layer, BlockPos pos) {
        if (ModConfig.Candy.oldLightRendering()) {
            return WorldClientUtil.getSyncedLight(level, pos);
        }
        if (ModConfig.Candy.oldWaterLighting() && BlockCommonUtil.isInWater(level, pos)) {
            return BlockCommonUtil.getWaterLightBlock(level, pos);
        }
        return level.m_45517_(layer, pos);
    }

    @Redirect(method={"getLightColor(Lnet/minecraft/world/level/BlockAndTintGetter;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;)I"}, at=@At(ordinal=1, value="INVOKE", target="Lnet/minecraft/world/level/BlockAndTintGetter;getBrightness(Lnet/minecraft/world/level/LightLayer;Lnet/minecraft/core/BlockPos;)I"))
    private static int NT$onGetBlockLightColor(BlockAndTintGetter level, LightLayer layer, BlockPos pos) {
        return ModConfig.Candy.oldLightRendering() ? WorldClientUtil.getSyncedLight(level, pos) : level.m_45517_(layer, pos);
    }

    @Inject(method={"compileChunks"}, at={@At(value="HEAD")})
    private void NT$onCompileChunks(Camera camera, CallbackInfo callback) {
        boolean isModReady = ModConfig.Candy.oldLightRendering() && WorldClientUtil.isRelightCheckEnqueued();
        boolean isSodium = ModTracker.SODIUM.isInstalled();
        if (isModReady && !isSodium && this.f_109469_ != null) {
            for (ChunkRenderDispatcher.RenderChunk chunk : this.f_109469_.f_110843_) {
                chunk.m_112828_(true);
            }
        }
    }

    @Redirect(method={"compileChunks"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/OptionInstance;get()Ljava/lang/Object;"))
    private <T> T NT$onCompilePriority(OptionInstance<PrioritizeChunkUpdates> instance) {
        return (T)(ModConfig.Candy.oldLightRendering() && !ModTracker.SODIUM.isInstalled() ? PrioritizeChunkUpdates.NONE : instance.m_231551_());
    }

    @Inject(method={"compileChunks"}, at={@At(value="RETURN")})
    private void NT$onFinishChunkCompilation(Camera camera, CallbackInfo callback) {
        if (WorldClientUtil.isRelightCheckEnqueued() && !ModTracker.SODIUM.isInstalled()) {
            WorldClientUtil.setRelightFinished();
        }
    }

    @Redirect(method={"levelEvent"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/BoneMealItem;addGrowthParticles(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;I)V"))
    private void NT$onGrowthParticlesLevelEvent(LevelAccessor level, BlockPos pos, int data) {
        if (ModConfig.Candy.disableGrowthParticles()) {
            return;
        }
        BoneMealItem.m_40638_((LevelAccessor)level, (BlockPos)pos, (int)data);
    }
}

