/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.client.renderer;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.math.Vector3f;
import mod.adrenix.nostalgic.common.config.ModConfig;
import mod.adrenix.nostalgic.util.client.WorldClientUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LightTexture.class})
public abstract class LightTextureMixin {
    @Shadow
    @Final
    private Minecraft f_109876_;
    @Shadow
    @Final
    private NativeImage f_109871_;
    @Shadow
    private float f_109874_;

    @Shadow
    protected abstract float m_234319_(float var1);

    @Shadow
    protected abstract float m_234312_(LivingEntity var1, float var2, float var3);

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void NT$onTick(CallbackInfo callback) {
        if (ModConfig.Candy.disableLightFlicker()) {
            this.f_109874_ = 0.0f;
        }
    }

    @ModifyConstant(method={"updateLightTexture"}, constant={@Constant(intValue=16)}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/client/renderer/LightTexture;blockLightRedFlicker:F"), to=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LightTexture;getBrightness(Lnet/minecraft/world/level/dimension/DimensionType;I)F"))})
    private int NT$onCreateLightmap(int vanilla) {
        if (ModConfig.Candy.oldClassicLight() || ModConfig.Candy.oldLightRendering()) {
            return 0;
        }
        return vanilla;
    }

    @Inject(method={"updateLightTexture"}, at={@At(shift=At.Shift.BEFORE, value="INVOKE", target="Lnet/minecraft/client/renderer/texture/DynamicTexture;upload()V")})
    private void NT$onUpdateLightTexture(float partialTicks, CallbackInfo callback) {
        ClientLevel level = this.f_109876_.f_91073_;
        if (level == null || this.f_109876_.f_91074_ == null) {
            return;
        }
        if (ModConfig.Candy.oldClassicLight()) {
            for (int y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    if (x == 15 || y == 15) {
                        this.f_109871_.m_84988_(x, y, -1);
                        continue;
                    }
                    this.f_109871_.m_84988_(x, y, -6710887);
                }
            }
            return;
        }
        if (!ModConfig.Candy.oldLightRendering() || !ModConfig.Candy.oldLightColor()) {
            return;
        }
        double gammaSetting = (Double)this.f_109876_.f_91066_.m_231927_().m_231551_();
        float darknessScale = ((Double)this.f_109876_.f_91066_.m_231926_().m_231551_()).floatValue();
        float darknessGamma = this.m_234319_(partialTicks) * darknessScale;
        float darknessEffect = this.m_234312_((LivingEntity)this.f_109876_.f_91074_, darknessGamma, partialTicks) * darknessScale;
        float darkenAmount = this.f_109876_.f_91063_.m_109131_(partialTicks);
        float waterVision = this.f_109876_.f_91074_.m_108639_();
        float potionEffect = this.f_109876_.f_91074_.m_21023_(MobEffects.f_19611_) ? GameRenderer.m_109108_((LivingEntity)this.f_109876_.f_91074_, (float)partialTicks) : (waterVision > 0.0f && this.f_109876_.f_91074_.m_21023_(MobEffects.f_19592_) ? waterVision : 0.0f);
        boolean isGammaDisabled = ModConfig.Candy.disableBrightness();
        boolean isFlashPresent = level.m_104819_() > 0 && (Boolean)this.f_109876_.f_91066_.m_231935_().m_231551_() == false;
        boolean isWorldDarkening = darkenAmount > 0.0f;
        float skyLightSubtracted = WorldClientUtil.getSkylightSubtracted(level);
        if (isFlashPresent) {
            skyLightSubtracted = 1.0f;
        } else if (isWorldDarkening) {
            skyLightSubtracted = (float)((double)skyLightSubtracted + Math.ceil(3.0f * darkenAmount));
            skyLightSubtracted = Mth.m_14036_((float)skyLightSubtracted, (float)1.0f, (float)15.0f);
        }
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                float fromBlockLight = WorldClientUtil.getOldBrightness(x);
                float fromSkyLight = WorldClientUtil.getOldBrightness((int)Math.max((float)y - skyLightSubtracted, 0.0f));
                if (level.m_46472_() == Level.f_46430_) {
                    fromSkyLight = 0.22f + fromSkyLight * 0.75f;
                }
                if (potionEffect > 0.0f) {
                    float shiftBrightness = potionEffect * 0.7f;
                    float adjustBlockColor = (1.0f - fromBlockLight - 0.5f) * (shiftBrightness * fromBlockLight) + 0.5f * potionEffect;
                    float skyAdjust = (1.0f - fromSkyLight - 0.5f) * (shiftBrightness * fromSkyLight) + 0.5f * potionEffect;
                    fromBlockLight += adjustBlockColor;
                    fromSkyLight += skyAdjust;
                }
                if (darknessEffect > 0.0f && x != 15) {
                    fromBlockLight -= darknessEffect;
                    fromSkyLight -= darknessEffect;
                    fromBlockLight = Mth.m_14036_((float)fromBlockLight, (float)0.025f, (float)1.0f);
                    fromSkyLight = Mth.m_14036_((float)fromSkyLight, (float)0.025f, (float)1.0f);
                }
                double gamma = isGammaDisabled ? 0.0 : gammaSetting;
                float blockLight = Mth.m_14036_((float)(fromBlockLight * 255.0f * ((float)gamma + 1.0f)), (float)6.375f, (float)255.0f);
                float skyLight = Mth.m_14036_((float)(fromSkyLight * 255.0f * ((float)gamma + 1.0f)), (float)6.375f, (float)255.0f);
                float light = fromBlockLight > fromSkyLight ? blockLight : skyLight;
                this.f_109871_.m_84988_(x, y, 0xFF000000 | (int)light << 16 | (int)light << 8 | (int)light);
            }
        }
    }

    @Redirect(method={"updateLightTexture"}, slice=@Slice(from=@At(value="INVOKE", target="Lcom/mojang/math/Vector3f;map(Lit/unimi/dsi/fastutil/floats/Float2FloatFunction;)V")), at=@At(value="INVOKE", target="Lcom/mojang/math/Vector3f;mul(F)V"))
    private void NT$onFinalizeColor(Vector3f rgb, float multiplier) {
        if (ModConfig.Candy.oldLightColor()) {
            float average = (rgb.m_122239_() + rgb.m_122260_() + rgb.m_122269_()) / 3.0f;
            rgb.m_122245_(average, average, average);
        }
        rgb.m_122261_(multiplier);
    }
}

