/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.client.renderer;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.NativeImage;
import dev.architectury.platform.Platform;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.common.config.ModConfig;
import mod.adrenix.nostalgic.common.config.tweak.TweakVersion;
import mod.adrenix.nostalgic.util.client.RunUtil;
import mod.adrenix.nostalgic.util.common.TextureLocation;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.AnimationFrame;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.LazyLoadedValue;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MissingTextureAtlasSprite.class})
public abstract class MissingTextureAtlasSpriteMixin {
    @Unique
    private static LazyLoadedValue<NativeImage> NT$MODERN_MISSING_IMAGE_DATA;
    @Unique
    private static TextureAtlasSprite.Info NT$MODERN_INFO;
    @Shadow
    @Final
    @Mutable
    private static LazyLoadedValue<NativeImage> f_118061_;
    @Shadow
    @Final
    @Mutable
    private static TextureAtlasSprite.Info f_118062_;
    @Shadow
    @Final
    private static ResourceLocation f_118059_;

    private static Optional<NativeImage> NT$getImage() throws Exception {
        String path = switch (ModConfig.Candy.oldMissingTexture()) {
            case TweakVersion.MissingTexture.BETA -> TextureLocation.MISSING_BETA;
            case TweakVersion.MissingTexture.R15 -> TextureLocation.MISSING_1_5;
            case TweakVersion.MissingTexture.R16_R112 -> TextureLocation.MISSING_1_6_1_12;
            default -> "";
        };
        Optional resource = Platform.getMod((String)"nostalgic_tweaks").findResource(new String[]{path});
        if (resource.isPresent()) {
            return Optional.of(NativeImage.m_85058_((InputStream)Files.newInputStream((Path)resource.get(), new OpenOption[0])));
        }
        return Optional.empty();
    }

    private static void NT$update() {
        Optional<Object> image = Optional.empty();
        if (ModConfig.Candy.oldMissingTexture() != TweakVersion.MissingTexture.MODERN) {
            try {
                image = MissingTextureAtlasSpriteMixin.NT$getImage();
            }
            catch (Exception exception) {
                NostalgicTweaks.LOGGER.error("Could not generate missing texture\n%s", exception);
            }
        }
        if (image.isPresent() && ModConfig.Candy.oldMissingTexture() != TweakVersion.MissingTexture.MODERN) {
            int textureSize = switch (ModConfig.Candy.oldMissingTexture()) {
                case TweakVersion.MissingTexture.BETA, TweakVersion.MissingTexture.R15 -> 64;
                default -> 16;
            };
            ImmutableList frames = ImmutableList.of((Object)new AnimationFrame(0, -1));
            AnimationMetadataSection section = new AnimationMetadataSection((List)frames, textureSize, textureSize, 1, false);
            f_118061_ = new LazyLoadedValue(image::get);
            f_118062_ = new TextureAtlasSprite.Info(f_118059_, textureSize, textureSize, section);
        } else {
            f_118061_ = NT$MODERN_MISSING_IMAGE_DATA;
            f_118062_ = NT$MODERN_INFO;
        }
    }

    @Inject(method={"<clinit>"}, at={@At(value="TAIL")})
    private static void NT$onStaticInit(CallbackInfo callback) {
        NT$MODERN_MISSING_IMAGE_DATA = f_118061_;
        NT$MODERN_INFO = f_118062_;
        MissingTextureAtlasSpriteMixin.NT$update();
        RunUtil.onSave.add(MissingTextureAtlasSpriteMixin::NT$update);
    }
}

