/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.client.world;

import com.mojang.blaze3d.systems.RenderSystem;
import mod.adrenix.nostalgic.common.config.ModConfig;
import mod.adrenix.nostalgic.common.config.tweak.TweakVersion;
import mod.adrenix.nostalgic.util.client.WorldClientUtil;
import mod.adrenix.nostalgic.util.common.ColorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Biome.class})
public abstract class BiomeMixin {
    @Shadow
    @Final
    private BiomeSpecialEffects f_47443_;

    private static boolean isNether() {
        return Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91073_.m_46472_() == Level.f_46429_;
    }

    private static boolean isOverworld() {
        return Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91073_.m_46472_() == Level.f_46428_;
    }

    @Inject(method={"getSkyColor"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onGetSkyColor(CallbackInfoReturnable<Integer> callback) {
        if (BiomeMixin.isOverworld()) {
            if (Minecraft.m_91087_().f_91066_.m_193772_() <= 4) {
                callback.setReturnValue((Object)ColorUtil.toIntFromRGBA(RenderSystem.m_157198_()));
                return;
            }
            TweakVersion.SkyColor skyColor = ModConfig.Candy.getUniversalSky();
            if (ModConfig.Candy.isWorldSkyCustom()) {
                callback.setReturnValue((Object)ColorUtil.toHexInt(ModConfig.Candy.getWorldSkyColor()));
            } else if (ModConfig.Candy.oldDynamicSkyColor()) {
                callback.setReturnValue((Object)WorldClientUtil.getSkyColorFromBiome());
            } else if (skyColor == TweakVersion.SkyColor.DISABLED) {
                callback.setReturnValue((Object)this.f_47443_.m_47978_());
            } else {
                switch (skyColor) {
                    case CLASSIC: {
                        callback.setReturnValue((Object)10276351);
                        break;
                    }
                    case INF_DEV: {
                        callback.setReturnValue((Object)13033215);
                        break;
                    }
                    case ALPHA: {
                        callback.setReturnValue((Object)9158143);
                        break;
                    }
                    case BETA: {
                        callback.setReturnValue((Object)9937919);
                    }
                }
            }
        } else if (BiomeMixin.isNether()) {
            if (ModConfig.Candy.isNetherSkyCustom()) {
                callback.setReturnValue((Object)ColorUtil.toHexInt(ModConfig.Candy.getNetherSkyColor()));
            } else if (ModConfig.Candy.oldNetherSky()) {
                callback.setReturnValue((Object)2163973);
            }
        }
    }
}

