/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.client.world;

import mod.adrenix.nostalgic.common.config.ModConfig;
import mod.adrenix.nostalgic.common.config.tweak.TweakVersion;
import mod.adrenix.nostalgic.util.client.BlockClientUtil;
import mod.adrenix.nostalgic.util.client.FogUtil;
import mod.adrenix.nostalgic.util.common.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientLevel.class})
public abstract class ClientLevelMixin {
    @Shadow
    @Final
    private Minecraft f_104565_;

    @Shadow
    public abstract void m_7785_(double var1, double var3, double var5, SoundEvent var7, SoundSource var8, float var9, float var10, boolean var11);

    @Redirect(method={"getShade"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/DimensionSpecialEffects;constantAmbientLight()Z"))
    private boolean NT$onGetNetherShade(DimensionSpecialEffects instance) {
        if (ModConfig.Candy.oldNetherLighting() && Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91073_.m_46472_() == Level.f_46429_) {
            return false;
        }
        return instance.m_108885_();
    }

    @ModifyArg(method={"getSkyColor"}, index=1, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;clamp(FFF)F"))
    private float NT$onClampSkyColor(float vanilla) {
        return switch (ModConfig.Candy.getStars()) {
            case TweakVersion.Generic.ALPHA, TweakVersion.Generic.BETA -> 0.005f;
            default -> vanilla;
        };
    }

    @ModifyArg(method={"getSkyColor"}, index=0, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;<init>(DDD)V"))
    private double NT$onSetSkyColorRed(double red) {
        FogUtil.Void.setSkyRed((float)red);
        return FogUtil.Void.isRendering() ? (double)FogUtil.Void.getSkyRed() : red;
    }

    @ModifyArg(method={"getSkyColor"}, index=1, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;<init>(DDD)V"))
    private double NT$onSetSkyColorGreen(double green) {
        FogUtil.Void.setSkyGreen((float)green);
        return FogUtil.Void.isRendering() ? (double)FogUtil.Void.getSkyGreen() : green;
    }

    @ModifyArg(method={"getSkyColor"}, index=2, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;<init>(DDD)V"))
    private double NT$onSetSkyColorBlue(double blue) {
        FogUtil.Void.setSkyBlue((float)blue);
        return FogUtil.Void.isRendering() ? (double)FogUtil.Void.getSkyBlue() : blue;
    }

    @Inject(method={"addParticle(Lnet/minecraft/core/particles/ParticleOptions;ZDDDDDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onAddParticle(ParticleOptions options, boolean alwaysRender, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, CallbackInfo callback) {
        boolean isParticleAtPlayer;
        boolean isSprinting;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        boolean isDisabled = ModConfig.Candy.disableFallingParticles() && options.m_6012_().equals(ParticleTypes.f_123794_);
        boolean bl = isSprinting = player != null && player.m_5843_();
        if (!isDisabled || isSprinting || player == null) {
            return;
        }
        boolean bl2 = isParticleAtPlayer = MathUtil.tolerance(player.m_20185_(), x, (double)0.01f) && MathUtil.tolerance(player.m_20186_(), y, (double)0.01f) && MathUtil.tolerance(player.m_20189_(), z, (double)0.01f);
        if (isParticleAtPlayer) {
            callback.cancel();
        }
    }

    @Inject(method={"doAnimateTick"}, at={@At(shift=At.Shift.BEFORE, value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getBiome(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/core/Holder;")})
    private void NT$onAddBiomeParticles(int x, int y, int z, int randomBound, RandomSource randomSource, Block block, BlockPos.MutableBlockPos blockPos, CallbackInfo callback) {
        BlockPos randY;
        BlockPos randX;
        BlockPos randomPos;
        BlockState state;
        boolean isDisabled;
        Player player;
        Entity entity = Minecraft.m_91087_().m_91288_();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        boolean isFogDisabled = ModConfig.Candy.disableVoidFog() || !FogUtil.Void.isBelowHorizon();
        boolean isCreativeDisabled = !ModConfig.Candy.creativeVoidParticles() && entity instanceof Player && (player = (Player)entity).m_7500_();
        boolean bl = isDisabled = isFogDisabled || isCreativeDisabled;
        if (isDisabled || entity == null || level == null) {
            return;
        }
        BlockPos playerPos = entity.m_20183_();
        int radius = ModConfig.Candy.getVoidParticleRadius();
        int particleStart = ModConfig.Candy.getVoidParticleStart();
        float density = (float)ModConfig.Candy.getVoidParticleDensity() / 100.0f;
        float yLevel = (float)FogUtil.Void.getYLevel(entity);
        if (Math.random() <= (double)density && yLevel <= (float)particleStart && level.m_46472_().equals(Level.f_46428_) && (state = level.m_8055_(randomPos = (randX = BlockClientUtil.getRandomPos(randomSource, radius)).m_121996_((Vec3i)(randY = BlockClientUtil.getRandomPos(randomSource, radius))).m_121955_((Vec3i)playerPos))).m_60795_() && level.m_6425_(randomPos).m_76178_() && randomPos.m_123342_() - level.m_141937_() <= particleStart && randomSource.m_188503_(8) <= particleStart) {
            boolean nearBedrock = BlockClientUtil.isNearBedrock(randomPos, (Level)level);
            level.m_7106_((ParticleOptions)(nearBedrock ? ParticleTypes.f_123783_ : ParticleTypes.f_123757_), (double)((float)randomPos.m_123341_() + randomSource.m_188501_()), (double)((float)randomPos.m_123342_() + randomSource.m_188501_()), (double)((float)randomPos.m_123343_() + randomSource.m_188501_()), 0.0, nearBedrock ? (double)randomSource.m_188501_() : 0.0, 0.0);
        }
    }

    @Inject(method={"playSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onPlaySimpleSound(double x, double y, double z, SoundEvent sound, SoundSource category, float volume, float pitch, boolean delayed, long seed, CallbackInfo callback) {
        boolean isSwimOff;
        boolean isGrowthOff = ModConfig.Sound.disableGrowth() && sound == SoundEvents.f_144074_;
        boolean bl = isSwimOff = ModConfig.Sound.disableGenericSwim() && sound == SoundEvents.f_11918_ || sound == SoundEvents.f_12279_;
        if (isGrowthOff || isSwimOff) {
            callback.cancel();
        }
    }

    @Inject(method={"playSeededSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FFJ)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onPlayPositionedSound(Player player, double x, double y, double z, SoundEvent sound, SoundSource category, float volume, float pitch, long seed, CallbackInfo callback) {
        boolean isEntityStep;
        boolean isFishDeath;
        boolean isFishHurt;
        boolean isGlowSquid;
        boolean isSquid;
        boolean isAttack;
        boolean bl = isAttack = sound == SoundEvents.f_12314_ || sound == SoundEvents.f_12313_ || sound == SoundEvents.f_12315_ || sound == SoundEvents.f_12316_ || sound == SoundEvents.f_12317_ || sound == SoundEvents.f_12318_;
        if (ModConfig.Sound.oldAttack() && isAttack) {
            callback.cancel();
            return;
        }
        boolean bl2 = isSquid = sound == SoundEvents.f_12438_ || sound == SoundEvents.f_12439_ || sound == SoundEvents.f_12440_ || sound == SoundEvents.f_12441_;
        if (ModConfig.Sound.disableSquid() && isSquid) {
            callback.cancel();
            return;
        }
        boolean bl3 = isGlowSquid = sound == SoundEvents.f_144160_ || sound == SoundEvents.f_144161_ || sound == SoundEvents.f_144162_;
        if (ModConfig.Sound.disableGlowSquidOther() && isGlowSquid) {
            callback.cancel();
            return;
        }
        if (ModConfig.Sound.disableGlowSquidAmbience() && sound == SoundEvents.f_144159_) {
            callback.cancel();
            return;
        }
        if (ModConfig.Sound.disableFishSwim() && sound == SoundEvents.f_11938_) {
            callback.cancel();
            return;
        }
        boolean bl4 = isFishHurt = sound == SoundEvents.f_11761_ || sound == SoundEvents.f_12294_ || sound == SoundEvents.f_12330_ || sound == SoundEvents.f_215761_ || sound == SoundEvents.f_12529_;
        if (ModConfig.Sound.disableFishHurt() && isFishHurt) {
            callback.cancel();
            return;
        }
        boolean bl5 = isFishDeath = sound == SoundEvents.f_11759_ || sound == SoundEvents.f_12292_ || sound == SoundEvents.f_12328_ || sound == SoundEvents.f_215758_ || sound == SoundEvents.f_12527_;
        if (ModConfig.Sound.disableFishDeath() && isFishDeath) {
            callback.cancel();
            return;
        }
        BlockPos pos = new BlockPos(x, y, z);
        ClientLevel level = this.f_104565_.f_91073_;
        if (level == null) {
            return;
        }
        BlockState state = level.m_8055_(pos);
        boolean isWoodChestSound = sound == SoundEvents.f_11749_ || sound == SoundEvents.f_11747_;
        boolean isEnderChestSound = sound == SoundEvents.f_11889_ || sound == SoundEvents.f_11888_;
        boolean isChestDisabled = false;
        if (ModConfig.Sound.disableChest() && state.m_60713_(Blocks.f_50087_) && isWoodChestSound) {
            isChestDisabled = true;
        } else if (ModConfig.Sound.disableEnderChest() && state.m_60713_(Blocks.f_50265_) && isEnderChestSound) {
            isChestDisabled = true;
        } else if (ModConfig.Sound.disableTrappedChest() && state.m_60713_(Blocks.f_50325_) && isWoodChestSound) {
            isChestDisabled = true;
        }
        if (isChestDisabled) {
            callback.cancel();
            return;
        }
        boolean isOldChest = false;
        if (ModConfig.Sound.oldChest() && state.m_60713_(Blocks.f_50087_) && isWoodChestSound) {
            isOldChest = true;
        } else if (ModConfig.Sound.oldChest() && state.m_60713_(Blocks.f_50265_) && isEnderChestSound) {
            isOldChest = true;
        } else if (ModConfig.Sound.oldChest() && state.m_60713_(Blocks.f_50325_) && isWoodChestSound) {
            isOldChest = true;
        }
        if (isOldChest && Minecraft.m_91087_().f_91073_ != null) {
            SoundEvent chestSound = SoundEvents.f_12627_;
            if (sound == SoundEvents.f_11747_ || sound == SoundEvents.f_11888_) {
                chestSound = SoundEvents.f_12626_;
            }
            RandomSource randomSource = Minecraft.m_91087_().f_91073_.f_46441_;
            this.m_7785_(x, y, z, chestSound, SoundSource.BLOCKS, 1.0f, randomSource.m_188501_() * 0.1f + 0.9f, false);
            callback.cancel();
            return;
        }
        boolean isBlockedSound = false;
        if (ModConfig.Sound.disableDoor() && state.m_60734_() instanceof DoorBlock) {
            isBlockedSound = true;
        } else if (ModConfig.Sound.disableBed() && state.m_60734_() instanceof BedBlock) {
            isBlockedSound = true;
        }
        if (isBlockedSound) {
            callback.cancel();
            return;
        }
        boolean bl6 = isEntityStep = sound.m_11660_().m_135815_().contains("entity.") && sound.m_11660_().m_135815_().contains(".step");
        if (ModConfig.Sound.oldStep() && !Minecraft.m_91087_().m_91091_() && isEntityStep) {
            boolean isModdedIgnored;
            Entity entity = null;
            for (Entity next : level.m_104735_()) {
                if (next instanceof ItemEntity) continue;
                boolean isX = MathUtil.tolerance((int)next.m_20185_(), (int)x);
                boolean isY = MathUtil.tolerance((int)next.m_20186_(), (int)y);
                boolean isZ = MathUtil.tolerance((int)next.m_20189_(), (int)z);
                if (!isX || !isY || !isZ) continue;
                entity = next;
                break;
            }
            if (entity == null) {
                return;
            }
            boolean isMinecraftEntity = entity.m_6095_().m_20675_().contains("minecraft");
            boolean isEntityIgnored = entity instanceof Spider || entity instanceof Silverfish;
            boolean bl7 = isModdedIgnored = ModConfig.Sound.ignoreModdedStep() && !isMinecraftEntity;
            if (isEntityIgnored) {
                callback.cancel();
            } else if (!isModdedIgnored) {
                BlockState standing = level.m_8055_(pos.m_7495_());
                if (standing.m_60767_().m_76332_()) {
                    return;
                }
                if (standing.m_60713_(Blocks.f_50016_)) {
                    callback.cancel();
                    return;
                }
                BlockState inside = level.m_8055_(pos);
                SoundType soundType = inside.m_204336_(BlockTags.f_144271_) ? inside.m_60827_() : standing.m_60827_();
                this.m_7785_(x, y, z, soundType.m_56776_(), entity.m_5720_(), soundType.m_56773_() * 0.15f, soundType.m_56774_(), false);
                callback.cancel();
            }
        }
    }
}

