/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.client.world.entity;

import java.util.Objects;
import mod.adrenix.nostalgic.client.config.SwingConfig;
import mod.adrenix.nostalgic.common.config.ModConfig;
import mod.adrenix.nostalgic.mixin.duck.CameraPitching;
import mod.adrenix.nostalgic.util.client.AnimationUtil;
import mod.adrenix.nostalgic.util.common.SoundUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements CameraPitching {
    @Unique
    private float NT$cameraPitch = 0.0f;
    @Unique
    public float NT$prevCameraPitch = 0.0f;

    @Shadow
    public abstract void m_6858_(boolean var1);

    private LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public void NT$setCameraPitch(float cameraPitch) {
        this.NT$cameraPitch = cameraPitch;
    }

    @Override
    public void NT$setPrevCameraPitch(float prevCameraPitch) {
        this.NT$prevCameraPitch = prevCameraPitch;
    }

    @Override
    public float NT$getCameraPitch() {
        return this.NT$cameraPitch;
    }

    @Override
    public float NT$getPrevCameraPitch() {
        return this.NT$prevCameraPitch;
    }

    @Inject(method={"getCurrentSwingDuration"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onGetCurrentSwingDuration(CallbackInfoReturnable<Integer> callback) {
        Player entity;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (SwingConfig.isOverridingSpeeds() || player == null) {
            return;
        }
        if (!(this.m_6095_() != EntityType.f_20532_ || (entity = (Player)this.m_6095_().m_141992_((Entity)this)) != null && entity.m_7578_())) {
            return;
        }
        if (ModConfig.Animation.oldClassicSwing()) {
            switch (AnimationUtil.swingType) {
                case LEFT_CLICK: {
                    callback.setReturnValue((Object)7);
                    break;
                }
                case RIGHT_CLICK: {
                    callback.setReturnValue((Object)3);
                }
            }
            return;
        }
        int speed = SwingConfig.getSwingSpeed((AbstractClientPlayer)player);
        if (SwingConfig.isSpeedGlobal()) {
            callback.setReturnValue((Object)SwingConfig.getSwingSpeed());
        } else if (SwingConfig.isOverridingHaste() && player.m_21023_(MobEffects.f_19598_)) {
            callback.setReturnValue((Object)SwingConfig.getHasteSpeed());
        } else if (SwingConfig.isOverridingFatigue() && player.m_21023_(MobEffects.f_19599_)) {
            callback.setReturnValue((Object)SwingConfig.getFatigueSpeed());
        } else if (MobEffectUtil.m_19584_((LivingEntity)player)) {
            callback.setReturnValue((Object)(speed - (1 + MobEffectUtil.m_19586_((LivingEntity)player))));
        } else {
            callback.setReturnValue((Object)(player.m_21023_(MobEffects.f_19599_) ? speed + (1 + Objects.requireNonNull(player.m_21124_(MobEffects.f_19599_)).m_19564_()) * 2 : speed));
        }
    }

    @Inject(method={"breakItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onBreakItem(ItemStack itemStack, CallbackInfo callback) {
        if (ModConfig.Animation.oldToolExplosion()) {
            callback.cancel();
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="FIELD", ordinal=0, target="Lnet/minecraft/world/entity/LivingEntity;hurtTime:I")})
    private void NT$onBaseTickHurtTime(CallbackInfo callback) {
        this.NT$setPrevCameraPitch(this.NT$getCameraPitch());
    }

    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    private void NT$onBaseTickStart(CallbackInfo callback) {
        if (ModConfig.Gameplay.disableSprint() && !ModConfig.Gameplay.disableSwim() && this.m_6095_() == EntityType.f_20532_) {
            boolean isOverride;
            Player entity = (Player)this.m_6095_().m_141992_((Entity)this);
            boolean isInvalidEntity = entity == null || !entity.m_7578_();
            boolean bl = isOverride = entity != null && (entity.m_7500_() || entity.m_5833_());
            if (this.m_20142_() && !this.m_5842_() && !isInvalidEntity && !isOverride) {
                this.m_6858_(false);
            }
        }
    }

    @Inject(method={"getFallDamageSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onGetFallDamageSound(int height, CallbackInfoReturnable<SoundEvent> callback) {
        if (ModConfig.Sound.oldFall()) {
            callback.setReturnValue((Object)SoundUtil.Event.BLANK.get());
        }
    }

    @ModifyVariable(method={"setSprinting"}, at=@At(value="HEAD"), argsOnly=true)
    private boolean NT$onSetSprinting(boolean vanilla) {
        if (!ModConfig.Gameplay.disableSprint() && !ModConfig.Gameplay.disableSwim()) {
            return vanilla;
        }
        if (this.m_6095_() == EntityType.f_20532_) {
            boolean isOverride;
            Player entity = (Player)this.m_6095_().m_141992_((Entity)this);
            boolean isInvalidEntity = entity == null || !entity.m_7578_();
            boolean bl = isOverride = entity != null && (entity.m_7500_() || entity.m_5833_());
            if (isInvalidEntity || isOverride) {
                return vanilla;
            }
            if (entity.m_5842_() && ModConfig.Gameplay.disableSwim()) {
                return false;
            }
            if (!entity.m_5842_() && ModConfig.Gameplay.disableSprint()) {
                return false;
            }
        }
        return vanilla;
    }
}

