/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.common.world;

import java.util.Map;
import mod.adrenix.nostalgic.common.config.ModConfig;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FoodData.class})
public abstract class FoodDataMixin {
    @Unique
    private Player NT$player = null;

    @Shadow
    public abstract void m_38707_(int var1, float var2);

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onTick(Player player, CallbackInfo callback) {
        if (this.NT$player == null || this.NT$player != player) {
            this.NT$player = player;
        }
        if (ModConfig.Gameplay.disableHunger()) {
            callback.cancel();
        }
    }

    @Inject(method={"eat(IF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onEat(int foodLevelModifier, float saturationLevelModifier, CallbackInfo callback) {
        if (ModConfig.Gameplay.disableHunger() && this.NT$player != null) {
            this.NT$player.m_5634_((float)foodLevelModifier);
            callback.cancel();
        }
    }

    @Inject(method={"eat(Lnet/minecraft/world/item/Item;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onEatItem(Item item, ItemStack itemStack, CallbackInfo callback) {
        boolean isFood;
        FoodProperties properties = item.m_41473_();
        boolean bl = isFood = item.m_41472_() && properties != null;
        if (ModConfig.Gameplay.disableHunger() && isFood) {
            Map.Entry<String, Integer> entry = ModConfig.Gameplay.getFoodHealth().getEntryFromItem(item);
            int nutrition = entry != null ? entry.getValue().intValue() : properties.m_38744_();
            this.m_38707_(nutrition, properties.m_38745_());
            callback.cancel();
        }
    }

    @Inject(method={"getFoodLevel"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onGetFoodLevel(CallbackInfoReturnable<Integer> callback) {
        if (ModConfig.Gameplay.disableHunger()) {
            callback.setReturnValue((Object)20);
        }
    }

    @Inject(method={"getLastFoodLevel"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onGetLastFoodLevel(CallbackInfoReturnable<Integer> callback) {
        if (ModConfig.Gameplay.disableHunger()) {
            callback.setReturnValue((Object)20);
        }
    }

    @Inject(method={"needsFood"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onNeedsFood(CallbackInfoReturnable<Boolean> callback) {
        if (ModConfig.Gameplay.disableHunger() && this.NT$player != null) {
            callback.setReturnValue((Object)(this.NT$player.m_21223_() < this.NT$player.m_21233_() ? 1 : 0));
        }
    }

    @Inject(method={"addExhaustion"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onAddExhaustion(float exhaustion, CallbackInfo callback) {
        if (ModConfig.Gameplay.disableHunger()) {
            callback.cancel();
        }
    }

    @Inject(method={"getExhaustionLevel"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onGetExhaustionLevel(CallbackInfoReturnable<Float> callback) {
        if (ModConfig.Gameplay.disableHunger()) {
            callback.setReturnValue((Object)Float.valueOf(0.0f));
        }
    }

    @Inject(method={"getSaturationLevel"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onGetSaturationLevel(CallbackInfoReturnable<Float> callback) {
        if (ModConfig.Gameplay.disableHunger()) {
            callback.setReturnValue((Object)Float.valueOf(20.0f));
        }
    }

    @Inject(method={"setFoodLevel"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onSetFoodLevel(int foodLevel, CallbackInfo callback) {
        if (ModConfig.Gameplay.disableHunger()) {
            callback.cancel();
        }
    }

    @Inject(method={"setSaturation"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onSetSaturation(float saturationLevel, CallbackInfo callback) {
        if (ModConfig.Gameplay.disableHunger()) {
            callback.cancel();
        }
    }

    @Inject(method={"setExhaustion"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onSetExhaustion(float exhaustionLevel, CallbackInfo callback) {
        if (ModConfig.Gameplay.disableHunger()) {
            callback.cancel();
        }
    }
}

