/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.common.world.entity;

import mod.adrenix.nostalgic.common.config.ModConfig;
import mod.adrenix.nostalgic.mixin.widen.SheepAccessor;
import mod.adrenix.nostalgic.network.packet.PacketS2CHurtDirection;
import mod.adrenix.nostalgic.util.common.PacketUtil;
import mod.adrenix.nostalgic.util.server.ItemServerUtil;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    public float f_20918_;

    private LivingEntityMixin(EntityType<?> entity, Level level) {
        super(entity, level);
    }

    @Inject(method={"hurt"}, at={@At(value="TAIL")})
    private void NT$onHurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> callback) {
        LivingEntity living = (LivingEntity)this;
        if (ModConfig.Animation.oldDirectionTilt() && living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            PacketUtil.sendToPlayer(player, new PacketS2CHurtDirection(this.f_20918_));
        }
    }

    @Redirect(method={"eat"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V"))
    private void NT$onEat(Level instance, Player player, double x, double y, double z, SoundEvent sound, SoundSource category, float volume, float pitch) {
        if (ModConfig.Gameplay.instantEat()) {
            return;
        }
        instance.m_6263_(player, x, y, z, sound, category, volume, pitch);
    }

    @Inject(method={"triggerItemUseEffects"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onAddEatEffect(ItemStack itemStack, int count, CallbackInfo callback) {
        if (ModConfig.Gameplay.instantEat() && itemStack.m_41780_() == UseAnim.EAT) {
            callback.cancel();
        }
    }

    @ModifyConstant(method={"tick"}, slice={@Slice(to=@At(value="FIELD", target="Lnet/minecraft/world/entity/LivingEntity;attackAnim:F"))}, constant={@Constant(floatValue=180.0f)})
    private float NT$onBackwardsRotation(float vanilla) {
        return ModConfig.Animation.oldBackwardsWalking() ? 0.0f : vanilla;
    }

    @Inject(method={"increaseAirSupply"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onIncreaseAirSupply(int currentAir, CallbackInfoReturnable<Integer> callback) {
        if (ModConfig.Gameplay.instantAir()) {
            callback.setReturnValue((Object)this.m_6062_());
        }
    }

    @Inject(cancellable=true, method={"addEatEffect"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodProperties;getEffects()Ljava/util/List;")})
    private void NT$onAddEatEffect(ItemStack itemStack, Level level, LivingEntity entity, CallbackInfo callback) {
        boolean isEffectOverride;
        if (!ModConfig.Gameplay.disableHunger()) {
            return;
        }
        Item item = itemStack.m_41720_();
        boolean isRotten = item.equals(Items.f_42583_);
        boolean isGolden = item.equals(Items.f_42436_);
        boolean bl = isEffectOverride = isRotten || isGolden;
        if (isRotten) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100, 0));
        }
        if (isEffectOverride) {
            callback.cancel();
        }
    }

    @Inject(method={"dropFromLootTable"}, at={@At(value="HEAD")})
    private void NT$onStartDropFromLootTable(DamageSource damageSource, boolean hitByPlayer, CallbackInfo callback) {
        ItemServerUtil.isDroppingLoot = true;
    }

    @Inject(method={"dropFromLootTable"}, at={@At(value="TAIL")})
    private void NT$onEndDropFromLootTable(DamageSource damageSource, boolean hitByPlayer, CallbackInfo callback) {
        ItemServerUtil.isDroppingLoot = false;
    }

    @Inject(method={"dropFromLootTable"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onDropFromLootTable(DamageSource damageSource, boolean hitByPlayer, CallbackInfo callback) {
        boolean isZombie;
        Entity entity = damageSource.m_7639_();
        EntityType type = this.m_6095_();
        int luck = hitByPlayer && entity != null ? EnchantmentHelper.m_44930_((LivingEntity)((LivingEntity)entity)) : 0;
        int zeroToTwo = this.f_19796_.m_188503_(3) + luck;
        int zeroToOne = this.f_19796_.m_188503_(2) + luck;
        boolean isZombiePigmen = ModConfig.Gameplay.oldZombiePigmenDrops() && type == EntityType.f_20531_;
        boolean isSkeleton = ModConfig.Gameplay.oldSkeletonDrops() && type == EntityType.f_20524_;
        boolean isChicken = ModConfig.Gameplay.oldChickenDrops() && type == EntityType.f_20555_;
        boolean isRabbit = ModConfig.Gameplay.oldRabbitDrops() && type == EntityType.f_20517_;
        boolean isSheep = ModConfig.Gameplay.oldSheepDrops() && type == EntityType.f_20520_;
        boolean isStray = ModConfig.Gameplay.oldStrayDrops() && type == EntityType.f_20481_;
        boolean isPig = ModConfig.Gameplay.oldPigDrops() && type == EntityType.f_20510_;
        boolean isCow = ModConfig.Gameplay.oldCowDrops() && type == EntityType.f_20557_ || ModConfig.Gameplay.oldMooshroomDrops() && type == EntityType.f_20504_;
        boolean isSpider = ModConfig.Gameplay.oldSpiderDrops() && type == EntityType.f_20479_ || ModConfig.Gameplay.oldCaveSpiderDrops() && type == EntityType.f_20554_;
        boolean bl = isZombie = ModConfig.Gameplay.oldZombieDrops() && type == EntityType.f_20501_ || ModConfig.Gameplay.oldZombieVillagerDrops() && type == EntityType.f_20530_ || ModConfig.Gameplay.oldDrownedDrops() && type == EntityType.f_20562_ || ModConfig.Gameplay.oldHuskDrops() && type == EntityType.f_20458_;
        if (isZombiePigmen) {
            ItemServerUtil.splitLoot(callback, this, new ItemStack((ItemLike)Items.f_42486_, zeroToTwo));
        } else if (isChicken) {
            ItemServerUtil.splitLoot(callback, this, new ItemStack((ItemLike)Items.f_42402_, zeroToTwo));
        } else if (isRabbit) {
            ItemServerUtil.splitLoot(callback, this, new ItemStack((ItemLike)Items.f_42649_, zeroToOne));
        } else if (isCow) {
            ItemServerUtil.splitLoot(callback, this, new ItemStack((ItemLike)Items.f_42454_, zeroToTwo));
        } else if (isSpider) {
            ItemServerUtil.splitLoot(callback, this, new ItemStack((ItemLike)Items.f_42401_, zeroToTwo));
        } else if (isZombie) {
            ItemServerUtil.splitLoot(callback, this, new ItemStack((ItemLike)Items.f_42402_, zeroToTwo));
        } else if (isSkeleton || isStray) {
            ItemServerUtil.splitLoot(callback, this, new ItemStack((ItemLike)Items.f_42412_, this.f_19796_.m_188503_(3) + luck));
            ItemServerUtil.splitLoot(callback, this, new ItemStack((ItemLike)Items.f_42500_, this.f_19796_.m_188503_(3) + luck));
        } else if (isPig) {
            Item item = this.m_6060_() ? Items.f_42486_ : Items.f_42485_;
            ItemServerUtil.splitLoot(callback, this, new ItemStack((ItemLike)item, zeroToTwo));
        } else if (isSheep) {
            if (!ModConfig.Gameplay.oldSheepPunching()) {
                Sheep sheep = (Sheep)type.m_141992_((Entity)this);
                ItemLike item = SheepAccessor.NT$ITEM_BY_DYE().get(sheep.m_29874_());
                if (!sheep.m_29875_()) {
                    ItemServerUtil.splitLoot(callback, this, new ItemStack(item, 1 + luck));
                }
            }
            callback.cancel();
        }
    }
}

