/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.common.world.entity.animal;

import mod.adrenix.nostalgic.common.config.ModConfig;
import mod.adrenix.nostalgic.mixin.widen.MobAccessor;
import mod.adrenix.nostalgic.mixin.widen.SheepAccessor;
import mod.adrenix.nostalgic.util.common.WorldCommonUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Animal.class})
public abstract class AnimalMixin
extends Mob {
    private AnimalMixin(EntityType<? extends Mob> type, Level level) {
        super(type, level);
    }

    @Inject(method={"removeWhenFarAway"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onRemoveWhenFarAway(double distanceToClosestPlayer, CallbackInfoReturnable<Boolean> callback) {
        boolean isLeashed = ((MobAccessor)((Object)this)).NT$getCompoundTag() != null || this.m_21523_();
        boolean isSaddled = false;
        boolean isTamed = false;
        AnimalMixin animalMixin = this;
        if (animalMixin instanceof Saddleable) {
            Saddleable saddleable = (Saddleable)animalMixin;
            isSaddled = saddleable.m_6254_();
        }
        if ((animalMixin = (Animal)this) instanceof TamableAnimal) {
            TamableAnimal tamable = (TamableAnimal)animalMixin;
            isTamed = tamable.m_21824_();
        }
        if (ModConfig.Gameplay.oldAnimalSpawning() && !isLeashed && !isSaddled && !isTamed) {
            callback.setReturnValue((Object)true);
        }
    }

    @Inject(method={"isBrightEnoughToSpawn"}, at={@At(value="HEAD")}, cancellable=true)
    private static void NT$onIsBrightEnoughToSpawn(BlockAndTintGetter level, BlockPos pos, CallbackInfoReturnable<Boolean> callback) {
        if (ModConfig.Gameplay.oldAnimalSpawning()) {
            int skyLight = WorldCommonUtil.getDynamicSkylight((LevelAccessor)level);
            int blockLight = level.m_45517_(LightLayer.BLOCK, pos);
            callback.setReturnValue((Object)(skyLight > 8 || blockLight > 8 ? 1 : 0));
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")})
    private void NT$onHurt(DamageSource damageSource, float amount, CallbackInfoReturnable<Boolean> callback) {
        Animal animal;
        if (ModConfig.Gameplay.oldSheepPunching() && (animal = (Animal)this) instanceof Sheep) {
            boolean canShearSheep;
            Sheep sheep = (Sheep)animal;
            boolean isHurtByPlayer = damageSource.m_7639_() instanceof Player;
            boolean bl = canShearSheep = sheep.m_6220_() && !this.f_19853_.f_46443_;
            if (!isHurtByPlayer || !canShearSheep) {
                return;
            }
            sheep.m_29878_(true);
            int cap = ModConfig.Gameplay.oneWoolPunch() ? 1 : 1 + this.f_19796_.m_188503_(3);
            for (int i = 0; i < cap; ++i) {
                ItemEntity entity = sheep.m_20000_(SheepAccessor.NT$ITEM_BY_DYE().get(sheep.m_29874_()), 1);
                if (entity == null) continue;
                double x = (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f;
                double y = this.f_19796_.m_188501_() * 0.05f;
                double z = (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f;
                entity.m_20256_(entity.m_20184_().m_82520_(x, y, z));
            }
        }
    }
}

