/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.common.world.level;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import mod.adrenix.nostalgic.common.config.ModConfig;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Explosion.class})
public abstract class ExplosionMixin {
    @Shadow
    public float f_46017_;
    @Shadow
    @Final
    private Level f_46012_;
    @Shadow
    @Final
    private double f_46013_;
    @Shadow
    @Final
    private double f_46014_;
    @Shadow
    @Final
    private double f_46015_;

    @Unique
    private void NT$setExplosionParticles(BlockPos blockPos) {
        double randX = (float)blockPos.m_123341_() + this.f_46012_.m_213780_().m_188501_();
        double randY = (float)blockPos.m_123342_() + this.f_46012_.m_213780_().m_188501_();
        double randZ = (float)blockPos.m_123343_() + this.f_46012_.m_213780_().m_188501_();
        double dx = randX - this.f_46013_;
        double dy = randY - this.f_46014_;
        double dz = randZ - this.f_46015_;
        double magnitude = Mth.m_184648_((double)dx, (double)dy, (double)dz);
        dx /= magnitude;
        dy /= magnitude;
        dz /= magnitude;
        double rand = 0.5 / (magnitude / (double)this.f_46017_ + 0.1) * (double)this.f_46012_.m_213780_().m_188501_() * (double)this.f_46012_.m_213780_().m_188501_() + (double)0.3f;
        this.f_46012_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (randX + this.f_46013_) / 2.0, (randY + this.f_46014_) / 2.0, (randZ + this.f_46015_) / 2.0, dx *= rand, dy *= rand, dz *= rand);
        this.f_46012_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, randX, randY, randZ, dx, dy, dz);
    }

    @Redirect(method={"finalizeExplosion"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V"))
    private void NT$onFinalizeExplosion(Level instance, ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        if (ModConfig.Candy.oldExplosionParticles() && !ModConfig.Candy.oldMixedExplosionParticles()) {
            return;
        }
        instance.m_7106_(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    @Inject(method={"finalizeExplosion"}, at={@At(value="HEAD")})
    private void NT$onSpawnInitParticles(boolean spawnParticles, CallbackInfo callback) {
        if (!ModConfig.Candy.unoptimizedExplosionParticles()) {
            return;
        }
        ObjectArrayList blocks = new ObjectArrayList();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    float border;
                    if (x != 0 && x != 15 && y != 0 && y != 15 && z != 0 && z != 15) continue;
                    double dx = (float)x / 15.0f * 2.0f - 1.0f;
                    double dy = (float)y / 15.0f * 2.0f - 1.0f;
                    double dz = (float)z / 15.0f * 2.0f - 1.0f;
                    double magnitude = Mth.m_184648_((double)dx, (double)dy, (double)dz);
                    dx /= magnitude;
                    dy /= magnitude;
                    dz /= magnitude;
                    double posX = this.f_46013_;
                    double posY = this.f_46014_;
                    double posZ = this.f_46015_;
                    for (float i = border = this.f_46017_ * (0.7f + this.f_46012_.f_46441_.m_188501_() * 0.6f); i > 0.0f; i -= 0.225f) {
                        if (Math.random() > 0.96) {
                            blocks.add((Object)new BlockPos(posX, posY, posZ));
                        }
                        posX += dx * (double)0.3f;
                        posY += dy * (double)0.3f;
                        posZ += dz * (double)0.3f;
                    }
                }
            }
        }
        Util.m_214673_((ObjectArrayList)blocks, (RandomSource)this.f_46012_.f_46441_);
        for (BlockPos blockPos : blocks) {
            this.NT$setExplosionParticles(blockPos);
        }
    }

    @Inject(method={"finalizeExplosion"}, locals=LocalCapture.CAPTURE_FAILSOFT, at={@At(shift=At.Shift.AFTER, value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getBlock()Lnet/minecraft/world/level/block/Block;")})
    private void NT$onSpawnParticles(boolean spawnParticles, CallbackInfo callback, boolean damageTerrain, ObjectArrayList<?> list, boolean isSourcePlayer, ObjectListIterator<?> iterator, BlockPos blockPos) {
        if (ModConfig.Candy.unoptimizedExplosionParticles() || !ModConfig.Candy.oldExplosionParticles() || !spawnParticles) {
            return;
        }
        this.NT$setExplosionParticles(blockPos);
    }
}

